/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import org.esa.beam.framework.dataop.dem.ElevationModelDescriptor;
import org.esa.beam.framework.dataop.dem.ElevationModelRegistry;
import org.esa.beam.framework.param.ParamChangeEvent;
import org.esa.beam.framework.param.ParamChangeListener;
import org.esa.beam.framework.param.ParamParseException;
import org.esa.beam.framework.param.ParamValidateException;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.framework.param.editors.RadioButtonEditor;
import org.esa.beam.framework.ui.GridBagUtils;

public class DemSelector
extends JPanel {
    private Parameter _paramProductDem;
    private Parameter _paramExternalDem;
    private Parameter _paramDem;

    public DemSelector() {
        this((ParamChangeListener)null);
    }

    public DemSelector(ParamChangeListener paramChangeListener) {
        this.createParameter(paramChangeListener);
        this.createUI();
        this.updateUIState();
    }

    public boolean isUsingProductDem() {
        return (Boolean)this._paramProductDem.getValue();
    }

    public void setUsingProductDem(boolean usingProductDem) throws ParamValidateException {
        this._paramProductDem.setValue((Object)usingProductDem);
    }

    public boolean isUsingExternalDem() {
        return (Boolean)this._paramExternalDem.getValue();
    }

    public void setUsingExternalDem(boolean usingExternalDem) throws ParamValidateException {
        this._paramExternalDem.setValue((Object)usingExternalDem);
    }

    public String getDemName() {
        return this._paramDem.getValueAsText();
    }

    public void setDemName(String demName) throws ParamValidateException, ParamParseException {
        this._paramDem.setValueAsText(demName);
    }

    private void createUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder("Digital Elevation Model (DEM)"));
        GridBagConstraints gbc = GridBagUtils.createDefaultConstraints();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this._paramProductDem.getEditor().getComponent());
        buttonGroup.add((AbstractButton)this._paramExternalDem.getEditor().getComponent());
        GridBagUtils.setAttributes(gbc, "insets.top=3, fill=HORIZONTAL");
        ++gbc.gridy;
        GridBagUtils.addToPanel(this, this._paramProductDem.getEditor().getComponent(), gbc);
        ++gbc.gridy;
        GridBagUtils.addToPanel(this, this._paramExternalDem.getEditor().getComponent(), gbc, "weightx=1");
        GridBagUtils.addToPanel(this, this._paramDem.getEditor().getComponent(), gbc, "weightx=999");
    }

    private void updateUIState() {
        this._paramDem.setUIEnabled(this.isUsingExternalDem());
    }

    private void createParameter(final ParamChangeListener delegate) {
        ParamChangeListener paramChangeListener = new ParamChangeListener(){

            public void parameterValueChanged(ParamChangeEvent event) {
                DemSelector.this.updateUIState();
                if (delegate != null) {
                    delegate.parameterValueChanged(event);
                }
            }
        };
        this._paramProductDem = new Parameter("useProductDem", (Object)Boolean.FALSE);
        this._paramProductDem.getProperties().setLabel("Use elevation from tie-points");
        this._paramProductDem.getProperties().setEditorClass(RadioButtonEditor.class);
        this._paramProductDem.addParamChangeListener(paramChangeListener);
        this._paramExternalDem = new Parameter("useExternalDem", (Object)Boolean.TRUE);
        this._paramExternalDem.getProperties().setLabel("Use external DEM");
        this._paramExternalDem.getProperties().setEditorClass(RadioButtonEditor.class);
        this._paramExternalDem.addParamChangeListener(paramChangeListener);
        ElevationModelDescriptor[] descriptors = ElevationModelRegistry.getInstance().getAllDescriptors();
        String[] demValueSet = new String[descriptors.length];
        for (int i = 0; i < descriptors.length; ++i) {
            demValueSet[i] = descriptors[i].getName();
        }
        this._paramDem = new Parameter("dem", (Object)"");
        this._paramDem.getProperties().setLabel("Elevation Model:");
        this._paramDem.getProperties().setValueSetBound(true);
        if (demValueSet.length != 0) {
            this._paramDem.setValue((Object)demValueSet[0], null);
            this._paramDem.getProperties().setValueSet(demValueSet);
        }
        this._paramDem.addParamChangeListener(paramChangeListener);
    }
}

