/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class FloatCellEditor
extends DefaultCellEditor {
    private Border defaultBorder;
    private float minValue;
    private float maxValue;

    public FloatCellEditor() {
        this(Float.MIN_VALUE, Float.MAX_VALUE);
    }

    public FloatCellEditor(float minValue, float maxValue) {
        super(new JTextField());
        this.minValue = minValue;
        this.maxValue = maxValue;
        JTextField textField = (JTextField)this.getComponent();
        this.defaultBorder = textField.getBorder();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JComponent component = (JComponent)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        JTextField textField = (JTextField)component;
        textField.selectAll();
        textField.setBorder(this.defaultBorder);
        textField.setHorizontalAlignment(4);
        return component;
    }

    @Override
    public boolean stopCellEditing() {
        float value;
        JTextField textField = (JTextField)this.getComponent();
        try {
            value = Float.parseFloat(textField.getText());
        }
        catch (NumberFormatException ignored) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
            return false;
        }
        boolean validValue = this.validateValue(value);
        if (!validValue) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
            return false;
        }
        if (!super.stopCellEditing()) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
            return false;
        }
        return true;
    }

    protected boolean validateValue(float value) {
        return value >= this.minValue && value <= this.maxValue;
    }

    @Override
    public Object getCellEditorValue() {
        JTextField textField = (JTextField)this.getComponent();
        try {
            return Float.valueOf(Float.parseFloat(textField.getText()));
        }
        catch (NumberFormatException ignored) {
            return Float.valueOf(Float.NaN);
        }
    }
}

