/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.esa.beam.framework.ui.PixelInfoState;
import org.esa.beam.framework.ui.PixelInfoViewModelUpdater;
import org.esa.beam.framework.ui.product.ProductSceneView;

class PixelInfoUpdateService {
    private final PixelInfoViewModelUpdater modelUpdater;
    private final ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture<?> updaterFuture;
    private PixelInfoState state;
    private boolean needUpdate;
    private int numUnchangedStates;
    private Runnable updaterRunnable;

    PixelInfoUpdateService(PixelInfoViewModelUpdater modelUpdater) {
        this.modelUpdater = modelUpdater;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.state = PixelInfoState.INVALID;
        this.updaterRunnable = new UpdaterRunnable();
    }

    synchronized void updateState(ProductSceneView view, int pixelX, int pixelY, int level, boolean pixelPosValid) {
        if (!this.state.equals(view, pixelX, pixelY, level, pixelPosValid)) {
            this.state = new PixelInfoState(view, pixelX, pixelY, level, pixelPosValid);
            this.needUpdate = true;
            this.assertTimerStarted();
        }
    }

    synchronized void requestUpdate() {
        if (this.state == PixelInfoState.INVALID) {
            return;
        }
        this.needUpdate = true;
        this.assertTimerStarted();
    }

    synchronized void clearState() {
        this.state = PixelInfoState.INVALID;
    }

    private void assertTimerStarted() {
        if (this.updaterFuture == null) {
            this.updaterFuture = this.scheduledExecutorService.scheduleAtFixedRate(this.updaterRunnable, 100L, 100L, TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void stopTimer() {
        if (this.updaterFuture != null) {
            this.updaterFuture.cancel(true);
            this.updaterFuture = null;
        }
        this.clearState();
    }

    private class UpdaterRunnable
    implements Runnable {
        private UpdaterRunnable() {
        }

        @Override
        public void run() {
            if (PixelInfoUpdateService.this.state == PixelInfoState.INVALID) {
                return;
            }
            if (PixelInfoUpdateService.this.needUpdate) {
                PixelInfoUpdateService.this.numUnchangedStates = 0;
                PixelInfoUpdateService.this.needUpdate = false;
                try {
                    PixelInfoUpdateService.this.modelUpdater.update(PixelInfoUpdateService.this.state);
                }
                catch (Throwable throwable) {}
            } else {
                PixelInfoUpdateService.this.numUnchangedStates++;
                if (PixelInfoUpdateService.this.numUnchangedStates > 100) {
                    PixelInfoUpdateService.this.stopTimer();
                }
            }
        }
    }
}

