/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import com.bc.swing.dock.DockablePane;
import com.bc.swing.dock.FloatingComponentFactory;
import com.bc.swing.dock.FloatingDockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.swing.JideSplitPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeEvent;
import org.esa.beam.framework.datamodel.ProductNodeListener;
import org.esa.beam.framework.datamodel.ProductNodeListenerAdapter;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.help.HelpSys;
import org.esa.beam.framework.ui.BasicApp;
import org.esa.beam.framework.ui.PixelInfoUpdateService;
import org.esa.beam.framework.ui.PixelInfoViewModelUpdater;
import org.esa.beam.framework.ui.PixelInfoViewTableModel;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.product.ProductSceneView;

public class PixelInfoView
extends JPanel {
    public static final String HELP_ID = "pixelInfoView";
    public static final String PROPERTY_KEY_SHOW_ONLY_DISPLAYED_BAND_PIXEL_VALUES = "pixelview.showOnlyDisplayedBands";
    public static final boolean PROPERTY_DEFAULT_SHOW_DISPLAYED_BAND_PIXEL_VALUES = true;
    private static final int _NAME_COLUMN = 0;
    private static final int _VALUE_COLUMN = 1;
    private static final int _UNIT_COLUMN = 2;
    private JideSplitPane multiSplitPane;
    private boolean showGeoPosDecimal;
    private final PropertyChangeListener _displayFilterListener;
    private final ProductNodeListener _productNodeListener;
    private DockablePane geolocInfoPane;
    private DockablePane scanLineInfoPane;
    private DockablePane bandPixelInfoPane;
    private DockablePane tiePointGridPixelInfoPane;
    private DockablePane flagPixelInfoPane;
    private boolean _showPixelPosDecimals;
    private float _pixelOffsetX;
    private float _pixelOffsetY;
    private DisplayFilter _displayFilter;
    private final BasicApp app;
    private Map<DockablePaneKey, DockablePane> dockablePaneMap;
    private final PixelInfoViewTableModel geolocModel;
    private final PixelInfoViewTableModel scanlineModel;
    private final PixelInfoViewTableModel bandModel;
    private final PixelInfoViewTableModel tiePointModel;
    private final PixelInfoViewTableModel flagModel;
    private final PixelInfoViewModelUpdater modelUpdater;
    private final PixelInfoUpdateService updateService;

    public PixelInfoView(BasicApp app) {
        super(new BorderLayout());
        this.app = app;
        this._displayFilterListener = this.createDisplayFilterListener();
        this._productNodeListener = this.createProductNodeListener();
        this.dockablePaneMap = new HashMap<DockablePaneKey, DockablePane>(5);
        this.geolocModel = new PixelInfoViewTableModel(new String[]{"Coordinate", "Value", "Unit"});
        this.scanlineModel = new PixelInfoViewTableModel(new String[]{"Time", "Value", "Unit"});
        this.bandModel = new PixelInfoViewTableModel(new String[]{"Band", "Value", "Unit"});
        this.tiePointModel = new PixelInfoViewTableModel(new String[]{"Tie Point Grid", "Value", "Unit"});
        this.flagModel = new PixelInfoViewTableModel(new String[]{"Flag", "Value"});
        this.modelUpdater = new PixelInfoViewModelUpdater(this.geolocModel, this.scanlineModel, this.bandModel, this.tiePointModel, this.flagModel, this);
        this.updateService = new PixelInfoUpdateService(this.modelUpdater);
        this.createUI();
    }

    ProductNodeListener getProductNodeListener() {
        return this._productNodeListener;
    }

    private ProductNodeListener createProductNodeListener() {
        return new ProductNodeListenerAdapter(){

            public void nodeChanged(ProductNodeEvent event) {
                PixelInfoView.this.updateService.requestUpdate();
            }

            public void nodeAdded(ProductNodeEvent event) {
                PixelInfoView.this.updateService.requestUpdate();
            }

            public void nodeRemoved(ProductNodeEvent event) {
                PixelInfoView.this.updateService.requestUpdate();
            }
        };
    }

    private PropertyChangeListener createDisplayFilterListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (PixelInfoView.this.getCurrentProduct() != null) {
                    PixelInfoView.this.updateService.requestUpdate();
                    PixelInfoView.this.clearSelectionInRasterTables();
                }
            }
        };
    }

    public Product getCurrentProduct() {
        return this.modelUpdater.getCurrentProduct();
    }

    public RasterDataNode getCurrentRaster() {
        return this.modelUpdater.getCurrentRaster();
    }

    public void setDisplayFilter(DisplayFilter displayFilter) {
        if (this._displayFilter != displayFilter) {
            if (this._displayFilter != null) {
                this._displayFilter.removePropertyChangeListener(this._displayFilterListener);
            }
            this._displayFilter = displayFilter;
            this._displayFilter.addPropertyChangeListener(this._displayFilterListener);
        }
    }

    public DisplayFilter getDisplayFilter() {
        return this._displayFilter;
    }

    public void setShowPixelPosDecimals(boolean showPixelPosDecimals) {
        if (this._showPixelPosDecimals != showPixelPosDecimals) {
            this._showPixelPosDecimals = showPixelPosDecimals;
            this.updateService.requestUpdate();
        }
    }

    boolean showPixelPosDecimal() {
        return this._showPixelPosDecimals;
    }

    public void setShowGeoPosDecimal(boolean showGeoPosDecimal) {
        if (this.showGeoPosDecimal != showGeoPosDecimal) {
            this.showGeoPosDecimal = showGeoPosDecimal;
            this.updateService.requestUpdate();
        }
    }

    boolean showGeoPosDecimal() {
        return this.showGeoPosDecimal;
    }

    public void setPixelOffsetX(float pixelOffsetX) {
        if (this._pixelOffsetX != pixelOffsetX) {
            this._pixelOffsetX = pixelOffsetX;
            this.updateService.requestUpdate();
        }
    }

    float getPixelOffsetX() {
        return this._pixelOffsetX;
    }

    public void setPixelOffsetY(float pixelOffsetY) {
        if (this._pixelOffsetY != pixelOffsetY) {
            this._pixelOffsetY = pixelOffsetY;
            this.updateService.requestUpdate();
        }
    }

    float getPixelOffsetY() {
        return this._pixelOffsetY;
    }

    public void updatePixelValues(ProductSceneView view, int pixelX, int pixelY, int level, boolean pixelPosValid) {
        this.updateService.updateState(view, pixelX, pixelY, level, pixelPosValid);
    }

    public boolean isAnyDockablePaneVisible() {
        for (DockablePaneKey paneKey : this.dockablePaneMap.keySet()) {
            if (!this.isDockablePaneVisible(paneKey)) continue;
            return true;
        }
        return false;
    }

    public void showDockablePanel(DockablePaneKey key, boolean show) {
        DockablePane dockablePane = this.dockablePaneMap.get((Object)key);
        if (this.multiSplitPane.indexOfPane((Component)dockablePane) < 0 && show) {
            this.multiSplitPane.addPane((Component)dockablePane);
            this.multiSplitPane.invalidate();
        }
        dockablePane.setShown(show);
    }

    public DockablePane getDockablePane(DockablePaneKey key) {
        return this.dockablePaneMap.get((Object)key);
    }

    private void createUI() {
        this.geolocInfoPane = this.createDockablePane("Geo-location", 0, UIUtils.loadImageIcon("icons/WorldMap16.gif"), this.geolocModel);
        this.scanLineInfoPane = this.createDockablePane("Time Info", 1, UIUtils.loadImageIcon("icons/Clock16.gif"), this.scanlineModel);
        this.bandPixelInfoPane = this.createDockablePane("Bands", 2, UIUtils.loadImageIcon("icons/RsBandAsSwath16.gif"), this.bandModel);
        this.tiePointGridPixelInfoPane = this.createDockablePane("Tie Point Grids", 3, UIUtils.loadImageIcon("icons/RsBandAsTiePoint16.gif"), this.tiePointModel);
        this.flagPixelInfoPane = this.createDockablePane("Flags", 4, UIUtils.loadImageIcon("icons/RsBandFlags16.gif"), this.flagModel);
        this.geolocInfoPane.setPreferredSize(new Dimension(128, 128));
        this.scanLineInfoPane.setPreferredSize(new Dimension(128, 128));
        this.bandPixelInfoPane.setPreferredSize(new Dimension(128, 512));
        this.tiePointGridPixelInfoPane.setPreferredSize(new Dimension(128, 128));
        this.flagPixelInfoPane.setPreferredSize(new Dimension(128, 128));
        this.flagPixelInfoPane.setVisible(false);
        this.dockablePaneMap.put(DockablePaneKey.GEOLOCATION, this.geolocInfoPane);
        this.dockablePaneMap.put(DockablePaneKey.SCANLINE, this.scanLineInfoPane);
        this.dockablePaneMap.put(DockablePaneKey.TIEPOINTS, this.tiePointGridPixelInfoPane);
        this.dockablePaneMap.put(DockablePaneKey.BANDS, this.bandPixelInfoPane);
        this.dockablePaneMap.put(DockablePaneKey.FLAGS, this.flagPixelInfoPane);
        this.multiSplitPane = new JideSplitPane();
        this.multiSplitPane.setOrientation(0);
        this.multiSplitPane.addPane((Component)this.geolocInfoPane);
        this.multiSplitPane.addPane((Component)this.scanLineInfoPane);
        this.multiSplitPane.addPane((Component)this.tiePointGridPixelInfoPane);
        this.multiSplitPane.addPane((Component)this.bandPixelInfoPane);
        JTable flagsTable = PixelInfoView.getTable(this.flagPixelInfoPane);
        flagsTable.setDefaultRenderer(String.class, new FlagCellRenderer());
        flagsTable.setDefaultRenderer(Object.class, new FlagCellRenderer());
        this.addComponentListener();
        this.add((Component)this.multiSplitPane, "Center");
        HelpSys.enableHelpKey(this, HELP_ID);
    }

    private static JTable getTable(DockablePane pane) {
        return (JTable)((JScrollPane)pane.getContent()).getViewport().getView();
    }

    private void addComponentListener() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                PixelInfoView.this.setPreferredSize(PixelInfoView.this.getSize());
            }
        });
    }

    private DockablePane createDockablePane(String name, int index, ImageIcon icon, TableModel tableModel) {
        JTable table = new JTable(tableModel);
        table.setCellSelectionEnabled(false);
        table.setColumnSelectionAllowed(false);
        table.setRowSelectionAllowed(true);
        table.setTableHeader(null);
        table.removeEditor();
        JScrollPane scrollPane = new JScrollPane(table, 20, 30);
        scrollPane.setBorder(null);
        scrollPane.setViewportBorder(null);
        DockingManager dockingManager = this.app.getMainFrame().getDockingManager();
        FloatingComponentFactory componentFactory = FloatingDockableFrame.getFactory(dockingManager);
        return new DockablePane(name, (Icon)icon, (JComponent)scrollPane, index, true, componentFactory);
    }

    void clearSelectionInRasterTables() {
        String rasterName;
        JTable bandTable = PixelInfoView.getTable(this.bandPixelInfoPane);
        JTable tiePointGridTable = PixelInfoView.getTable(this.tiePointGridPixelInfoPane);
        bandTable.clearSelection();
        tiePointGridTable.clearSelection();
        RasterDataNode raster = this.modelUpdater.getCurrentRaster();
        if (raster != null && !this.selectCurrentRaster(rasterName = raster.getName(), bandTable)) {
            this.selectCurrentRaster(rasterName, tiePointGridTable);
        }
    }

    public void clearProductNodeRefs() {
        this.modelUpdater.clearProductNodeRefs();
        this.updateService.clearState();
    }

    boolean isDockablePaneVisible(DockablePaneKey key) {
        DockablePane dockablePane = this.dockablePaneMap.get((Object)key);
        return dockablePane.isContentShown();
    }

    private boolean selectCurrentRaster(String rasterName, JTable table) {
        TableModel model = table.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            String s = model.getValueAt(i, 0).toString();
            if (!rasterName.equals(s)) continue;
            table.changeSelection(i, 0, false, false);
            return true;
        }
        return false;
    }

    public static abstract class DisplayFilter {
        private final Vector<PropertyChangeListener> _pcl = new Vector();

        public abstract boolean accept(ProductNode var1);

        public void addPropertyChangeListener(PropertyChangeListener displayFilterListener) {
            if (displayFilterListener != null && !this._pcl.contains(displayFilterListener)) {
                this._pcl.add(displayFilterListener);
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener displayFilterListener) {
            if (displayFilterListener != null && this._pcl.contains(displayFilterListener)) {
                this._pcl.remove(displayFilterListener);
            }
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            for (int i = 0; i < this._pcl.size(); ++i) {
                this._pcl.elementAt(i).propertyChange(event);
            }
        }
    }

    private static class FlagCellRenderer
    extends DefaultTableCellRenderer {
        private FlagCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setForeground(Color.black);
            c.setBackground(Color.white);
            if (column == 1 && value != null) {
                if (value.equals("true")) {
                    c.setForeground(UIUtils.COLOR_DARK_RED);
                    Color very_light_blue = new Color(230, 230, 255);
                    c.setBackground(very_light_blue);
                } else if (value.equals("false")) {
                    c.setForeground(UIUtils.COLOR_DARK_BLUE);
                    Color very_light_red = new Color(255, 230, 230);
                    c.setBackground(very_light_red);
                }
            }
            return c;
        }
    }

    public static enum DockablePaneKey {
        GEOLOCATION,
        SCANLINE,
        BANDS,
        TIEPOINTS,
        FLAGS;

    }
}

