/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.util.Calendar;
import java.util.Vector;
import javax.media.jai.PlanarImage;
import javax.swing.SwingUtilities;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.MapGeoCoding;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeListener;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.dataop.maptransf.MapTransform;
import org.esa.beam.framework.ui.PixelInfoState;
import org.esa.beam.framework.ui.PixelInfoView;
import org.esa.beam.framework.ui.PixelInfoViewTableModel;
import org.esa.beam.framework.ui.product.ProductSceneView;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.math.MathUtils;
import org.geotools.geometry.DirectPosition2D;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

class PixelInfoViewModelUpdater {
    private static final String _INVALID_POS_TEXT = "Invalid pos.";
    private final PixelInfoViewTableModel geolocModel;
    private final PixelInfoViewTableModel scanlineModel;
    private final PixelInfoViewTableModel bandModel;
    private final PixelInfoViewTableModel tiePointModel;
    private final PixelInfoViewTableModel flagModel;
    private volatile Product currentProduct;
    private volatile RasterDataNode currentRaster;
    private volatile ProductSceneView currentView;
    private Band[] currentFlagBands;
    private int _pixelX;
    private int _pixelY;
    private int _level;
    private int levelZeroX;
    private int levelZeroY;
    private boolean _pixelPosValid;
    private final PixelInfoView pixelInfoView;

    PixelInfoViewModelUpdater(PixelInfoViewTableModel geolocModel, PixelInfoViewTableModel scanlineModel, PixelInfoViewTableModel bandModel, PixelInfoViewTableModel tiePointModel, PixelInfoViewTableModel flagModel, PixelInfoView pixelInfoView) {
        this.geolocModel = geolocModel;
        this.scanlineModel = scanlineModel;
        this.bandModel = bandModel;
        this.tiePointModel = tiePointModel;
        this.flagModel = flagModel;
        this.pixelInfoView = pixelInfoView;
    }

    Product getCurrentProduct() {
        return this.currentProduct;
    }

    RasterDataNode getCurrentRaster() {
        return this.currentRaster;
    }

    void update(PixelInfoState state) {
        this.update(state.view, state.pixelX, state.pixelY, state.level, state.pixelPosValid);
    }

    void update(ProductSceneView view, int pixelX, int pixelY, int level, boolean pixelPosValid) {
        Guardian.assertNotNull((String)"view", (Object)view);
        boolean clearRasterTableSelection = false;
        RasterDataNode raster = view.getRaster();
        Product product = raster.getProduct();
        if (product == this.currentProduct && view.isRGB()) {
            this.resetBandTableModel();
        }
        if (product != this.currentProduct) {
            ProductNodeListener productNodeListener = this.pixelInfoView.getProductNodeListener();
            if (this.currentProduct != null) {
                this.currentProduct.removeProductNodeListener(productNodeListener);
            }
            product.addProductNodeListener(productNodeListener);
            this.currentProduct = product;
            this.registerFlagDatasets();
            this.resetTableModels();
        }
        if (raster != this.currentRaster) {
            this.currentRaster = raster;
            this.registerFlagDatasets();
            this.resetTableModels();
        }
        if (this.bandModel.getRowCount() != this.getBandRowCount()) {
            this.resetTableModels();
        }
        if (view != this.currentView) {
            this.currentView = view;
            this.resetTableModels();
            clearRasterTableSelection = true;
        }
        this._pixelX = pixelX;
        this._pixelY = pixelY;
        this._level = level;
        this._pixelPosValid = pixelPosValid;
        AffineTransform i2mTransform = this.currentView.getBaseImageLayer().getImageToModelTransform(level);
        Point2D modelP = i2mTransform.transform(new Point2D.Double((double)pixelX + 0.5, (double)pixelY + 0.5), null);
        AffineTransform m2iTransform = view.getBaseImageLayer().getModelToImageTransform();
        Point2D levelZeroP = m2iTransform.transform(modelP, null);
        this.levelZeroX = (int)Math.floor(levelZeroP.getX());
        this.levelZeroY = (int)Math.floor(levelZeroP.getY());
        this.updateDataDisplay(clearRasterTableSelection);
    }

    private void resetTableModels() {
        this.resetGeolocTableModel();
        this.resetScanLineTableModel();
        this.resetBandTableModel();
        this.resetTiePointGridTableModel();
        this.resetFlagTableModel();
    }

    private void fireTableChanged(final boolean clearRasterTableSelection) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (clearRasterTableSelection) {
                    PixelInfoViewModelUpdater.this.pixelInfoView.clearSelectionInRasterTables();
                }
                PixelInfoViewModelUpdater.this.geolocModel.fireTableDataChanged();
                PixelInfoViewModelUpdater.this.scanlineModel.fireTableDataChanged();
                PixelInfoViewModelUpdater.this.bandModel.fireTableDataChanged();
                PixelInfoViewModelUpdater.this.tiePointModel.fireTableDataChanged();
                PixelInfoViewModelUpdater.this.flagModel.fireTableDataChanged();
            }
        });
    }

    private void updateDataDisplay(boolean clearRasterTableSelection) {
        if (this.currentProduct == null) {
            return;
        }
        if (this.pixelInfoView.isDockablePaneVisible(PixelInfoView.DockablePaneKey.GEOLOCATION)) {
            this.updateGeolocValues();
        }
        if (this.pixelInfoView.isDockablePaneVisible(PixelInfoView.DockablePaneKey.SCANLINE)) {
            this.updateScanLineValues();
        }
        if (this.pixelInfoView.isDockablePaneVisible(PixelInfoView.DockablePaneKey.BANDS)) {
            this.updateBandPixelValues();
        }
        if (this.pixelInfoView.isDockablePaneVisible(PixelInfoView.DockablePaneKey.TIEPOINTS)) {
            this.updateTiePointGridPixelValues();
        }
        if (this.pixelInfoView.isDockablePaneVisible(PixelInfoView.DockablePaneKey.FLAGS)) {
            this.updateFlagPixelValues();
        }
        this.fireTableChanged(clearRasterTableSelection);
    }

    private void resetGeolocTableModel() {
        this.geolocModel.clear();
        if (this.currentRaster != null) {
            GeoCoding geoCoding = this.currentRaster.getGeoCoding();
            this.geolocModel.addRow("Image-X", "", "pixel");
            this.geolocModel.addRow("Image-Y", "", "pixel");
            if (geoCoding != null) {
                this.geolocModel.addRow("Longitude", "", "degree");
                this.geolocModel.addRow("Latitude", "", "degree");
                if (geoCoding instanceof MapGeoCoding) {
                    MapGeoCoding mapGeoCoding = (MapGeoCoding)geoCoding;
                    String mapUnit = mapGeoCoding.getMapInfo().getMapProjection().getMapUnit();
                    this.geolocModel.addRow("Map-X", "", mapUnit);
                    this.geolocModel.addRow("Map-Y", "", mapUnit);
                } else if (geoCoding instanceof CrsGeoCoding) {
                    String xAxisUnit = geoCoding.getMapCRS().getCoordinateSystem().getAxis(0).getUnit().toString();
                    String yAxisUnit = geoCoding.getMapCRS().getCoordinateSystem().getAxis(1).getUnit().toString();
                    this.geolocModel.addRow("Map-X", "", xAxisUnit);
                    this.geolocModel.addRow("Map-Y", "", yAxisUnit);
                }
            }
        }
    }

    private void resetScanLineTableModel() {
        this.scanlineModel.clear();
        if (this.currentRaster != null) {
            this.scanlineModel.addRow("Date", "", "YYYY-MM-DD");
            this.scanlineModel.addRow("Time (UTC)", "", "HH:MM:SS:mm [AM/PM]");
        }
    }

    private void resetBandTableModel() {
        this.bandModel.clear();
        if (this.currentRaster != null) {
            int numBands = this.currentProduct.getNumBands();
            for (int i = 0; i < numBands; ++i) {
                Band band = this.currentProduct.getBandAt(i);
                if (!this.shouldDisplayBand(band)) continue;
                this.bandModel.addRow(band.getName(), "", band.getUnit());
            }
        }
    }

    private boolean shouldDisplayBand(Band band) {
        PixelInfoView.DisplayFilter displayFilter = this.pixelInfoView.getDisplayFilter();
        if (displayFilter != null) {
            return displayFilter.accept((ProductNode)band);
        }
        return band.hasRasterData();
    }

    private void resetTiePointGridTableModel() {
        this.tiePointModel.clear();
        if (this.currentRaster != null) {
            int numTiePointGrids = this.currentProduct.getNumTiePointGrids();
            for (int i = 0; i < numTiePointGrids; ++i) {
                TiePointGrid tiePointGrid = this.currentProduct.getTiePointGridAt(i);
                this.tiePointModel.addRow(tiePointGrid.getName(), "", tiePointGrid.getUnit());
            }
        }
    }

    private void resetFlagTableModel() {
        this.flagModel.clear();
        if (this.currentRaster != null) {
            for (Band band : this.currentFlagBands) {
                FlagCoding flagCoding = band.getFlagCoding();
                int numFlags = flagCoding.getNumAttributes();
                String bandNameDot = band.getName() + ".";
                for (int j = 0; j < numFlags; ++j) {
                    String name = bandNameDot + flagCoding.getAttributeAt(j).getName();
                    this.flagModel.addRow(name, "", "");
                }
            }
        }
    }

    private void registerFlagDatasets() {
        Band[] bands = this.currentProduct.getBands();
        Vector<Band> flagBandsVector = new Vector<Band>();
        for (Band band : bands) {
            if (!this.isFlagBand(band)) continue;
            flagBandsVector.add(band);
        }
        this.currentFlagBands = flagBandsVector.toArray(new Band[flagBandsVector.size()]);
    }

    private boolean isFlagBand(Band band) {
        return band.getFlagCoding() != null;
    }

    private int getBandRowCount() {
        int rowCount = 0;
        if (this.currentProduct != null) {
            Band[] bands;
            for (Band band : bands = this.currentProduct.getBands()) {
                if (!this.shouldDisplayBand(band)) continue;
                ++rowCount;
            }
        }
        return rowCount;
    }

    private int getFlagRowCount() {
        int rowCount = 0;
        for (Band band : this.currentFlagBands) {
            rowCount += band.getFlagCoding().getNumAttributes();
        }
        return rowCount;
    }

    private void updateGeolocValues() {
        boolean available = this.isSampleValueAvailable(this.levelZeroX, this.levelZeroY, this._pixelPosValid);
        float pX = (float)this.levelZeroX + this.pixelInfoView.getPixelOffsetX();
        float pY = (float)this.levelZeroY + this.pixelInfoView.getPixelOffsetY();
        String tgy = _INVALID_POS_TEXT;
        String tgx = _INVALID_POS_TEXT;
        String tmy = _INVALID_POS_TEXT;
        String tmx = _INVALID_POS_TEXT;
        String tiy = _INVALID_POS_TEXT;
        String tix = _INVALID_POS_TEXT;
        GeoCoding geoCoding = this.currentRaster.getGeoCoding();
        if (available) {
            PixelPos pixelPos = new PixelPos(pX, pY);
            if (this.pixelInfoView.showPixelPosDecimal()) {
                tix = String.valueOf(pX);
                tiy = String.valueOf(pY);
            } else {
                tix = String.valueOf(this.levelZeroX);
                tiy = String.valueOf(this.levelZeroY);
            }
            if (geoCoding != null) {
                GeoPos geoPos = geoCoding.getGeoPos(pixelPos, null);
                if (this.pixelInfoView.showGeoPosDecimal()) {
                    tgx = String.valueOf(geoPos.getLon());
                    tgy = String.valueOf(geoPos.getLat());
                } else {
                    tgx = geoPos.getLonString();
                    tgy = geoPos.getLatString();
                }
                if (geoCoding instanceof MapGeoCoding) {
                    MapGeoCoding mapGeoCoding = (MapGeoCoding)geoCoding;
                    MapTransform mapTransform = mapGeoCoding.getMapInfo().getMapProjection().getMapTransform();
                    Point2D mapPoint = mapTransform.forward(geoPos, null);
                    tmx = String.valueOf(MathUtils.round((double)mapPoint.getX(), (double)10000.0));
                    tmy = String.valueOf(MathUtils.round((double)mapPoint.getY(), (double)10000.0));
                } else if (geoCoding instanceof CrsGeoCoding) {
                    MathTransform transform = geoCoding.getImageToMapTransform();
                    try {
                        DirectPosition position = transform.transform((DirectPosition)new DirectPosition2D((double)pX, (double)pY), null);
                        double[] coordinate = position.getCoordinate();
                        tmx = String.valueOf(coordinate[0]);
                        tmy = String.valueOf(coordinate[1]);
                    }
                    catch (TransformException ignore) {
                        // empty catch block
                    }
                }
            }
        }
        this.geolocModel.updateValue(tix, 0);
        this.geolocModel.updateValue(tiy, 1);
        if (geoCoding != null) {
            this.geolocModel.updateValue(tgx, 2);
            this.geolocModel.updateValue(tgy, 3);
            if (geoCoding instanceof MapGeoCoding || geoCoding instanceof CrsGeoCoding) {
                this.geolocModel.updateValue(tmx, 4);
                this.geolocModel.updateValue(tmy, 5);
            }
        }
    }

    private void updateScanLineValues() {
        ProductData.UTC utcStartTime = this.currentProduct.getStartTime();
        ProductData.UTC utcEndTime = this.currentProduct.getEndTime();
        if (utcStartTime == null || utcEndTime == null || !this.isSampleValueAvailable(0, this.levelZeroY, true)) {
            this.scanlineModel.updateValue("No date information", 0);
            this.scanlineModel.updateValue("No time information", 1);
        } else {
            float pY = (float)this.levelZeroY + this.pixelInfoView.getPixelOffsetY();
            ProductData.UTC utcCurrentLine = ProductUtils.getScanLineTime((Product)this.currentProduct, (double)pY);
            Calendar currentLineTime = utcCurrentLine.getAsCalendar();
            String dateString = String.format("%1$tF", currentLineTime);
            String timeString = String.format("%1$tI:%1$tM:%1$tS:%1$tL %1$Tp", currentLineTime);
            this.scanlineModel.updateValue(dateString, 0);
            this.scanlineModel.updateValue(timeString, 1);
        }
    }

    private void updateBandPixelValues() {
        Band[] bands = this.currentProduct.getBands();
        int rowIndex = 0;
        for (Band band : bands) {
            if (!this.shouldDisplayBand(band)) continue;
            this.bandModel.updateValue(this.getPixelString(band), rowIndex);
            ++rowIndex;
        }
    }

    private String getPixelString(Band band) {
        if (!this._pixelPosValid) {
            return _INVALID_POS_TEXT;
        }
        if (this.isPixelValid(band, this._pixelX, this._pixelY, this._level)) {
            if (band.isFloatingPointType()) {
                return String.valueOf((float)ProductUtils.getGeophysicalSampleDouble((Band)band, (int)this._pixelX, (int)this._pixelY, (int)this._level));
            }
            return String.valueOf(ProductUtils.getGeophysicalSampleLong((Band)band, (int)this._pixelX, (int)this._pixelY, (int)this._level));
        }
        return "NaN";
    }

    private boolean isPixelValid(Band band, int pixelX, int pixelY, int level) {
        if (band.isValidMaskUsed()) {
            PlanarImage image = ImageManager.getInstance().getValidMaskImage((RasterDataNode)band, level);
            Raster data = this.getRasterTile(image, pixelX, pixelY);
            return data.getSample(pixelX, pixelY, 0) != 0;
        }
        return true;
    }

    private Raster getRasterTile(PlanarImage image, int pixelX, int pixelY) {
        int tileX = image.XToTileX(pixelX);
        int tileY = image.YToTileY(pixelY);
        return image.getTile(tileX, tileY);
    }

    private void updateTiePointGridPixelValues() {
        int numTiePointGrids = this.currentProduct.getNumTiePointGrids();
        int rowIndex = 0;
        for (int i = 0; i < numTiePointGrids; ++i) {
            TiePointGrid grid = this.currentProduct.getTiePointGridAt(i);
            this.tiePointModel.updateValue(grid.getPixelString(this.levelZeroX, this.levelZeroY), rowIndex);
            ++rowIndex;
        }
    }

    private void updateFlagPixelValues() {
        boolean available = this.isSampleValueAvailable(this.levelZeroX, this.levelZeroY, this._pixelPosValid);
        if (this.flagModel.getRowCount() != this.getFlagRowCount()) {
            this.resetFlagTableModel();
        }
        int rowIndex = 0;
        for (Band band : this.currentFlagBands) {
            long pixelValue = available ? ProductUtils.getGeophysicalSampleLong((Band)band, (int)this._pixelX, (int)this._pixelY, (int)this._level) : 0L;
            for (int j = 0; j < band.getFlagCoding().getNumAttributes(); ++j) {
                if (available) {
                    MetadataAttribute attribute = band.getFlagCoding().getAttributeAt(j);
                    int mask = attribute.getData().getElemInt();
                    this.flagModel.updateValue(String.valueOf((pixelValue & (long)mask) == (long)mask), rowIndex);
                } else {
                    this.flagModel.updateValue(_INVALID_POS_TEXT, rowIndex);
                }
                ++rowIndex;
            }
        }
    }

    private boolean isSampleValueAvailable(int pixelX, int pixelY, boolean pixelValid) {
        return this.currentProduct != null && pixelValid && pixelX >= 0 && pixelY >= 0 && pixelX < this.currentProduct.getSceneRasterWidth() && pixelY < this.currentProduct.getSceneRasterHeight();
    }

    void clearProductNodeRefs() {
        this.currentProduct = null;
        this.currentRaster = null;
        this.currentView = null;
        this.currentFlagBands = new Band[0];
    }
}

