/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class PixelInfoViewTableModel
extends AbstractTableModel {
    private final String[] columnNames;
    private final List<String> names;
    private final List<String> values;
    private final List<String> units;

    public PixelInfoViewTableModel(String[] columnNames) {
        this.columnNames = columnNames;
        this.names = Collections.synchronizedList(new ArrayList(32));
        this.values = Collections.synchronizedList(new ArrayList(32));
        this.units = Collections.synchronizedList(new ArrayList(32));
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.names.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.names.get(rowIndex);
        }
        if (columnIndex == 1) {
            return this.values.get(rowIndex);
        }
        if (columnIndex == 2) {
            return this.units.get(rowIndex);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(String name, String value, String unit) {
        PixelInfoViewTableModel pixelInfoViewTableModel = this;
        synchronized (pixelInfoViewTableModel) {
            this.names.add(name);
            this.values.add(value);
            this.units.add(unit);
        }
    }

    public void updateValue(String aValue, int row) {
        this.values.set(row, aValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        PixelInfoViewTableModel pixelInfoViewTableModel = this;
        synchronized (pixelInfoViewTableModel) {
            this.names.clear();
            this.values.clear();
            this.units.clear();
        }
    }
}

