/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.esa.beam.framework.ui.PopupMenuFactory;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.util.Guardian;

public class PopupMenuHandler
implements MouseListener,
KeyListener {
    private PopupMenuFactory _popupMenuFactory;

    public PopupMenuHandler(PopupMenuFactory popupMenuFactory) {
        Guardian.assertNotNull((String)"popupMenuFactory", (Object)popupMenuFactory);
        this._popupMenuFactory = popupMenuFactory;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.maybeShowPopupMenu(event);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.maybeShowPopupMenu(event);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.maybeShowPopupMenu(event);
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.maybeShowPopupMenu(event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
        this.maybeShowPopupMenu(event);
    }

    private void maybeShowPopupMenu(MouseEvent event) {
        if (event.isPopupTrigger() && event.getComponent().isVisible()) {
            this.showPopupMenu(event);
        }
    }

    private void maybeShowPopupMenu(KeyEvent event) {
    }

    private void showPopupMenu(MouseEvent event) {
        JPopupMenu popupMenu = this._popupMenuFactory.createPopupMenu(event.getComponent());
        if (popupMenu == null) {
            popupMenu = this._popupMenuFactory.createPopupMenu(event);
        }
        if (popupMenu != null) {
            this.rearrangeMenuItems(popupMenu);
            UIUtils.showPopup(popupMenu, event);
        }
    }

    private void rearrangeMenuItems(JPopupMenu popupMenu) {
        Component[] components = popupMenu.getComponents();
        Arrays.sort(components, new Comparator<Component>(){

            @Override
            public int compare(Component o1, Component o2) {
                return PopupMenuHandler.this.getGroupName(o1).compareToIgnoreCase(PopupMenuHandler.this.getGroupName(o2));
            }
        });
        popupMenu.removeAll();
        Component lastComponent = null;
        String lastGroupName = null;
        for (Component component : components) {
            String groupName = this.getGroupName(component);
            if (lastGroupName != null && !lastGroupName.equals(groupName) && !(lastComponent instanceof JSeparator)) {
                popupMenu.addSeparator();
            }
            lastGroupName = groupName;
            lastComponent = component;
            if (component instanceof JMenuItem) {
                popupMenu.add((JMenuItem)component);
                continue;
            }
            if (component instanceof Action) {
                popupMenu.add((Action)((Object)component));
                continue;
            }
            popupMenu.add(component);
        }
    }

    private String getGroupName(Component component) {
        Object parent;
        Action action = null;
        if (component instanceof AbstractButton) {
            action = ((AbstractButton)component).getAction();
        } else if (component instanceof Action) {
            action = (Action)((Object)component);
        }
        if (action != null && (parent = action.getValue("_parent")) != null) {
            return parent.toString();
        }
        return "";
    }
}

