/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RGBImageProfile;
import org.esa.beam.framework.datamodel.RGBImageProfileManager;
import org.esa.beam.framework.ui.ModalDialog;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.product.ProductExpressionPane;
import org.esa.beam.framework.ui.tool.ToolButtonFactory;
import org.esa.beam.util.Debug;
import org.esa.beam.util.PropertyMap;
import org.esa.beam.util.io.BeamFileChooser;
import org.esa.beam.util.io.BeamFileFilter;
import org.esa.beam.util.io.FileUtils;

public class RGBImageProfilePane
extends JPanel {
    private static final boolean SHOW_ALPHA = false;
    private String[] COLOR_COMP_NAMES = new String[]{"Red", "Green", "Blue", "Alpha"};
    public static final Font EXPRESSION_FONT = new Font("Courier", 0, 12);
    private PropertyMap preferences;
    private Product product;
    private final Product[] openedProducts;
    private final int[] defaultBandIndices;
    private JComboBox<ProfileItem> profileBox;
    private JComboBox[] rgbaExprBoxes;
    private DefaultComboBoxModel<ProfileItem> profileModel;
    private AbstractAction saveAsAction;
    private AbstractAction deleteAction;
    private boolean settingRgbaExpressions;
    private File lastDir;
    protected JCheckBox storeInProductCheck;

    public RGBImageProfilePane(PropertyMap preferences) {
        this(preferences, null, null, null);
    }

    public RGBImageProfilePane(PropertyMap preferences, Product product, Product[] openedProducts, int[] defaultBandIndices) {
        this.preferences = preferences;
        this.product = product;
        this.openedProducts = openedProducts;
        this.defaultBandIndices = defaultBandIndices;
        AbstractAction openAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RGBImageProfilePane.this.performOpen();
            }
        };
        openAction.putValue("_largeIcon", UIUtils.loadImageIcon("icons/Open24.gif"));
        openAction.putValue("ShortDescription", "Open an external RGB profile");
        this.saveAsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RGBImageProfilePane.this.performSaveAs();
            }
        };
        this.saveAsAction.putValue("_largeIcon", UIUtils.loadImageIcon("icons/Save24.gif"));
        this.saveAsAction.putValue("ShortDescription", "Save the RGB profile");
        this.deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RGBImageProfilePane.this.performDelete();
            }
        };
        this.deleteAction.putValue("_largeIcon", UIUtils.loadImageIcon("icons/Remove24.gif"));
        this.deleteAction.putValue("ShortDescription", "Delete the selected RGB profile");
        JPanel p2 = new JPanel(new GridLayout(1, 3, 2, 2));
        p2.add(ToolButtonFactory.createButton(openAction, false));
        p2.add(ToolButtonFactory.createButton(this.saveAsAction, false));
        p2.add(ToolButtonFactory.createButton(this.deleteAction, false));
        this.profileModel = new DefaultComboBoxModel();
        this.profileBox = new JComboBox<ProfileItem>(this.profileModel);
        this.profileBox.addItemListener(new ProfileSelectionHandler());
        this.profileBox.setEditable(false);
        this.profileBox.setName("profileBox");
        this.setPrefferedWidth(this.profileBox, 200);
        this.storeInProductCheck = new JCheckBox();
        this.storeInProductCheck.setText("Store RGB channels as virtual bands in current product");
        this.storeInProductCheck.setSelected(false);
        this.storeInProductCheck.setVisible(this.product != null);
        this.storeInProductCheck.setName("storeInProductCheck");
        String[] bandNames = this.product != null ? this.product.getBandNames() : new String[]{};
        this.rgbaExprBoxes = new JComboBox[4];
        for (int i = 0; i < this.rgbaExprBoxes.length; ++i) {
            this.rgbaExprBoxes[i] = this.createRgbaBox(bandNames);
            this.rgbaExprBoxes[i].setName("rgbExprBox_" + i);
        }
        JPanel p1 = new JPanel(new BorderLayout(2, 2));
        p1.add((Component)new JLabel("Profile: "), "North");
        p1.add(this.profileBox, "Center");
        p1.add((Component)p2, "East");
        JPanel p3 = new JPanel(new GridBagLayout());
        GridBagConstraints c3 = new GridBagConstraints();
        c3.anchor = 17;
        c3.fill = 2;
        c3.insets = new Insets(2, 2, 2, 2);
        int n = 3;
        for (int i = 0; i < 3; ++i) {
            c3.gridy = i;
            this.addColorComponentRow(p3, c3, i);
        }
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)p1, "North");
        this.add((Component)p3, "Center");
        this.add((Component)this.storeInProductCheck, "South");
        RGBImageProfile[] registeredProfiles = RGBImageProfileManager.getInstance().getAllProfiles();
        this.addProfiles(registeredProfiles);
        if (this.product != null) {
            RGBImageProfile productProfile = RGBImageProfile.getCurrentProfile((Product)this.product);
            if (productProfile.isValid()) {
                RGBImageProfile similarProfile = this.findMatchingProfile(productProfile);
                if (similarProfile != null) {
                    this.selectProfile(similarProfile);
                } else {
                    this.addNewProfile(productProfile);
                    this.selectProfile(productProfile);
                }
            } else {
                ArrayList<RGBImageProfile> selectableProfiles = new ArrayList<RGBImageProfile>();
                for (int i = 0; i < this.profileModel.getSize(); ++i) {
                    selectableProfiles.add(this.profileModel.getElementAt(i).getProfile());
                }
                RGBImageProfile[] selectableProfileArray = selectableProfiles.toArray(new RGBImageProfile[selectableProfiles.size()]);
                RGBImageProfile profile = RGBImageProfilePane.findProfileForProductPattern(selectableProfileArray, product);
                if (profile != null) {
                    this.selectProfile(profile);
                }
            }
        }
        this.setRgbaExpressionsFromSelectedProfile();
        if ((this.rgbaExprBoxes[0].getSelectedItem() == null || ((String)this.rgbaExprBoxes[0].getSelectedItem()).isEmpty()) && defaultBandIndices != null && defaultBandIndices.length > 0) {
            for (int i = 0; i < defaultBandIndices.length; ++i) {
                this.rgbaExprBoxes[i].setSelectedIndex(defaultBandIndices[i]);
            }
        }
    }

    public Product getProduct() {
        return this.product;
    }

    public void dispose() {
        this.preferences = null;
        this.product = null;
        this.profileModel.removeAllElements();
        this.profileModel = null;
        this.profileBox = null;
        this.saveAsAction = null;
        this.deleteAction = null;
        for (int i = 0; i < this.rgbaExprBoxes.length; ++i) {
            this.rgbaExprBoxes[i] = null;
        }
        this.rgbaExprBoxes = null;
    }

    public boolean getStoreProfileInProduct() {
        return this.storeInProductCheck.isSelected();
    }

    public RGBImageProfile getSelectedProfile() {
        ProfileItem profileItem = this.getSelectedProfileItem();
        return profileItem != null ? profileItem.getProfile() : null;
    }

    public String[] getRgbExpressions() {
        return new String[]{this.getExpression(0), this.getExpression(1), this.getExpression(2)};
    }

    public String[] getRgbaExpressions() {
        return new String[]{this.getExpression(0), this.getExpression(1), this.getExpression(2), this.getExpression(3)};
    }

    public void addProfiles(RGBImageProfile[] profiles) {
        for (RGBImageProfile profile : profiles) {
            this.addNewProfile(profile);
        }
        this.setRgbaExpressionsFromSelectedProfile();
    }

    public RGBImageProfile findMatchingProfile(RGBImageProfile profile) {
        RGBImageProfile matchingProfile = this.findMatchingProfile(profile, true);
        if (matchingProfile == null) {
            matchingProfile = this.findMatchingProfile(profile, false);
        }
        return matchingProfile;
    }

    public void selectProfile(RGBImageProfile profile) {
        this.profileModel.setSelectedItem(new ProfileItem(profile));
    }

    public boolean showDialog(Window parent, String title, String helpId) {
        ModalDialog modalDialog = new ModalDialog(parent, title, 161, helpId);
        modalDialog.setContent(this);
        int status = modalDialog.show();
        modalDialog.getJDialog().dispose();
        return status == 1;
    }

    private String getExpression(int i) {
        return ((JTextField)this.rgbaExprBoxes[i].getEditor().getEditorComponent()).getText().trim();
    }

    private void setExpression(int i, String expression) {
        this.rgbaExprBoxes[i].setSelectedItem(expression);
    }

    private void performOpen() {
        RGBImageProfile profile;
        BeamFileChooser beamFileChooser = new BeamFileChooser(this.getProfilesDir());
        beamFileChooser.setFileFilter((FileFilter)new BeamFileFilter("RGB-PROFILE", ".rgb", "RGB-Image Profile Files"));
        int status = beamFileChooser.showOpenDialog((Component)this);
        if (beamFileChooser.getSelectedFile() == null) {
            return;
        }
        File file = beamFileChooser.getSelectedFile();
        this.lastDir = file.getParentFile();
        if (status != 0) {
            return;
        }
        try {
            profile = RGBImageProfile.loadProfile((File)file);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Failed to open RGB-profile '" + file.getName() + "':\n" + e.getMessage(), "Open RGB-Image Profile", 0);
            return;
        }
        if (profile == null) {
            JOptionPane.showMessageDialog(this, "Invalid RGB-Profile '" + file.getName() + "'.", "Open RGB-Image Profile", 0);
            return;
        }
        RGBImageProfileManager.getInstance().addProfile(profile);
        if (this.product != null && !profile.isApplicableTo(this.product)) {
            JOptionPane.showMessageDialog(this, "The selected RGB-Profile '" + profile.getName() + "'\n" + "is not applicable to the current product.", "Open RGB-Image Profile", 0);
            return;
        }
        this.addNewProfile(profile);
    }

    private void performSaveAs() {
        File file = this.promptForSaveFile();
        if (file == null) {
            return;
        }
        RGBImageProfile profile = new RGBImageProfile(FileUtils.getFilenameWithoutExtension((File)file), this.getRgbaExpressions());
        try {
            profile.store(file);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Failed to save RGB-profile '" + file.getName() + "':\n" + e.getMessage(), "Open RGB-Image Profile", 0);
            return;
        }
        RGBImageProfileManager.getInstance().addProfile(profile);
        this.addNewProfile(profile);
    }

    private File promptForSaveFile() {
        File selectedFile;
        int answer;
        BeamFileChooser beamFileChooser = new BeamFileChooser(this.getProfilesDir());
        beamFileChooser.setFileFilter((FileFilter)new BeamFileFilter("RGB-PROFILE", ".rgb", "RGB-Image Profile Files"));
        do {
            int status = beamFileChooser.showSaveDialog((Component)this);
            if (beamFileChooser.getSelectedFile() == null) {
                selectedFile = null;
                break;
            }
            selectedFile = beamFileChooser.getSelectedFile();
            this.lastDir = selectedFile.getParentFile();
            if (status != 0) {
                selectedFile = null;
                break;
            }
            if (!selectedFile.exists()) break;
            answer = JOptionPane.showConfirmDialog(this, "The file '" + selectedFile.getName() + "' already exists.\n" + "So you really want to overwrite it?", "Safe RGB-Profile As", 1);
            if (answer != 2) continue;
            selectedFile = null;
            break;
        } while (answer != 0);
        return selectedFile;
    }

    private void performDelete() {
        ProfileItem selectedProfileItem = this.getSelectedProfileItem();
        if (selectedProfileItem != null && !selectedProfileItem.getProfile().isInternal()) {
            this.profileModel.removeElement(selectedProfileItem);
        }
    }

    private File getProfilesDir() {
        if (this.lastDir != null) {
            return this.lastDir;
        }
        return RGBImageProfileManager.getProfilesDir();
    }

    private void addNewProfile(RGBImageProfile profile) {
        if (this.product != null && !profile.isApplicableTo(this.product)) {
            return;
        }
        ProfileItem profileItem = new ProfileItem(profile);
        int index = this.profileModel.getIndexOf(profileItem);
        if (index == -1) {
            this.profileModel.addElement(profileItem);
        }
        this.profileModel.setSelectedItem(profileItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRgbaExpressionsFromSelectedProfile() {
        this.settingRgbaExpressions = true;
        try {
            ProfileItem profileItem = this.getSelectedProfileItem();
            if (profileItem != null) {
                String[] rgbaExpressions = profileItem.getProfile().getRgbaExpressions();
                for (int i = 0; i < this.rgbaExprBoxes.length; ++i) {
                    this.setExpression(i, rgbaExpressions[i]);
                }
            } else {
                for (int i = 0; i < this.rgbaExprBoxes.length; ++i) {
                    this.setExpression(i, "");
                }
            }
        }
        finally {
            this.settingRgbaExpressions = false;
        }
        this.updateUIState();
    }

    private ProfileItem getSelectedProfileItem() {
        return (ProfileItem)this.profileBox.getSelectedItem();
    }

    private void addColorComponentRow(JPanel p3, GridBagConstraints constraints, final int index) {
        JButton editorButton = new JButton("...");
        editorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RGBImageProfilePane.this.invokeExpressionEditor(index);
            }
        });
        Dimension preferredSize = this.rgbaExprBoxes[index].getPreferredSize();
        editorButton.setPreferredSize(new Dimension(preferredSize.height, preferredSize.height));
        constraints.gridy = index;
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        p3.add((Component)new JLabel(this.getComponentName(index) + ": "), constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        p3.add((Component)this.rgbaExprBoxes[index], constraints);
        constraints.gridx = 2;
        constraints.weightx = 0.0;
        p3.add((Component)editorButton, constraints);
    }

    protected String getComponentName(int index) {
        return this.COLOR_COMP_NAMES[index];
    }

    private void invokeExpressionEditor(int colorIndex) {
        Window window = SwingUtilities.getWindowAncestor(this);
        String title = "Edit " + this.getComponentName(colorIndex) + " Expression";
        if (this.product != null) {
            Product[] products = RGBImageProfilePane.getCompatibleProducts(this.product, this.openedProducts);
            ProductExpressionPane pane = ProductExpressionPane.createGeneralExpressionPane(products, this.product, this.preferences);
            pane.setCode(this.getExpression(colorIndex));
            int status = pane.showModalDialog(window, title);
            if (status == 1) {
                this.setExpression(colorIndex, pane.getCode());
            }
        } else {
            JTextArea textArea = new JTextArea(8, 48);
            textArea.setFont(EXPRESSION_FONT);
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            textArea.setText(this.getExpression(colorIndex));
            ModalDialog modalDialog = new ModalDialog(window, title, 33, "");
            JPanel panel = new JPanel(new BorderLayout(2, 2));
            panel.add((Component)new JLabel("Expression:"), "North");
            panel.add((Component)new JScrollPane(textArea), "Center");
            modalDialog.setContent(panel);
            int status = modalDialog.show();
            if (status == 1) {
                this.setExpression(colorIndex, textArea.getText());
            }
        }
    }

    private static Product[] getCompatibleProducts(Product targetProduct, Product[] productsList) {
        ArrayList<Product> compatibleProducts = new ArrayList<Product>(1);
        compatibleProducts.add(targetProduct);
        float geolocationEps = 180.0f;
        Debug.trace((String)"BandMathsDialog.geolocationEps = 180.0");
        Debug.trace((String)"BandMathsDialog.getCompatibleProducts:");
        Debug.trace((String)("  comparing: " + targetProduct.getName()));
        if (productsList != null) {
            for (Product product : productsList) {
                if (targetProduct == product) continue;
                Debug.trace((String)("  with:      " + product.getDisplayName()));
                boolean isCompatibleProduct = targetProduct.isCompatibleProduct(product, 180.0f);
                Debug.trace((String)("  result:    " + isCompatibleProduct));
                if (!isCompatibleProduct) continue;
                compatibleProducts.add(product);
            }
        }
        return compatibleProducts.toArray(new Product[compatibleProducts.size()]);
    }

    private JComboBox createRgbaBox(String[] suggestions) {
        JComboBox<String> comboBox = new JComboBox<String>(suggestions);
        this.setPrefferedWidth(comboBox, 320);
        comboBox.setEditable(true);
        ComboBoxEditor editor = comboBox.getEditor();
        JTextField textField = (JTextField)editor.getEditorComponent();
        textField.setFont(EXPRESSION_FONT);
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RGBImageProfilePane.this.onRgbaExpressionChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RGBImageProfilePane.this.onRgbaExpressionChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RGBImageProfilePane.this.onRgbaExpressionChanged();
            }
        });
        return comboBox;
    }

    private void onRgbaExpressionChanged() {
        if (this.settingRgbaExpressions) {
            return;
        }
        ProfileItem profileItem = this.getSelectedProfileItem();
        if (profileItem != null && this.isSelectedProfileModified()) {
            this.profileBox.revalidate();
            this.profileBox.repaint();
        }
        this.updateUIState();
    }

    private boolean isSelectedProfileModified() {
        ProfileItem profileItem = this.getSelectedProfileItem();
        String[] profileRgbaExpressions = profileItem.getProfile().getRgbaExpressions();
        String[] userRgbaExpressions = this.getRgbaExpressions();
        for (int i = 0; i < profileRgbaExpressions.length; ++i) {
            String profileRgbaExpression = profileRgbaExpressions[i];
            String userRgbaExpression = userRgbaExpressions[i];
            if (profileRgbaExpression.equals(userRgbaExpression)) continue;
            return true;
        }
        return false;
    }

    private void updateUIState() {
        ProfileItem profileItem = this.getSelectedProfileItem();
        if (profileItem != null) {
            this.saveAsAction.setEnabled(true);
            this.deleteAction.setEnabled(!profileItem.getProfile().isInternal());
        } else {
            this.saveAsAction.setEnabled(this.isAtLeastOneColorExpressionSet());
            this.deleteAction.setEnabled(false);
        }
    }

    private boolean isAtLeastOneColorExpressionSet() {
        JComboBox[] rgbaExprBoxes = this.rgbaExprBoxes;
        for (int i = 0; i < 3; ++i) {
            JComboBox rgbaExprBox = rgbaExprBoxes[i];
            Object selectedItem = rgbaExprBox.getSelectedItem();
            if (selectedItem == null || selectedItem.toString().trim().equals("")) continue;
            return true;
        }
        return false;
    }

    private void setPrefferedWidth(JComboBox comboBox, int width) {
        Dimension preferredSize = comboBox.getPreferredSize();
        comboBox.setPreferredSize(new Dimension(width, preferredSize.height));
    }

    public static RGBImageProfile findProfileForProductPattern(RGBImageProfile[] rgbImageProfiles, Product product) {
        if (rgbImageProfiles.length == 0) {
            return null;
        }
        String productType = product.getProductType();
        String productName = product.getName();
        String productDesc = product.getDescription();
        RGBImageProfile bestProfile = rgbImageProfiles[0];
        int bestMatchScore = 0;
        for (RGBImageProfile rgbImageProfile : rgbImageProfiles) {
            boolean productDescMatches;
            boolean productNameMatches;
            String[] pattern = rgbImageProfile.getPattern();
            if (pattern == null) continue;
            boolean productTypeMatches = RGBImageProfilePane.matches(productType, pattern[0]);
            int currentMatchScore = (productTypeMatches ? 100 : 0) + ((productNameMatches = RGBImageProfilePane.matches(productName, pattern[1])) ? 10 : 0) + ((productDescMatches = RGBImageProfilePane.matches(productDesc, pattern[2])) ? 1 : 0);
            if (currentMatchScore <= bestMatchScore) continue;
            bestProfile = rgbImageProfile;
            bestMatchScore = currentMatchScore;
        }
        return bestProfile;
    }

    private static boolean matches(String s, String pattern) {
        return pattern != null && s.matches(pattern.replace("*", ".*").replace("?", "."));
    }

    public RGBImageProfile findMatchingProfile(RGBImageProfile profile, boolean internal) {
        int size = this.profileModel.getSize();
        for (int i = 0; i < size; ++i) {
            ProfileItem item = this.profileModel.getElementAt(i);
            RGBImageProfile knownProfile = item.getProfile();
            if (knownProfile.isInternal() != internal || !Arrays.equals(profile.getRgbExpressions(), knownProfile.getRgbExpressions())) continue;
            return knownProfile;
        }
        return null;
    }

    private class ProfileSelectionHandler
    implements ItemListener {
        private ProfileSelectionHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            RGBImageProfilePane.this.setRgbaExpressionsFromSelectedProfile();
        }
    }

    private class ProfileItem {
        private RGBImageProfile _profile;

        public ProfileItem(RGBImageProfile profile) {
            this._profile = profile;
        }

        public RGBImageProfile getProfile() {
            return this._profile;
        }

        public int hashCode() {
            return this.getProfile().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ProfileItem) {
                ProfileItem profileItem = (ProfileItem)obj;
                return this.getProfile().equals((Object)profileItem.getProfile());
            }
            return false;
        }

        public String toString() {
            String name = this._profile.getName().replace('_', ' ');
            if (RGBImageProfilePane.this.getSelectedProfileItem().equals(this) && RGBImageProfilePane.this.isSelectedProfileModified()) {
                name = name + " (modified)";
            }
            return name;
        }
    }
}

