/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.binding.BindingContext;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import javax.measure.unit.NonSI;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.beam.framework.ui.GridBagUtils;
import org.esa.beam.framework.ui.RegionSelectableWorldMapPane;
import org.esa.beam.framework.ui.WorldMapPaneDataModel;

public class RegionBoundsInputUI {
    public static final String PROPERTY_NORTH_BOUND = "northBound";
    public static final String PROPERTY_EAST_BOUND = "eastBound";
    public static final String PROPERTY_SOUTH_BOUND = "southBound";
    public static final String PROPERTY_WEST_BOUND = "westBound";
    private final BindingContext bindingContext;
    private final JLabel northLabel;
    private final JFormattedTextField northLatField;
    private final JLabel northDegreeLabel;
    private final JLabel eastLabel;
    private final JFormattedTextField eastLonField;
    private final JLabel eastDegreeLabel;
    private final JLabel southLabel;
    private final JFormattedTextField southLatField;
    private final JLabel southDegreeLabel;
    private final JLabel westLabel;
    private final JFormattedTextField westLonField;
    private final JLabel westDegreeLabel;
    private final JPanel worldMapPaneUI;
    private JPanel ui;

    public RegionBoundsInputUI() {
        this(75.0, 30.0, 35.0, -15.0);
    }

    public RegionBoundsInputUI(double northBound, double eastBound, double southBound, double westBound) {
        this(RegionBoundsInputUI.createBindingContext(northBound, eastBound, southBound, westBound));
    }

    public RegionBoundsInputUI(BindingContext bindingContext) {
        RegionSelectableWorldMapPane.ensureValidBindingContext(bindingContext);
        this.bindingContext = bindingContext;
        WorldMapPaneDataModel worldMapPaneDataModel = new WorldMapPaneDataModel();
        RegionSelectableWorldMapPane worldMapPane = new RegionSelectableWorldMapPane(worldMapPaneDataModel, bindingContext);
        this.worldMapPaneUI = worldMapPane.createUI();
        this.northLabel = new JLabel("North:");
        this.northDegreeLabel = this.createDegreeLabel();
        this.northLatField = this.createTextField();
        this.eastDegreeLabel = this.createDegreeLabel();
        this.eastLabel = new JLabel("East:");
        this.eastLonField = this.createTextField();
        this.southLabel = new JLabel("South:");
        this.southDegreeLabel = this.createDegreeLabel();
        this.southLatField = this.createTextField();
        this.westDegreeLabel = this.createDegreeLabel();
        this.westLabel = new JLabel("West:");
        this.westLonField = this.createTextField();
        bindingContext.bind(PROPERTY_WEST_BOUND, this.westLonField);
        bindingContext.bind(PROPERTY_EAST_BOUND, this.eastLonField);
        bindingContext.bind(PROPERTY_NORTH_BOUND, this.northLatField);
        bindingContext.bind(PROPERTY_SOUTH_BOUND, this.southLatField);
    }

    public void setEnabled(boolean enabled) {
        this.northLabel.setEnabled(enabled);
        this.northLatField.setEnabled(enabled);
        this.northDegreeLabel.setEnabled(enabled);
        this.eastLabel.setEnabled(enabled);
        this.eastLonField.setEnabled(enabled);
        this.eastDegreeLabel.setEnabled(enabled);
        this.southLabel.setEnabled(enabled);
        this.southLatField.setEnabled(enabled);
        this.southDegreeLabel.setEnabled(enabled);
        this.westLabel.setEnabled(enabled);
        this.westLonField.setEnabled(enabled);
        this.westDegreeLabel.setEnabled(enabled);
        this.worldMapPaneUI.setEnabled(enabled);
    }

    public JPanel getUI() {
        if (this.ui == null) {
            JPanel fieldsPanel = GridBagUtils.createPanel();
            GridBagConstraints fieldsGBC = GridBagUtils.createDefaultConstraints();
            fieldsGBC.anchor = 17;
            fieldsGBC.gridy = 0;
            GridBagUtils.addToPanel(fieldsPanel, this.northLabel, fieldsGBC, "gridx=3");
            GridBagUtils.addToPanel(fieldsPanel, this.northLatField, fieldsGBC, "gridx=4");
            GridBagUtils.addToPanel(fieldsPanel, this.northDegreeLabel, fieldsGBC, "gridx=5");
            fieldsGBC.gridy = 1;
            GridBagUtils.addToPanel(fieldsPanel, this.westLabel, fieldsGBC, "gridx=0");
            GridBagUtils.addToPanel(fieldsPanel, this.westLonField, fieldsGBC, "gridx=1");
            GridBagUtils.addToPanel(fieldsPanel, this.westDegreeLabel, fieldsGBC, "gridx=2");
            GridBagUtils.addToPanel(fieldsPanel, this.eastLabel, fieldsGBC, "gridx=6");
            GridBagUtils.addToPanel(fieldsPanel, this.eastLonField, fieldsGBC, "gridx=7");
            GridBagUtils.addToPanel(fieldsPanel, this.eastDegreeLabel, fieldsGBC, "gridx=8");
            fieldsGBC.gridy = 2;
            GridBagUtils.addToPanel(fieldsPanel, this.southLabel, fieldsGBC, "gridx=3");
            GridBagUtils.addToPanel(fieldsPanel, this.southLatField, fieldsGBC, "gridx=4");
            GridBagUtils.addToPanel(fieldsPanel, this.southDegreeLabel, fieldsGBC, "gridx=5");
            this.ui = GridBagUtils.createPanel();
            GridBagConstraints mainGBC = GridBagUtils.createDefaultConstraints();
            mainGBC.fill = 2;
            mainGBC.gridy = 0;
            GridBagUtils.addToPanel(this.ui, fieldsPanel, mainGBC);
            mainGBC.gridy = 1;
            GridBagUtils.addToPanel(this.ui, this.worldMapPaneUI, mainGBC, "insets.top=10");
        }
        return this.ui;
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    private static BindingContext createBindingContext(double northBound, double eastBound, double southBound, double westBound) {
        Bounds bounds = new Bounds(northBound, eastBound, southBound, westBound);
        PropertyContainer container = PropertyContainer.createObjectBacked((Object)bounds);
        return new BindingContext((PropertySet)container);
    }

    private JFormattedTextField createTextField() {
        int fieldWidth = 60;
        DoubleFormatter textFormatter = new DoubleFormatter("###0.0##");
        JFormattedTextField textField = new JFormattedTextField(textFormatter);
        textField.setHorizontalAlignment(4);
        int defaultHeight = textField.getPreferredSize().height;
        Dimension size = new Dimension(60, defaultHeight);
        textField.setMinimumSize(size);
        textField.setPreferredSize(size);
        textField.setMaximumSize(size);
        return textField;
    }

    private JLabel createDegreeLabel() {
        return new JLabel(NonSI.DEGREE_ANGLE.toString());
    }

    private static class Bounds {
        double northBound;
        double eastBound;
        double southBound;
        double westBound;

        private Bounds(double northBound, double eastBound, double southBound, double westBound) {
            this.northBound = northBound;
            this.eastBound = eastBound;
            this.southBound = southBound;
            this.westBound = westBound;
        }
    }

    private static class DoubleFormatter
    extends JFormattedTextField.AbstractFormatter {
        private final DecimalFormat format;

        DoubleFormatter(String pattern) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
            this.format = new DecimalFormat(pattern, decimalFormatSymbols);
            this.format.setParseIntegerOnly(false);
            this.format.setParseBigDecimal(false);
            this.format.setDecimalSeparatorAlwaysShown(true);
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            return this.format.parse(text).doubleValue();
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value == null) {
                return "";
            }
            return this.format.format(value);
        }
    }
}

