/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.esa.beam.framework.ui.UIDefaults;

public class SliderBoxImageDisplay
extends JComponent {
    private static final int HANDLE_SIZE = 6;
    private BufferedImage image;
    private final int imageWidth;
    private final int imageHeight;
    private final SliderBoxChangeListener sliderBoxChangeListener;
    private final JComponent sliderBox;
    private int sliderSectionX;
    private int sliderSectionY;
    private Rectangle sliderRectOld;
    private Point clickPos;
    private boolean imageWidthFixed;
    private boolean imageHeightFixed;

    public SliderBoxImageDisplay(int imageWidth, int imageHeight, SliderBoxChangeListener sliderBoxChangeListener) {
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.sliderBoxChangeListener = sliderBoxChangeListener;
        this.sliderBox = new JLabel();
        this.sliderBox.setBounds(0, 0, 1, 1);
        this.sliderBox.setOpaque(false);
        this.sliderBox.setBorder(UIDefaults.SLIDER_BOX_BORDER);
        this.setLayout(null);
        this.setPreferredSize(new Dimension(imageWidth, imageHeight));
        this.add(this.sliderBox);
        this.clearSliderSections();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SliderBoxImageDisplay.this.sliderRectOld = new Rectangle(SliderBoxImageDisplay.this.sliderBox.getBounds());
                SliderBoxImageDisplay.this.clickPos = new Point(e.getPoint());
                SliderBoxImageDisplay.this.computeSliderSections(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SliderBoxImageDisplay.this.sliderRectOld = null;
                SliderBoxImageDisplay.this.clickPos = null;
                SliderBoxImageDisplay.this.clearSliderSections();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SliderBoxImageDisplay.this.sliderRectOld == null || SliderBoxImageDisplay.this.clickPos == null) {
                    return;
                }
                SliderBoxImageDisplay.this.modifySliderBox(e);
            }
        });
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, null);
        }
    }

    public boolean isImageWidthFixed() {
        return this.imageWidthFixed;
    }

    public void setImageWidthFixed(boolean imageWidthFixed) {
        if (this.imageWidthFixed == imageWidthFixed) {
            return;
        }
        this.imageWidthFixed = imageWidthFixed;
        if (this.imageWidthFixed) {
            this.setSliderBoxBounds(0, this.sliderBox.getY(), this.imageWidth, this.sliderBox.getHeight(), true);
        }
    }

    public boolean isImageHeightFixed() {
        return this.imageHeightFixed;
    }

    public void setImageHeightFixed(boolean imageHeightFixed) {
        if (this.imageHeightFixed == imageHeightFixed) {
            return;
        }
        this.imageHeightFixed = imageHeightFixed;
        if (this.imageHeightFixed) {
            this.setSliderBoxBounds(this.sliderBox.getX(), 0, this.sliderBox.getWidth(), this.imageHeight, true);
        }
    }

    public SliderBoxChangeListener getSliderBoxChangeListener() {
        return this.sliderBoxChangeListener;
    }

    public Rectangle getSliderBoxBounds() {
        return this.sliderBox.getBounds();
    }

    public void setSliderBoxBounds(Rectangle rectangle) {
        this.setSliderBoxBounds(rectangle, false);
    }

    public void setSliderBoxBounds(Rectangle rectangle, boolean fireEvent) {
        this.setSliderBoxBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height, fireEvent);
    }

    public void setSliderBoxBounds(int x, int y, int width, int height) {
        this.setSliderBoxBounds(x, y, width, height, false);
    }

    public void setSliderBoxBounds(int x, int y, int width, int height, boolean fireEvent) {
        if (this.isImageWidthFixed()) {
            x = 0;
            width = this.imageWidth;
        }
        if (this.isImageHeightFixed()) {
            y = 0;
            height = this.imageHeight;
        }
        if (this.sliderBox.getX() == x && this.sliderBox.getY() == y && this.sliderBox.getWidth() == width && this.sliderBox.getHeight() == height) {
            return;
        }
        this.sliderBox.setBounds(x, y, width, height);
        if (this.sliderBoxChangeListener != null && fireEvent) {
            this.sliderBoxChangeListener.sliderBoxChanged(this.sliderBox.getBounds());
        }
    }

    private void clearSliderSections() {
        this.sliderSectionX = -1;
        this.sliderSectionY = -1;
    }

    private void computeSliderSections(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int x1 = this.sliderBox.getX();
        int y1 = this.sliderBox.getY();
        int x2 = this.sliderBox.getX() + this.sliderBox.getWidth();
        int y2 = this.sliderBox.getY() + this.sliderBox.getHeight();
        int dx1 = Math.abs(x1 - x);
        int dy1 = Math.abs(y1 - y);
        int dx2 = Math.abs(x2 - x);
        int dy2 = Math.abs(y2 - y);
        this.sliderSectionX = -1;
        if (dx1 <= 6) {
            this.sliderSectionX = 0;
        } else if (dx2 <= 6) {
            this.sliderSectionX = 2;
        } else if (x >= x1 && x < x2) {
            this.sliderSectionX = 1;
        }
        this.sliderSectionY = -1;
        if (dy1 <= 6) {
            this.sliderSectionY = 0;
        } else if (dy2 <= 6) {
            this.sliderSectionY = 2;
        } else if (y > y1 && y < y2) {
            this.sliderSectionY = 1;
        }
    }

    private void modifySliderBox(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int dx = x - this.clickPos.x;
        int dy = y - this.clickPos.y;
        int sbx = 0;
        int sby = 0;
        int sbw = 0;
        int sbh = 0;
        boolean validMode = false;
        if (this.sliderSectionX == 0 && this.sliderSectionY == 0) {
            sbx = this.sliderRectOld.x + dx;
            sby = this.sliderRectOld.y + dy;
            sbw = this.sliderRectOld.width - dx;
            sbh = this.sliderRectOld.height - dy;
            validMode = true;
        } else if (this.sliderSectionX == 1 && this.sliderSectionY == 0) {
            sbx = this.sliderRectOld.x;
            sby = this.sliderRectOld.y + dy;
            sbw = this.sliderRectOld.width;
            sbh = this.sliderRectOld.height - dy;
            validMode = true;
        } else if (this.sliderSectionX == 2 && this.sliderSectionY == 0) {
            sbx = this.sliderRectOld.x;
            sby = this.sliderRectOld.y + dy;
            sbw = this.sliderRectOld.width + dx;
            sbh = this.sliderRectOld.height - dy;
            validMode = true;
        } else if (this.sliderSectionX == 0 && this.sliderSectionY == 1) {
            sbx = this.sliderRectOld.x + dx;
            sby = this.sliderRectOld.y;
            sbw = this.sliderRectOld.width - dx;
            sbh = this.sliderRectOld.height;
            validMode = true;
        } else if (this.sliderSectionX == 1 && this.sliderSectionY == 1) {
            sbx = this.sliderRectOld.x + dx;
            sby = this.sliderRectOld.y + dy;
            sbw = this.sliderRectOld.width;
            sbh = this.sliderRectOld.height;
            validMode = true;
        } else if (this.sliderSectionX == 2 && this.sliderSectionY == 1) {
            sbx = this.sliderRectOld.x;
            sby = this.sliderRectOld.y;
            sbw = this.sliderRectOld.width + dx;
            sbh = this.sliderRectOld.height;
            validMode = true;
        } else if (this.sliderSectionX == 0 && this.sliderSectionY == 2) {
            sbx = this.sliderRectOld.x + dx;
            sby = this.sliderRectOld.y;
            sbw = this.sliderRectOld.width - dx;
            sbh = this.sliderRectOld.height + dy;
            validMode = true;
        } else if (this.sliderSectionX == 1 && this.sliderSectionY == 2) {
            sbx = this.sliderRectOld.x;
            sby = this.sliderRectOld.y;
            sbw = this.sliderRectOld.width;
            sbh = this.sliderRectOld.height + dy;
            validMode = true;
        } else if (this.sliderSectionX == 2 && this.sliderSectionY == 2) {
            sbx = this.sliderRectOld.x;
            sby = this.sliderRectOld.y;
            sbw = this.sliderRectOld.width + dx;
            sbh = this.sliderRectOld.height + dy;
            validMode = true;
        }
        if (validMode && sbw > 2 && sbh > 2) {
            this.setSliderBoxBounds(sbx, sby, sbw, sbh, true);
        }
    }

    public static interface SliderBoxChangeListener {
        public void sliderBoxChanged(Rectangle var1);
    }
}

