/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import java.awt.Component;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.PropertyMap;

public class SuppressibleOptionPane
extends JComponent {
    public static final String KEY_PREFIX_DONT_SHOW = ".dontShow";
    public static final String KEY_PREFIX_ENABLED = ".enabled";
    private static final String DONT_SHOW_MESSAGE_TEXT = "Do not show this message anymore.";
    private static final String DONT_SHOW_QUESTION_TEXT = "Do not show this question anymore.";
    private final PropertyMap _propertyMap;
    private JCheckBox _checkBox;

    public SuppressibleOptionPane(PropertyMap propertyMap) {
        Guardian.assertNotNull((String)"propertyMap", (Object)propertyMap);
        this._propertyMap = propertyMap;
    }

    public int showConfirmDialog(String propertyName, Component parentComponent, Object message) {
        SuppressibleOptionPane.checkValidPropertyName(propertyName);
        if (!this.isDontShowPropertySet(propertyName)) {
            message = this.createSuppressibleMessage(message, true);
            int answer = JOptionPane.showConfirmDialog(parentComponent, message);
            this.setConfirmResponseProperty(propertyName, answer);
            return answer;
        }
        return 0;
    }

    public int showConfirmDialog(String propertyName, Component parentComponent, Object message, String title, int optionType) {
        SuppressibleOptionPane.checkValidPropertyName(propertyName);
        if (!this.isDontShowPropertySet(propertyName)) {
            message = this.createSuppressibleMessage(message, true);
            int answer = JOptionPane.showConfirmDialog(parentComponent, message, title, optionType);
            this.setConfirmResponseProperty(propertyName, answer);
            return answer;
        }
        return 0;
    }

    public int showConfirmDialog(String propertyName, Component parentComponent, Object message, String title, int optionType, int messageType) {
        SuppressibleOptionPane.checkValidPropertyName(propertyName);
        if (!this.isDontShowPropertySet(propertyName)) {
            message = this.createSuppressibleMessage(message, true);
            int answer = JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType);
            this.setConfirmResponseProperty(propertyName, answer);
            return answer;
        }
        return 0;
    }

    public int showConfirmDialog(String propertyName, Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) {
        SuppressibleOptionPane.checkValidPropertyName(propertyName);
        if (!this.isDontShowPropertySet(propertyName)) {
            message = this.createSuppressibleMessage(message, true);
            int answer = JOptionPane.showConfirmDialog(parentComponent, message, title, optionType, messageType, icon);
            this.setConfirmResponseProperty(propertyName, answer);
            return answer;
        }
        return 0;
    }

    public int showInternalConfirmDialog(String propertyName, Component parentComponent, Object message) {
        SuppressibleOptionPane.checkValidPropertyName(propertyName);
        if (!this.isDontShowPropertySet(propertyName)) {
            message = this.createSuppressibleMessage(message, true);
            int answer = JOptionPane.showInternalConfirmDialog(parentComponent, message);
            this.setConfirmResponseProperty(propertyName, answer);
            return answer;
        }
        return 0;
    }

    public int showInternalConfirmDialog(String propertyName, Component parentComponent, Object message, String title, int optionType) {
        SuppressibleOptionPane.checkValidPropertyName(propertyName);
        if (!this.isDontShowPropertySet(propertyName)) {
            message = this.createSuppressibleMessage(message, true);
            int answer = JOptionPane.showInternalConfirmDialog(parentComponent, message, title, optionType);
            this.setConfirmResponseProperty(propertyName, answer);
            return answer;
        }
        return 0;
    }

    public int showInternalConfirmDialog(String propertyName, Component parentComponent, Object message, String title, int optionType, int messageType) {
        SuppressibleOptionPane.checkValidPropertyName(propertyName);
        if (!this.isDontShowPropertySet(propertyName)) {
            message = this.createSuppressibleMessage(message, true);
            int answer = JOptionPane.showInternalConfirmDialog(parentComponent, message, title, optionType, messageType);
            this.setConfirmResponseProperty(propertyName, answer);
            return answer;
        }
        return 0;
    }

    public int showInternalConfirmDialog(String propertyName, Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) {
        SuppressibleOptionPane.checkValidPropertyName(propertyName);
        if (!this.isDontShowPropertySet(propertyName)) {
            message = this.createSuppressibleMessage(message, true);
            int answer = JOptionPane.showInternalConfirmDialog(parentComponent, message, title, optionType, messageType, icon);
            this.setConfirmResponseProperty(propertyName, answer);
            return answer;
        }
        return 0;
    }

    public void showMessageDialog(String propertyName, Component parentComponent, Object message) {
        SuppressibleOptionPane.checkValidPropertyName(propertyName);
        if (!this.isDontShowPropertySet(propertyName)) {
            message = this.createSuppressibleMessage(message, false);
            JOptionPane.showMessageDialog(parentComponent, message);
            this.setDontShowProperty(propertyName);
        }
    }

    public void showMessageDialog(String propertyName, Component parentComponent, Object message, String title, int messageType) {
        SuppressibleOptionPane.checkValidPropertyName(propertyName);
        if (!this.isDontShowPropertySet(propertyName)) {
            message = this.createSuppressibleMessage(message, false);
            JOptionPane.showMessageDialog(parentComponent, message, title, messageType);
            this.setDontShowProperty(propertyName);
        }
    }

    public void showMessageDialog(String propertyName, Component parentComponent, Object message, String title, int messageType, Icon icon) {
        SuppressibleOptionPane.checkValidPropertyName(propertyName);
        if (!this.isDontShowPropertySet(propertyName)) {
            message = this.createSuppressibleMessage(message, false);
            JOptionPane.showMessageDialog(parentComponent, message, title, messageType, icon);
            this.setDontShowProperty(propertyName);
        }
    }

    public void showInternalMessageDialog(String propertyName, Component parentComponent, Object message) {
        SuppressibleOptionPane.checkValidPropertyName(propertyName);
        if (!this.isDontShowPropertySet(propertyName)) {
            message = this.createSuppressibleMessage(message, false);
            JOptionPane.showInternalMessageDialog(parentComponent, message);
            this.setDontShowProperty(propertyName);
        }
    }

    public void showInternalMessageDialog(String propertyName, Component parentComponent, Object message, String title, int messageType) {
        SuppressibleOptionPane.checkValidPropertyName(propertyName);
        if (!this.isDontShowPropertySet(propertyName)) {
            message = this.createSuppressibleMessage(message, false);
            JOptionPane.showInternalMessageDialog(parentComponent, message, title, messageType);
            this.setDontShowProperty(propertyName);
        }
    }

    public void showInternalMessageDialog(String propertyName, Component parentComponent, Object message, String title, int messageType, Icon icon) {
        SuppressibleOptionPane.checkValidPropertyName(propertyName);
        if (!this.isDontShowPropertySet(propertyName)) {
            message = this.createSuppressibleMessage(message, false);
            JOptionPane.showInternalMessageDialog(parentComponent, message, title, messageType, icon);
            this.setDontShowProperty(propertyName);
        }
    }

    public int showInternalOptionDialog(String propertyName, Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) {
        SuppressibleOptionPane.checkValidPropertyName(propertyName);
        if (!this.isDontShowPropertySet(propertyName)) {
            message = this.createSuppressibleMessage(message, false);
            int answer = JOptionPane.showInternalOptionDialog(parentComponent, message, title, optionType, messageType, icon, options, initialValue);
            this.setDontShowProperty(propertyName);
            return answer;
        }
        return 0;
    }

    public int showOptionDialog(String propertyName, Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) {
        SuppressibleOptionPane.checkValidPropertyName(propertyName);
        if (this.isDontShowPropertySet(propertyName)) {
            message = this.createSuppressibleMessage(message, false);
            int answer = JOptionPane.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, options, initialValue);
            this.setDontShowProperty(propertyName);
            return answer;
        }
        return 0;
    }

    public boolean areDialogsSuppressed() {
        Enumeration propertyKeys = this._propertyMap.getPropertyKeys();
        while (propertyKeys.hasMoreElements()) {
            String key = (String)propertyKeys.nextElement();
            if (!SuppressibleOptionPane.isDontShowPropertyName(key) || !this._propertyMap.getPropertyBool(key)) continue;
            return true;
        }
        return false;
    }

    public void unSuppressDialogs() {
        Enumeration propertyKeys = this._propertyMap.getPropertyKeys();
        while (propertyKeys.hasMoreElements()) {
            String key = (String)propertyKeys.nextElement();
            if (!SuppressibleOptionPane.isDontShowPropertyName(key)) continue;
            this._propertyMap.setPropertyBool(key, false);
        }
    }

    private Object createSuppressibleMessage(Object message, boolean question) {
        Object[] newMessage;
        if (message == null) {
            return message;
        }
        if (this._checkBox == null) {
            this._checkBox = new JCheckBox();
        }
        this._checkBox.setText(question ? DONT_SHOW_QUESTION_TEXT : DONT_SHOW_MESSAGE_TEXT);
        this._checkBox.setSelected(false);
        if (message instanceof Object[]) {
            int length = ((Object[])message).length;
            newMessage = new Object[length + 2];
            System.arraycopy(message, 0, newMessage, 0, length);
        } else if (message instanceof Component || message instanceof Icon) {
            newMessage = new Object[3];
            newMessage[0] = message;
        } else {
            newMessage = new Object[3];
            newMessage[0] = message.toString();
        }
        newMessage[newMessage.length - 2] = " ";
        newMessage[newMessage.length - 1] = this._checkBox;
        return newMessage;
    }

    private static void checkValidPropertyName(String propertyName) {
        Guardian.assertNotNullOrEmpty((String)"propertyName", (String)propertyName);
    }

    private void setConfirmResponseProperty(String propertyName, int answer) {
        this.setDontShowProperty(propertyName);
        if (answer == 0) {
            this._propertyMap.setPropertyBool(propertyName, true);
        } else if (answer == 1) {
            this._propertyMap.setPropertyBool(propertyName, false);
        }
    }

    private boolean isDontShowPropertySet(String propertyName) {
        return this._propertyMap.getPropertyBool(SuppressibleOptionPane.createDontShowPropertyName(propertyName), false);
    }

    private void setDontShowProperty(String propertyName) {
        this._propertyMap.setPropertyBool(SuppressibleOptionPane.createDontShowPropertyName(propertyName), this._checkBox.isSelected());
    }

    private static String createDontShowPropertyName(String propertyName) {
        if (propertyName.endsWith(KEY_PREFIX_ENABLED)) {
            return propertyName.substring(0, propertyName.lastIndexOf(46)) + KEY_PREFIX_DONT_SHOW;
        }
        return propertyName + KEY_PREFIX_DONT_SHOW;
    }

    private static boolean isDontShowPropertyName(String propertyName) {
        return propertyName.endsWith(KEY_PREFIX_DONT_SHOW);
    }
}

