/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.esa.beam.framework.param.ParamChangeEvent;
import org.esa.beam.framework.param.ParamChangeListener;
import org.esa.beam.framework.param.ParamProperties;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.util.ArrayUtils;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.StringUtils;

public class UIUtils {
    public static final String PROPERTY_SOURCE_PRODUCT = "SOURCE_PRODUCT";
    public static final String IMAGE_RESOURCE_PATH = "/org/esa/beam/resources/images/";
    public static final Color COLOR_DARK_RED = new Color(128, 0, 0);
    public static final Color COLOR_DARK_BLUE = new Color(0, 0, 128);
    public static final Color COLOR_DARK_GREEN = new Color(0, 128, 0);

    public static ImageIcon loadImageIcon(String resourcePath) {
        return UIUtils.loadImageIcon(resourcePath, UIUtils.class);
    }

    public static ImageIcon loadImageIcon(String resourcePath, Class callerClass) {
        if (StringUtils.isNotNullAndNotEmpty((String)resourcePath)) {
            URL location = UIUtils.getImageURL(resourcePath, callerClass);
            return location != null ? new ImageIcon(location) : null;
        }
        return null;
    }

    public static URL getImageURL(String resourcePath) {
        return UIUtils.getImageURL(resourcePath, UIUtils.class);
    }

    public static URL getImageURL(String resourcePath, Class callerClass) {
        String absResourcePath = resourcePath;
        if (!absResourcePath.startsWith("/")) {
            absResourcePath = IMAGE_RESOURCE_PATH + resourcePath;
        }
        return callerClass.getResource(absResourcePath);
    }

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static int getScreenWidth() {
        return UIUtils.getScreenSize().width;
    }

    public static int getScreenHeight() {
        return UIUtils.getScreenSize().height;
    }

    public static void centerComponent(Component comp) {
        UIUtils.centerComponent(comp, null);
    }

    public static void centerComponent(Component comp, Component alignComp) {
        int y1;
        int x1;
        if (comp == null) {
            throw new IllegalArgumentException("comp must not be null");
        }
        Dimension compSize = comp.getSize();
        Dimension screenSize = UIUtils.getScreenSize();
        if (alignComp != null) {
            Point alignCompOffs = alignComp.getLocation();
            Dimension alignCompSize = alignComp.getSize();
            x1 = alignCompOffs.x + (alignCompSize.width - compSize.width) / 2;
            y1 = alignCompOffs.y + (alignCompSize.height - compSize.height) / 2;
        } else {
            x1 = (screenSize.width - compSize.width) / 2;
            y1 = (screenSize.height - compSize.height) / 2;
        }
        int x2 = x1 + compSize.width;
        int y2 = y1 + compSize.height;
        if (x2 >= screenSize.width) {
            x1 = screenSize.width - compSize.width - 1;
        }
        if (y2 >= screenSize.height) {
            y1 = screenSize.height - compSize.height - 1;
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        comp.setLocation(x1, y1);
    }

    private UIUtils() {
    }

    public static void showPopup(JPopupMenu popup, MouseEvent event) {
        if (popup == null) {
            return;
        }
        Component component = event.getComponent();
        Point point = event.getPoint();
        popup.show(component, point.x, point.y);
    }

    public static Window getRootWindow(Component component) {
        Container parent;
        Guardian.assertNotNull((String)"component", (Object)component);
        do {
            if ((parent = component.getParent()) != null || !(component instanceof Window)) continue;
            return (Window)component;
        } while ((component = parent) != null);
        return null;
    }

    public static Border createGroupBorder(String title) {
        return BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), title);
    }

    public static Frame getRootFrame(Component component) {
        Guardian.assertNotNull((String)"component", (Object)component);
        Window window = UIUtils.getRootWindow(component);
        return window instanceof Frame ? (Frame)window : null;
    }

    public static JFrame getRootJFrame(Component component) {
        Guardian.assertNotNull((String)"component", (Object)component);
        Window window = UIUtils.getRootWindow(component);
        return window instanceof JFrame ? (JFrame)window : null;
    }

    public static Cursor setRootFrameWaitCursor(Component component) {
        return UIUtils.setRootFrameCursor(component, Cursor.getPredefinedCursor(3));
    }

    public static Cursor setRootFrameDefaultCursor(Component component) {
        return UIUtils.setRootFrameCursor(component, Cursor.getDefaultCursor());
    }

    public static Cursor setRootFrameCursor(Component component, Cursor newCursor) {
        Guardian.assertNotNull((String)"component", (Object)component);
        Frame frame = UIUtils.getRootFrame(component);
        if (frame == null && component instanceof Frame) {
            frame = (Frame)component;
        }
        Cursor oldCursor = null;
        if (frame != null) {
            oldCursor = frame.getCursor();
            if (newCursor != null) {
                frame.setCursor(newCursor);
            } else {
                frame.setCursor(Cursor.getDefaultCursor());
            }
        }
        return oldCursor;
    }

    public static JMenu findMenu(JMenuBar menuBar, String name, boolean deepSearch) {
        JMenu menu;
        int i;
        int n = menuBar.getMenuCount();
        for (i = 0; i < n; ++i) {
            menu = menuBar.getMenu(i);
            if (!name.equals(menu.getName())) continue;
            return menu;
        }
        if (deepSearch) {
            for (i = 0; i < n; ++i) {
                menu = menuBar.getMenu(i);
                JMenu subMenu = UIUtils.findSubMenu(menu.getPopupMenu(), name);
                if (subMenu == null) continue;
                return subMenu;
            }
        }
        return null;
    }

    public static int findMenuPosition(JMenuBar menuBar, String name) {
        int n = menuBar.getMenuCount();
        for (int i = 0; i < n; ++i) {
            JMenu menu = menuBar.getMenu(i);
            if (!name.equals(menu.getName())) continue;
            return i;
        }
        return -1;
    }

    public static int findMenuItemPosition(JPopupMenu popupMenu, String name) {
        int n = popupMenu.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem menuItem;
            Component c = popupMenu.getComponent(i);
            if (!(c instanceof JMenuItem) || !name.equals((menuItem = (JMenuItem)c).getName())) continue;
            return i;
        }
        return -1;
    }

    public static JMenu findSubMenu(JPopupMenu popupMenu, String name) {
        int n = popupMenu.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = popupMenu.getComponent(i);
            if (!(c instanceof JMenu)) continue;
            JMenu subMenu = (JMenu)c;
            if (name.equals(subMenu.getName())) {
                return subMenu;
            }
            if ((subMenu = UIUtils.findSubMenu(subMenu.getPopupMenu(), name)) == null) continue;
            return subMenu;
        }
        return null;
    }

    public static String getUniqueFrameTitle(JInternalFrame[] frames, String titleBase) {
        int i;
        if (frames.length == 0) {
            return titleBase;
        }
        Object[] titles = new String[frames.length];
        for (i = 0; i < frames.length; ++i) {
            JInternalFrame frame = frames[i];
            titles[i] = frame.getTitle();
        }
        if (!ArrayUtils.isMemberOf((Object)titleBase, (Object[])titles)) {
            return titleBase;
        }
        for (i = 0; i < frames.length; ++i) {
            String title = titleBase + " (" + (i + 2) + ")";
            if (ArrayUtils.isMemberOf((Object)title, (Object[])titles)) continue;
            return title;
        }
        return titleBase + " (" + (frames.length + 1) + ")";
    }

    public static JSpinner createSpinner(final Parameter param, Number spinnerStep, String formatPattern) {
        Number v = (Number)param.getValue();
        final ParamProperties properties = param.getProperties();
        Comparable min = (Comparable)((Object)properties.getMinValue());
        Comparable max = (Comparable)((Object)properties.getMaxValue());
        Double bigStep = spinnerStep.doubleValue() * 10.0;
        final JSpinner spinner = UIUtils.createSpinner(v, min, max, spinnerStep, bigStep, formatPattern);
        spinner.setName(properties.getLabel());
        spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                param.setValue(spinner.getValue(), null);
            }
        });
        param.addParamChangeListener(new ParamChangeListener(){

            public void parameterValueChanged(ParamChangeEvent event) {
                spinner.setValue(param.getValue());
            }
        });
        param.getEditor().getEditorComponent().addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                spinner.setEnabled((Boolean)evt.getNewValue());
            }
        });
        properties.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("maxValue".equals(evt.getPropertyName())) {
                    ((SpinnerNumberModel)spinner.getModel()).setMaximum((Comparable)((Object)properties.getMaxValue()));
                }
                if ("minValue".equals(evt.getPropertyName())) {
                    ((SpinnerNumberModel)spinner.getModel()).setMinimum((Comparable)((Object)properties.getMinValue()));
                }
            }
        });
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)spinner.getEditor();
        final JFormattedTextField textField = editor.getTextField();
        textField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                textField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        return spinner;
    }

    public static JSpinner createDoubleSpinner(double value, double rangeMinimum, double rangeMaximum, double stepSize, double bigStepSize, String formatPattern) {
        final SpinnerNumberModel numberModel = new SpinnerNumberModel(value, rangeMinimum, rangeMaximum, stepSize);
        JSpinner spinner = new JSpinner(numberModel);
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.NumberEditor) {
            JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)editor;
            DecimalFormat format = numberEditor.getFormat();
            format.applyPattern(formatPattern);
            numberEditor.getTextField().setColumns(8);
        }
        final Double sss = stepSize;
        final Double bss = bigStepSize;
        String bigDec = "dec++";
        String bigInc = "inc++";
        InputMap inputMap = spinner.getInputMap();
        ActionMap actionMap = spinner.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), "inc++");
        actionMap.put("inc++", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                numberModel.setStepSize(bss);
                numberModel.setValue(numberModel.getNextValue());
                numberModel.setStepSize(sss);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), "dec++");
        actionMap.put("dec++", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                numberModel.setStepSize(bss);
                numberModel.setValue(numberModel.getPreviousValue());
                numberModel.setStepSize(sss);
            }
        });
        return spinner;
    }

    public static JSpinner createSpinner(Number value, Comparable rangeMinimum, Comparable rangeMaximum, final Number stepSize, final Number bigStepSize, String formatPattern) {
        final SpinnerNumberModel numberModel = new SpinnerNumberModel(value, rangeMinimum, rangeMaximum, stepSize);
        JSpinner spinner = new JSpinner(numberModel);
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.NumberEditor) {
            JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)editor;
            DecimalFormat format = numberEditor.getFormat();
            format.applyPattern(formatPattern);
            numberEditor.getTextField().setColumns(8);
        }
        spinner.setValue(0);
        spinner.setValue(value);
        String bigDec = "dec++";
        String bigInc = "inc++";
        InputMap inputMap = spinner.getInputMap();
        ActionMap actionMap = spinner.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), "inc++");
        actionMap.put("inc++", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                numberModel.setStepSize(bigStepSize);
                numberModel.setValue(numberModel.getNextValue());
                numberModel.setStepSize(stepSize);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), "dec++");
        actionMap.put("dec++", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                numberModel.setStepSize(bigStepSize);
                numberModel.setValue(numberModel.getPreviousValue());
                numberModel.setStepSize(stepSize);
            }
        });
        return spinner;
    }
}

