/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import java.util.LinkedList;
import java.util.List;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.PropertyMap;

public class UserInputHistory {
    private String _propertyKey;
    private int _maxNumEntries;
    private List<String> _entriesList;

    public UserInputHistory(int maxNumEntries, String propertyKey) {
        Guardian.assertNotNullOrEmpty((String)"propertyKey", (String)propertyKey);
        this._propertyKey = propertyKey;
        this.setMaxNumEntries(maxNumEntries);
    }

    public int getNumEntries() {
        if (this._entriesList != null) {
            return this._entriesList.size();
        }
        return 0;
    }

    public int getMaxNumEntries() {
        return this._maxNumEntries;
    }

    public String getPropertyKey() {
        return this._propertyKey;
    }

    public String[] getEntries() {
        if (this._entriesList != null) {
            return this._entriesList.toArray(new String[this._entriesList.size()]);
        }
        return null;
    }

    public void initBy(PropertyMap propertyMap) {
        int maxNumEntries = propertyMap.getPropertyInt(this.getLengthKey(), this.getMaxNumEntries());
        this.setMaxNumEntries(maxNumEntries);
        for (int i = maxNumEntries - 1; i >= 0; --i) {
            String entry = propertyMap.getPropertyString(this.getNumKey(i), null);
            if (entry == null || !this.isValidItem(entry)) continue;
            this.push(entry);
        }
    }

    protected boolean isValidItem(String item) {
        return true;
    }

    public void push(String entry) {
        if (entry != null && this.isValidItem(entry)) {
            if (this._entriesList == null) {
                this._entriesList = new LinkedList<String>();
            }
            for (String anEntry : this._entriesList) {
                if (!anEntry.equals(entry)) continue;
                this._entriesList.remove(anEntry);
                break;
            }
            if (this._entriesList.size() == this._maxNumEntries) {
                this._entriesList.remove(this._entriesList.size() - 1);
            }
            this._entriesList.add(0, entry);
        }
    }

    public void copyInto(PropertyMap propertyMap) {
        propertyMap.setPropertyInt(this.getLengthKey(), this._maxNumEntries);
        for (int i = 0; i < 100; ++i) {
            propertyMap.setPropertyString(this.getNumKey(i), null);
        }
        String[] entries = this.getEntries();
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                propertyMap.setPropertyString(this.getNumKey(i), entries[i]);
            }
        }
    }

    private String getLengthKey() {
        return this._propertyKey + ".length";
    }

    private String getNumKey(int index) {
        return this._propertyKey + "." + index;
    }

    public void setMaxNumEntries(int maxNumEntries) {
        int n = this._maxNumEntries = maxNumEntries > 0 ? maxNumEntries : 16;
        if (this._entriesList != null) {
            while (this._maxNumEntries < this._entriesList.size()) {
                this._entriesList.remove(this._entriesList.size() - 1);
            }
        }
    }
}

