/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.CollectionLayer;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.support.BufferedImageRendering;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.geotools.referencing.crs.DefaultGeographicCRS;

public class WorldMapImageLoader {
    private static BufferedImage worldMapImage;
    private static boolean highResolution;
    private static final Dimension HI_RES_DIMENSION;
    private static final Dimension LOW_RES_DIMENSION;

    private WorldMapImageLoader() {
    }

    public static BufferedImage getWorldMapImage(boolean highRes) {
        if (worldMapImage == null || WorldMapImageLoader.isHighRes() != highRes) {
            WorldMapImageLoader.setHighRes(highRes);
            LayerType layerType = LayerTypeRegistry.getLayerType((String)"org.esa.beam.worldmap.BlueMarbleLayerType");
            if (layerType == null) {
                worldMapImage = WorldMapImageLoader.createErrorImage();
            } else {
                CollectionLayer rootLayer = new CollectionLayer();
                Layer worldMapLayer = layerType.createLayer((LayerContext)new WorldMapLayerContext((Layer)rootLayer), (PropertySet)new PropertyContainer());
                Dimension dimension = highRes ? HI_RES_DIMENSION : LOW_RES_DIMENSION;
                BufferedImageRendering biRendering = new BufferedImageRendering(dimension.width, dimension.height);
                biRendering.getViewport().setModelYAxisDown(false);
                biRendering.getViewport().zoom(worldMapLayer.getModelBounds());
                worldMapLayer.render((Rendering)biRendering);
                worldMapImage = biRendering.getImage();
            }
        }
        return worldMapImage;
    }

    private static BufferedImage createErrorImage() {
        BufferedImage errorImage = new BufferedImage(WorldMapImageLoader.LOW_RES_DIMENSION.width, WorldMapImageLoader.LOW_RES_DIMENSION.height, 5);
        Graphics graphics = errorImage.getGraphics();
        graphics.setColor(Color.WHITE);
        Font font = graphics.getFont().deriveFont(75.0f);
        if (graphics instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics.setFont(font);
        String msg = "Failed to load worldmap image.";
        Rectangle2D stringBounds = graphics.getFontMetrics().getStringBounds("Failed to load worldmap image.", graphics);
        int xPos = (int)((double)((float)errorImage.getWidth() * 0.5f) - stringBounds.getWidth() * 0.5);
        int yPos = (int)((float)errorImage.getWidth() * 0.1f);
        graphics.drawString("Failed to load worldmap image.", xPos, yPos);
        return errorImage;
    }

    private static boolean isHighRes() {
        return highResolution;
    }

    private static void setHighRes(boolean highRes) {
        highResolution = highRes;
    }

    static {
        highResolution = false;
        HI_RES_DIMENSION = new Dimension(4320, 2160);
        LOW_RES_DIMENSION = new Dimension(2160, 1080);
    }

    private static class WorldMapLayerContext
    implements LayerContext {
        private final Layer rootLayer;

        private WorldMapLayerContext(Layer rootLayer) {
            this.rootLayer = rootLayer;
        }

        public Object getCoordinateReferenceSystem() {
            return DefaultGeographicCRS.WGS84;
        }

        public Layer getRootLayer() {
            return this.rootLayer;
        }
    }
}

