/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.swing.LayerCanvas;
import com.bc.ceres.glayer.swing.WakefulComponent;
import com.bc.ceres.grender.Viewport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.ui.BoundaryOverlayImpl;
import org.esa.beam.framework.ui.ButtonOverlayControl;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.WorldMapPaneDataModel;
import org.esa.beam.util.ProductUtils;
import org.geotools.referencing.crs.DefaultGeographicCRS;

public class WorldMapPane
extends JPanel {
    private LayerCanvas layerCanvas;
    private Layer worldMapLayer;
    private final WorldMapPaneDataModel dataModel;
    private boolean navControlShown;
    private WakefulComponent navControlWrapper;
    private PanSupport panSupport;
    private MouseHandler mouseHandler;
    private Set<ZoomListener> zoomListeners;

    public WorldMapPane(WorldMapPaneDataModel dataModel) {
        this(dataModel, null);
    }

    public WorldMapPane(WorldMapPaneDataModel dataModel, LayerCanvas.Overlay overlay) {
        this.dataModel = dataModel;
        this.layerCanvas = new LayerCanvas();
        this.panSupport = new DefaultPanSupport(this.layerCanvas);
        this.zoomListeners = new HashSet<ZoomListener>();
        this.getLayerCanvas().getModel().getViewport().setModelYAxisDown(false);
        if (overlay == null) {
            this.getLayerCanvas().addOverlay((LayerCanvas.Overlay)new BoundaryOverlayImpl(dataModel));
        } else {
            this.getLayerCanvas().addOverlay(overlay);
        }
        Layer rootLayer = this.getLayerCanvas().getLayer();
        Dimension dimension = new Dimension(400, 200);
        Viewport viewport = this.getLayerCanvas().getViewport();
        viewport.setViewBounds(new Rectangle(dimension));
        this.setPreferredSize(dimension);
        this.setSize(dimension);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getLayerCanvas(), "Center");
        dataModel.addModelChangeListener(new ModelChangeListener());
        this.worldMapLayer = dataModel.getWorldMapLayer(new WorldMapLayerContext(rootLayer));
        this.installLayerCanvasNavigation(this.getLayerCanvas());
        this.getLayerCanvas().getLayer().getChildren().add(this.worldMapLayer);
        this.zoomAll();
        this.setNavControlVisible(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                boolean isWorldMapFullyVisible;
                AffineTransform transform = WorldMapPane.this.getLayerCanvas().getViewport().getModelToViewTransform();
                Rectangle2D maxVisibleModelBounds = WorldMapPane.this.getLayerCanvas().getMaxVisibleModelBounds();
                double minX = maxVisibleModelBounds.getMinX();
                double minY = maxVisibleModelBounds.getMinY();
                double maxX = maxVisibleModelBounds.getMaxX();
                double maxY = maxVisibleModelBounds.getMaxY();
                Point2D upperLeft = transform.transform(new Point2D.Double(minX, minY), null);
                Point2D lowerRight = transform.transform(new Point2D.Double(maxX, maxY), null);
                Rectangle2D.Double northBorder = new Rectangle2D.Double(upperLeft.getX(), upperLeft.getY(), lowerRight.getX() - upperLeft.getX(), 1.0);
                Rectangle2D.Double southBorder = new Rectangle2D.Double(upperLeft.getX(), lowerRight.getY(), lowerRight.getX() - upperLeft.getX(), 1.0);
                Rectangle2D.Double westBorder = new Rectangle2D.Double(upperLeft.getX(), lowerRight.getY(), 1.0, upperLeft.getY() - lowerRight.getY());
                Rectangle2D.Double eastBorder = new Rectangle2D.Double(lowerRight.getX(), lowerRight.getY(), 1.0, upperLeft.getY() - lowerRight.getY());
                Rectangle layerCanvasBounds = WorldMapPane.this.getLayerCanvas().getBounds();
                boolean bl = isWorldMapFullyVisible = layerCanvasBounds.intersects(northBorder) || layerCanvasBounds.intersects(southBorder) || layerCanvasBounds.intersects(westBorder) || layerCanvasBounds.intersects(eastBorder);
                if (isWorldMapFullyVisible) {
                    WorldMapPane.this.zoomAll();
                }
            }
        });
    }

    @Override
    public void doLayout() {
        if (this.navControlShown && this.navControlWrapper != null) {
            this.navControlWrapper.setLocation(this.getWidth() - this.navControlWrapper.getWidth() - 4, 4);
        }
        super.doLayout();
    }

    public Product getSelectedProduct() {
        return this.dataModel.getSelectedProduct();
    }

    public Product[] getProducts() {
        return this.dataModel.getProducts();
    }

    public float getScale() {
        return (float)this.getLayerCanvas().getViewport().getZoomFactor();
    }

    public void zoomToProduct(Product product) {
        if (product == null || product.getGeoCoding() == null) {
            return;
        }
        GeneralPath[] generalPaths = WorldMapPane.getGeoBoundaryPaths(product);
        Rectangle2D modelArea = new Rectangle2D.Double();
        Viewport viewport = this.getLayerCanvas().getViewport();
        for (GeneralPath generalPath : generalPaths) {
            Rectangle2D rectangle2D = generalPath.getBounds2D();
            if (((RectangularShape)modelArea).isEmpty()) {
                if (!viewport.isModelYAxisDown()) {
                    modelArea.setFrame(rectangle2D.getX(), rectangle2D.getMaxY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                }
                modelArea = rectangle2D;
                continue;
            }
            modelArea.add(rectangle2D);
        }
        Rectangle2D modelBounds = ((Rectangle2D)modelArea).getBounds2D();
        modelBounds.setFrame(modelBounds.getX() - 2.0, modelBounds.getY() - 2.0, modelBounds.getWidth() + 4.0, modelBounds.getHeight() + 4.0);
        modelBounds = this.cropToMaxModelBounds(modelBounds);
        viewport.zoom(modelBounds);
        this.fireScrolled();
    }

    public void zoomAll() {
        this.getLayerCanvas().getViewport().zoom(this.worldMapLayer.getModelBounds());
        this.fireScrolled();
    }

    public void setNavControlVisible(boolean navControlShown) {
        boolean oldValue = this.navControlShown;
        if (oldValue != navControlShown) {
            if (navControlShown) {
                Action[] overlayActions = this.getOverlayActions();
                ButtonOverlayControl navControl = new ButtonOverlayControl(overlayActions.length, overlayActions);
                this.navControlWrapper = new WakefulComponent((JComponent)navControl);
                this.navControlWrapper.setMinAlpha(0.3f);
                this.getLayerCanvas().add((Component)this.navControlWrapper);
            } else {
                this.getLayerCanvas().remove((Component)this.navControlWrapper);
                this.navControlWrapper = null;
            }
            this.validate();
            this.navControlShown = navControlShown;
        }
    }

    public void setPanSupport(PanSupport panSupport) {
        this.layerCanvas.removeMouseListener((MouseListener)this.mouseHandler);
        this.layerCanvas.removeMouseMotionListener((MouseMotionListener)this.mouseHandler);
        this.panSupport = panSupport;
        this.mouseHandler = new MouseHandler();
        this.layerCanvas.addMouseListener((MouseListener)this.mouseHandler);
        this.layerCanvas.addMouseMotionListener((MouseMotionListener)this.mouseHandler);
    }

    public LayerCanvas getLayerCanvas() {
        return this.layerCanvas;
    }

    static GeneralPath[] getGeoBoundaryPaths(Product product) {
        int step = Math.max(16, (product.getSceneRasterWidth() + product.getSceneRasterHeight()) / 250);
        return ProductUtils.createGeoBoundaryPaths((Product)product, null, (int)step);
    }

    public boolean addZoomListener(ZoomListener zoomListener) {
        return this.zoomListeners.add(zoomListener);
    }

    public boolean removeZoomListener(ZoomListener zoomListener) {
        return this.zoomListeners.remove(zoomListener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.navControlWrapper.setEnabled(enabled);
    }

    protected Action[] getOverlayActions() {
        return new Action[]{new ZoomAllAction(), new ZoomToSelectedAction()};
    }

    private void fireScrolled() {
        for (ZoomListener zoomListener : this.zoomListeners) {
            zoomListener.zoomed();
        }
    }

    private void updateUiState(PropertyChangeEvent evt) {
        if ("layer".equals(evt.getPropertyName())) {
            this.exchangeWorldMapLayer();
        }
        if ("products".equals(evt.getPropertyName())) {
            this.repaint();
        }
        if ("selectedProduct".equals(evt.getPropertyName()) || "autoZoomEnabled".equals(evt.getPropertyName())) {
            Product selectedProduct = this.dataModel.getSelectedProduct();
            if (selectedProduct != null && this.dataModel.isAutoZoomEnabled()) {
                this.zoomToProduct(selectedProduct);
            } else {
                this.repaint();
            }
        }
        if ("additionalGeoBoundaries".equals(evt.getPropertyName())) {
            this.repaint();
        }
    }

    private void exchangeWorldMapLayer() {
        List children = this.getLayerCanvas().getLayer().getChildren();
        for (Layer child : children) {
            child.dispose();
        }
        children.clear();
        Layer rootLayer = this.getLayerCanvas().getLayer();
        this.worldMapLayer = this.dataModel.getWorldMapLayer(new WorldMapLayerContext(rootLayer));
        children.add(this.worldMapLayer);
        this.zoomAll();
    }

    private Rectangle2D cropToMaxModelBounds(Rectangle2D modelBounds) {
        Rectangle2D maxModelBounds = this.worldMapLayer.getModelBounds();
        if (modelBounds.getWidth() >= maxModelBounds.getWidth() - 1.0 || modelBounds.getHeight() >= maxModelBounds.getHeight() - 1.0) {
            modelBounds = maxModelBounds;
        }
        return modelBounds;
    }

    private void installLayerCanvasNavigation(LayerCanvas layerCanvas) {
        this.mouseHandler = new MouseHandler();
        layerCanvas.addMouseListener((MouseListener)this.mouseHandler);
        layerCanvas.addMouseMotionListener((MouseMotionListener)this.mouseHandler);
        layerCanvas.addMouseWheelListener((MouseWheelListener)this.mouseHandler);
    }

    private static boolean viewportIsInWorldMapBounds(double dx, double dy, LayerCanvas layerCanvas) {
        AffineTransform transform = layerCanvas.getViewport().getModelToViewTransform();
        double minX = layerCanvas.getMaxVisibleModelBounds().getMinX();
        double minY = layerCanvas.getMaxVisibleModelBounds().getMinY();
        double maxX = layerCanvas.getMaxVisibleModelBounds().getMaxX();
        double maxY = layerCanvas.getMaxVisibleModelBounds().getMaxY();
        Point2D upperLeft = transform.transform(new Point2D.Double(minX, minY), null);
        Point2D lowerRight = transform.transform(new Point2D.Double(maxX, maxY), null);
        Rectangle2D.Double northBorder = new Rectangle2D.Double(upperLeft.getX() + dx, upperLeft.getY() + dy, lowerRight.getX() + dx - upperLeft.getX() + dx, 1.0);
        Rectangle2D.Double southBorder = new Rectangle2D.Double(upperLeft.getX() + dx, lowerRight.getY() + dy, lowerRight.getX() + dx - upperLeft.getX() + dx, 1.0);
        Rectangle2D.Double westBorder = new Rectangle2D.Double(upperLeft.getX() + dx, lowerRight.getY() + dy, 1.0, upperLeft.getY() + dy - lowerRight.getY() + dy);
        Rectangle2D.Double eastBorder = new Rectangle2D.Double(lowerRight.getX() + dx, lowerRight.getY() + dy, 1.0, upperLeft.getY() + dy - lowerRight.getY() + dy);
        return !layerCanvas.getBounds().intersects(northBorder) && !layerCanvas.getBounds().intersects(southBorder) && !layerCanvas.getBounds().intersects(westBorder) && !layerCanvas.getBounds().intersects(eastBorder);
    }

    @Deprecated
    public void setScale(float scale) {
        if (this.getScale() != scale && scale > 0.0f) {
            float oldValue = this.getScale();
            this.getLayerCanvas().getViewport().setZoomFactor((double)scale);
            this.firePropertyChange("scale", oldValue, scale);
        }
    }

    protected static class DefaultPanSupport
    implements PanSupport {
        private Point p0;
        private final LayerCanvas layerCanvas;

        protected DefaultPanSupport(LayerCanvas layerCanvas) {
            this.layerCanvas = layerCanvas;
        }

        @Override
        public void panStarted(MouseEvent event) {
            this.p0 = event.getPoint();
        }

        @Override
        public void performPan(MouseEvent event) {
            Point p = event.getPoint();
            double dx = p.x - this.p0.x;
            double dy = p.y - this.p0.y;
            if (WorldMapPane.viewportIsInWorldMapBounds(dx, dy, this.layerCanvas)) {
                this.layerCanvas.getViewport().moveViewDelta(dx, dy);
            }
            this.p0 = p;
        }

        @Override
        public void panStopped(MouseEvent event) {
        }
    }

    public static interface PanSupport {
        public void panStarted(MouseEvent var1);

        public void performPan(MouseEvent var1);

        public void panStopped(MouseEvent var1);
    }

    public static interface ZoomListener {
        public void zoomed();
    }

    private class ZoomToSelectedAction
    extends AbstractAction {
        private ZoomToSelectedAction() {
            this.putValue("SwingLargeIconKey", UIUtils.loadImageIcon("icons/ZoomTo24.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                Product selectedProduct = WorldMapPane.this.getSelectedProduct();
                WorldMapPane.this.zoomToProduct(selectedProduct);
            }
        }
    }

    private class ZoomAllAction
    extends AbstractAction {
        private ZoomAllAction() {
            this.putValue("SwingLargeIconKey", UIUtils.loadImageIcon("/com/bc/ceres/swing/actions/icons_22x22/view-fullscreen.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                WorldMapPane.this.zoomAll();
            }
        }
    }

    private static class WorldMapLayerContext
    implements LayerContext {
        private final Layer rootLayer;

        private WorldMapLayerContext(Layer rootLayer) {
            this.rootLayer = rootLayer;
        }

        public Object getCoordinateReferenceSystem() {
            return DefaultGeographicCRS.WGS84;
        }

        public Layer getRootLayer() {
            return this.rootLayer;
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            WorldMapPane.this.panSupport.panStarted(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            WorldMapPane.this.panSupport.performPan(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            WorldMapPane.this.panSupport.panStopped(e);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (!WorldMapPane.this.isEnabled()) {
                return;
            }
            double oldFactor = WorldMapPane.this.layerCanvas.getViewport().getZoomFactor();
            int wheelRotation = e.getWheelRotation();
            double newZoomFactor = WorldMapPane.this.layerCanvas.getViewport().getZoomFactor() * Math.pow(1.1, wheelRotation);
            Rectangle viewBounds = WorldMapPane.this.layerCanvas.getViewport().getViewBounds();
            Rectangle2D modelBounds = WorldMapPane.this.worldMapLayer.getModelBounds();
            double minZoomFactor = Math.min(viewBounds.getWidth() / modelBounds.getWidth(), viewBounds.getHeight() / modelBounds.getHeight());
            WorldMapPane.this.layerCanvas.getViewport().setZoomFactor(Math.max(newZoomFactor, minZoomFactor));
            if (WorldMapPane.this.layerCanvas.getViewport().getZoomFactor() > oldFactor || WorldMapPane.viewportIsInWorldMapBounds(0.0, 0.0, WorldMapPane.this.layerCanvas)) {
                WorldMapPane.this.fireScrolled();
                return;
            }
            WorldMapPane.this.layerCanvas.getViewport().setZoomFactor(oldFactor);
        }
    }

    private class ModelChangeListener
    implements PropertyChangeListener {
        private ModelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            WorldMapPane.this.updateUiState(evt);
        }
    }
}

