/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui;

import java.awt.Frame;
import javax.swing.JDialog;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.help.HelpSys;
import org.esa.beam.framework.ui.WorldMapPane;
import org.esa.beam.framework.ui.WorldMapPaneDataModel;

public class WorldMapWindow
extends JDialog {
    private static final String DEFAUL_TTITLE = "World Map";
    private String helpId;
    private WorldMapPaneDataModel worldMapDataModel;

    public WorldMapWindow(Frame owner, String title, String helpId) {
        super(owner, title != null && title.length() > 0 ? title : DEFAUL_TTITLE, false);
        this.helpId = helpId;
        this.createUI();
        if (this.helpId != null) {
            HelpSys.enableHelpKey(this.getContentPane(), this.helpId);
        }
    }

    public void setSelectedProduct(Product product) {
        this.worldMapDataModel.setSelectedProduct(product);
    }

    public Product getSelectedProduct() {
        return this.worldMapDataModel.getSelectedProduct();
    }

    public void setProducts(Product[] products) {
        this.worldMapDataModel.setProducts(products);
    }

    public void setPathesToDisplay(GeoPos[][] geoBoundaries) {
        this.worldMapDataModel.setAdditionalGeoBoundaries(geoBoundaries);
    }

    private void createUI() {
        this.worldMapDataModel = new WorldMapPaneDataModel();
        WorldMapPane mapPane = new WorldMapPane(this.worldMapDataModel);
        this.setContentPane(mapPane);
        if (this.helpId != null) {
            HelpSys.enableHelpKey(this, this.helpId);
        }
    }
}

