/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.application.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.beam.framework.ui.application.ApplicationPage;
import org.esa.beam.framework.ui.application.DocView;
import org.esa.beam.framework.ui.application.PageComponent;
import org.esa.beam.framework.ui.application.PageComponentListener;
import org.esa.beam.framework.ui.application.PageComponentPane;
import org.esa.beam.framework.ui.application.ToolView;
import org.esa.beam.framework.ui.application.ToolViewDescriptor;
import org.esa.beam.framework.ui.application.support.AbstractControlFactory;
import org.esa.beam.framework.ui.application.support.DefaultPageComponentContext;
import org.esa.beam.util.Debug;

public abstract class AbstractApplicationPage
extends AbstractControlFactory
implements ApplicationPage {
    private final List<PageComponentListener> pageComponentListeners = new ArrayList<PageComponentListener>();
    private final Map<String, PageComponent> pageComponentMap = new HashMap<String, PageComponent>();
    private PageComponent activeComponent;
    private boolean settingActiveComponent;
    private PropertyChangeListener pageComponentUpdater = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractApplicationPage.this.pageComponentChanged(evt);
        }
    };

    protected AbstractApplicationPage() {
    }

    @Override
    public void addPageComponentListener(PageComponentListener listener) {
        this.pageComponentListeners.add(listener);
    }

    @Override
    public void removePageComponentListener(PageComponentListener listener) {
        this.pageComponentListeners.remove(listener);
    }

    @Override
    public PageComponent getActiveComponent() {
        return this.activeComponent;
    }

    @Override
    public void close(PageComponent pageComponent) {
        if (!this.pageComponentMap.containsValue(pageComponent)) {
            return;
        }
        if (pageComponent == this.activeComponent) {
            this.fireFocusLost(pageComponent);
            this.activeComponent = null;
        }
        this.pageComponentMap.remove(pageComponent.getId());
        if (pageComponent instanceof ToolView) {
            ToolView toolView = (ToolView)pageComponent;
            this.doRemoveToolView(toolView);
        } else if (pageComponent instanceof DocView) {
            // empty if block
        }
        pageComponent.removePropertyChangeListener(this.pageComponentUpdater);
        this.fireHidden(pageComponent);
        this.fireClosed(pageComponent);
        pageComponent.dispose();
        if (this.activeComponent == null) {
            this.setActiveComponent();
        }
    }

    @Override
    public boolean close() {
        for (PageComponent component : this.pageComponentMap.values()) {
            this.close(component);
        }
        return true;
    }

    @Override
    public PageComponent getPageComponent(String id) {
        return this.pageComponentMap.get(id);
    }

    @Override
    public ToolView[] getToolViews() {
        ArrayList<ToolView> toolViews = new ArrayList<ToolView>(this.pageComponentMap.size());
        for (PageComponent component : this.pageComponentMap.values()) {
            if (!(component instanceof ToolView)) continue;
            toolViews.add((ToolView)component);
        }
        return toolViews.toArray(new ToolView[toolViews.size()]);
    }

    @Override
    public ToolView getToolView(String id) {
        PageComponent component = this.getPageComponent(id);
        if (component instanceof ToolView) {
            return (ToolView)component;
        }
        return null;
    }

    public abstract ToolViewDescriptor getToolViewDescriptor(String var1);

    @Override
    public ToolView addToolView(ToolViewDescriptor viewDescriptor) {
        ToolView toolView = this.getToolView(viewDescriptor.getId());
        if (toolView != null) {
            throw new IllegalStateException("pageComponent != null");
        }
        toolView = this.createToolView(viewDescriptor);
        this.pageComponentMap.put(viewDescriptor.getId(), toolView);
        this.doAddToolView(toolView);
        toolView.addPropertyChangeListener(this.pageComponentUpdater);
        return toolView;
    }

    @Override
    public ToolView showToolView(String id) {
        return this.showToolView(this.getToolViewDescriptor(id));
    }

    @Override
    public ToolView showToolView(ToolViewDescriptor viewDescriptor) {
        ToolView toolView = this.getToolView(viewDescriptor.getId());
        if (toolView == null) {
            toolView = this.addToolView(viewDescriptor);
        }
        this.doShowToolView(toolView);
        this.fireShown(toolView);
        this.setActiveComponent(toolView);
        return toolView;
    }

    @Override
    public void hideToolView(ToolView toolView) {
        this.doHideToolView(toolView);
        this.fireHidden(toolView);
        this.setActiveComponent();
    }

    @Override
    public DocView openDocView(Object editorInput) {
        return null;
    }

    @Override
    public boolean closeAllDocViews() {
        return true;
    }

    protected ToolView createToolView(ToolViewDescriptor descriptor) {
        ToolView toolView = (ToolView)descriptor.createPageComponent();
        toolView.setContext(new DefaultPageComponentContext(this, this.createToolViewPane(toolView)));
        return toolView;
    }

    protected void pageComponentChanged(PropertyChangeEvent evt) {
    }

    protected void fireOpened(PageComponent component) {
        Debug.trace((String)("AbstractApplicationPage.fireOpened [" + component + "]"));
        component.componentOpened();
        for (PageComponentListener listener : this.pageComponentListeners) {
            listener.componentOpened(component);
        }
    }

    protected void fireClosed(PageComponent component) {
        Debug.trace((String)("AbstractApplicationPage.fireClosed [" + component + "]"));
        component.componentClosed();
        for (PageComponentListener listener : this.pageComponentListeners) {
            listener.componentClosed(component);
        }
    }

    protected void fireShown(PageComponent component) {
        Debug.trace((String)("AbstractApplicationPage.fireShown [" + component + "]"));
        for (PageComponentListener listener : this.pageComponentListeners) {
            listener.componentShown(component);
        }
    }

    protected void fireHidden(PageComponent component) {
        Debug.trace((String)("AbstractApplicationPage.fireHidden [" + component + "]"));
        for (PageComponentListener listener : this.pageComponentListeners) {
            listener.componentHidden(component);
        }
    }

    protected void fireFocusGained(PageComponent component) {
        Debug.trace((String)("AbstractApplicationPage.fireFocusGained [" + component + "]"));
        component.componentFocusGained();
        for (PageComponentListener listener : this.pageComponentListeners) {
            listener.componentFocusGained(component);
        }
    }

    protected void fireFocusLost(PageComponent component) {
        Debug.trace((String)("AbstractApplicationPage.fireFocusLost [" + component + "]"));
        component.componentFocusLost();
        for (PageComponentListener listener : this.pageComponentListeners) {
            listener.componentFocusLost(component);
        }
    }

    protected abstract void setActiveComponent();

    public void setActiveComponent(PageComponent pageComponent) {
        if (!this.pageComponentMap.containsValue(pageComponent)) {
            return;
        }
        Debug.trace((String)("setActiveComponent: pageComponent = " + pageComponent));
        if (this.settingActiveComponent) {
            return;
        }
        if (this.activeComponent == pageComponent) {
            this.setActiveSelectionContext();
            return;
        }
        this.settingActiveComponent = true;
        if (this.activeComponent != null) {
            this.fireFocusLost(this.activeComponent);
        }
        this.giveFocusTo(pageComponent);
        this.activeComponent = pageComponent;
        this.fireFocusGained(this.activeComponent);
        this.setActiveSelectionContext();
        this.settingActiveComponent = false;
    }

    private void setActiveSelectionContext() {
        if (this.activeComponent != null) {
            this.getSelectionManager().setSelectionContext(this.activeComponent.getSelectionContext());
        } else {
            this.getSelectionManager().setSelectionContext(null);
        }
    }

    protected abstract void doAddToolView(ToolView var1);

    protected abstract void doRemoveToolView(ToolView var1);

    protected abstract void doShowToolView(ToolView var1);

    protected abstract void doHideToolView(ToolView var1);

    protected abstract boolean giveFocusTo(PageComponent var1);

    protected abstract PageComponentPane createToolViewPane(ToolView var1);
}

