/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.application.support;

import javax.swing.JComponent;
import org.esa.beam.framework.ui.application.ControlFactory;

public abstract class AbstractControlFactory
implements ControlFactory {
    private boolean singleton = true;
    private JComponent control;

    protected AbstractControlFactory() {
    }

    protected final synchronized boolean isSingleton() {
        return this.singleton;
    }

    protected final synchronized void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    @Override
    public final synchronized JComponent getControl() {
        if (this.isSingleton()) {
            if (this.control == null) {
                this.control = this.createControl();
            }
            return this.control;
        }
        return this.createControl();
    }

    public final synchronized boolean isControlCreated() {
        return this.isSingleton() && this.control != null;
    }

    protected synchronized void createControlIfNecessary() {
        if (this.isSingleton() && this.control == null) {
            this.getControl();
        }
    }

    protected abstract JComponent createControl();
}

