/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.application.support;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.runtime.ConfigurableExtension;
import com.bc.ceres.core.runtime.ConfigurationElement;
import com.bc.ceres.core.runtime.Module;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.SingleValueConverterWrapper;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.util.ArrayList;
import org.esa.beam.framework.ui.application.ApplicationDescriptor;
import org.esa.beam.util.SystemUtils;

public class DefaultApplicationDescriptor
implements ConfigurableExtension,
ApplicationDescriptor {
    private String applicationId;
    private String version;
    private String buildId;
    private String buildDate;
    private String copyright;
    private String displayName;
    private String symbolicName;
    private String loggerName;
    @XStreamAlias(value="resourceBundle")
    private String resourceBundleName;
    @XStreamAlias(value="frameIcons")
    private String frameIconPaths;
    @XStreamAlias(value="aboutImage")
    private String aboutImagePath;
    private ArrayList<ID> excludedActions;
    private ArrayList<ID> excludedActionGroups;
    private ArrayList<ID> excludedToolViews;

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    @Override
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFrameIconPaths() {
        return this.frameIconPaths;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getAboutImagePath() {
        return this.aboutImagePath;
    }

    @Override
    public String[] getExcludedActions() {
        return this.toStringArray(this.excludedActions);
    }

    @Override
    public String[] getExcludedActionGroups() {
        return this.toStringArray(this.excludedActionGroups);
    }

    @Override
    public String[] getExcludedToolViews() {
        return this.toStringArray(this.excludedToolViews);
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setResourceBundleName(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
    }

    public void setFrameIconPaths(String frameIconPaths) {
        this.frameIconPaths = frameIconPaths;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setAboutImagePath(String aboutImagePath) {
        this.aboutImagePath = aboutImagePath;
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getBuildId() {
        return this.buildId;
    }

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    @Override
    public String getBuildDate() {
        return this.buildDate;
    }

    public void setBuildDate(String buildDate) {
        this.buildDate = buildDate;
    }

    public void configure(ConfigurationElement config) throws CoreException {
        if (this.applicationId == null) {
            throw new CoreException(String.format("Missing configuration element 'applicationId' in element '%s'.", config.getName()));
        }
        Module declaringModule = config.getDeclaringExtension().getDeclaringModule();
        if (this.displayName == null) {
            this.displayName = declaringModule.getName();
        }
        if (this.symbolicName == null) {
            this.symbolicName = declaringModule.getSymbolicName();
        }
        String versionKey = SystemUtils.getApplicationContextId() + ".version";
        if (this.version == null || String.format("${%s}", versionKey).equals(this.version)) {
            this.version = System.getProperty(versionKey);
        }
        String buildIdKey = SystemUtils.getApplicationContextId() + ".build.id";
        if (this.buildId == null || String.format("${%s}", buildIdKey).equals(this.buildId)) {
            this.buildId = System.getProperty(buildIdKey);
        }
        String buildDateKey = SystemUtils.getApplicationContextId() + ".build.date";
        if (this.buildDate == null || String.format("${%s}", buildDateKey).equals(this.buildDate)) {
            this.buildDate = System.getProperty(buildDateKey);
        }
        if (this.copyright == null) {
            this.copyright = declaringModule.getCopyright();
        }
        if (this.frameIconPaths == null) {
            this.frameIconPaths = "/org/esa/beam/resources/images/icons/BeamIcon24.png";
        }
        if (this.aboutImagePath == null) {
            this.aboutImagePath = "/org/esa/beam/resources/images/about.jpg";
        }
        if (this.loggerName == null) {
            this.loggerName = declaringModule.getSymbolicName();
        }
    }

    private String[] toStringArray(ArrayList<ID> idList) {
        if (idList == null) {
            return new String[0];
        }
        String[] strings = new String[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            ID id = idList.get(i);
            strings[i] = id.id;
        }
        return strings;
    }

    public static class IDSVC
    extends AbstractSingleValueConverter {
        public boolean canConvert(Class type) {
            return type == ID.class;
        }

        public Object fromString(String str) {
            return new ID(str);
        }
    }

    public static class IDC
    extends SingleValueConverterWrapper {
        public IDC() {
            super((SingleValueConverter)new IDSVC());
        }
    }

    @XStreamAlias(value="id")
    @XStreamConverter(value=IDC.class)
    public static class ID {
        private String id;

        private ID(String id) {
            this.id = id;
        }
    }
}

