/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.application.support;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.core.Assert;
import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.runtime.ConfigurableExtension;
import com.bc.ceres.core.runtime.ConfigurationElement;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.application.ApplicationPage;
import org.esa.beam.framework.ui.application.PageComponent;
import org.esa.beam.framework.ui.application.ToolView;
import org.esa.beam.framework.ui.application.ToolViewDescriptor;
import org.esa.beam.framework.ui.command.Command;
import org.esa.beam.framework.ui.command.CommandAdapter;
import org.esa.beam.framework.ui.command.CommandEvent;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.esa.beam.framework.ui.xstream.converters.KeyStrokeConverter;

@XStreamAlias(value="toolView")
public class DefaultToolViewDescriptor
implements ToolViewDescriptor,
ConfigurableExtension {
    private String id;
    @XStreamAlias(value="class")
    private Class toolViewClass;
    private String title;
    private String tabTitle;
    private String description;
    @XStreamAlias(value="smallIcon")
    private String smallIconPath;
    @XStreamAlias(value="largeIcon")
    private String largeIconPath;
    private String helpId;
    @XStreamConverter(value=KeyStrokeConverter.class)
    private KeyStroke accelerator;
    private char mnemonic;
    private String toolBarId;
    private ToolViewDescriptor.State initState;
    private ToolViewDescriptor.DockSide initSide;
    private int initIndex = 0;
    private int dockedWidth;
    private int dockedHeight;
    private Rectangle floatingBounds;
    private Dimension preferredSize;
    private transient Icon smallIcon;
    private transient Icon largeIcon;
    private transient PropertyContainer propertyContainer = PropertyContainer.createObjectBacked((Object)this);

    public DefaultToolViewDescriptor() {
        this.initState = ToolViewDescriptor.State.HIDDEN;
        this.preferredSize = new Dimension(320, 200);
        this.floatingBounds = new Rectangle(100, 100, 640, 400);
        this.initSide = ToolViewDescriptor.DockSide.WEST;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.setValue("helpId", helpId);
    }

    @Override
    public String getTitle() {
        if (this.title == null) {
            this.title = this.tabTitle;
        }
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.setValue("title", title);
    }

    @Override
    public String getTabTitle() {
        if (this.tabTitle == null) {
            this.tabTitle = this.title;
        }
        return this.tabTitle;
    }

    @Override
    public void setTabTitle(String tabTitle) {
        this.setValue("tabTitle", tabTitle);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.setValue("description", description);
    }

    @Override
    public String getToolBarId() {
        return this.toolBarId;
    }

    @Override
    public void setToolBarId(String toolBarId) {
        this.toolBarId = toolBarId;
    }

    @Override
    public Icon getSmallIcon() {
        if (this.smallIconPath != null && this.smallIcon == null) {
            this.smallIcon = UIUtils.loadImageIcon(this.smallIconPath, this.toolViewClass);
        }
        return this.smallIcon;
    }

    @Override
    public Icon getLargeIcon() {
        if (this.largeIconPath != null && this.largeIcon == null) {
            this.largeIcon = UIUtils.loadImageIcon(this.largeIconPath, this.toolViewClass);
        }
        return this.largeIcon;
    }

    @Override
    public void setSmallIcon(Icon smallIcon) {
        this.setValue("smallIcon", smallIcon);
    }

    @Override
    public void setLargeIcon(Icon largeIcon) {
        this.setValue("largeIcon", largeIcon);
    }

    @Override
    public char getMnemonic() {
        return this.mnemonic;
    }

    @Override
    public void setMnemonic(char mnemonic) {
        this.setValue("mnemonic", Character.valueOf(mnemonic));
    }

    @Override
    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    @Override
    public void setAccelerator(KeyStroke accelerator) {
        this.setValue("accelerator", accelerator);
    }

    @Override
    public ToolViewDescriptor.State getInitState() {
        return this.initState;
    }

    @Override
    public void setInitState(ToolViewDescriptor.State initState) {
        this.setValue("initState", (Object)initState);
    }

    @Override
    public ToolViewDescriptor.DockSide getInitSide() {
        return this.initSide;
    }

    @Override
    public void setInitSide(ToolViewDescriptor.DockSide initSide) {
        this.setValue("initSide", (Object)initSide);
    }

    @Override
    public int getInitIndex() {
        return this.initIndex;
    }

    @Override
    public void setInitIndex(int initIndex) {
        this.setValue("initIndex", initIndex);
    }

    @Override
    public int getDockedWidth() {
        return this.dockedWidth;
    }

    @Override
    public void setDockedWidth(int dockedWidth) {
        this.setValue("dockedWidth", dockedWidth);
    }

    @Override
    public int getDockedHeight() {
        return this.dockedHeight;
    }

    @Override
    public void setDockedHeight(int dockedHeight) {
        this.setValue("dockedHeight", dockedHeight);
    }

    @Override
    public Rectangle getFloatingBounds() {
        return this.floatingBounds;
    }

    @Override
    public void setFloatingBounds(Rectangle floatingBounds) {
        this.setValue("floatingBounds", floatingBounds);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.setValue("preferredSize", preferredSize);
    }

    @Override
    public boolean isHidable() {
        return false;
    }

    @Override
    public void setHidable(boolean state) {
    }

    @Override
    public boolean isDockable() {
        return false;
    }

    @Override
    public void setDockable(boolean state) {
    }

    @Override
    public boolean isFloatable() {
        return false;
    }

    @Override
    public void setFloatable(boolean state) {
    }

    @Override
    public boolean isAutohidable() {
        return false;
    }

    @Override
    public void setAutohidable(boolean state) {
    }

    @Override
    public boolean isMaximizable() {
        return false;
    }

    @Override
    public void setMaximizable(boolean state) {
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public void setVisible(boolean state) {
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public void setEnabled(boolean state) {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyContainer.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyContainer.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyContainer.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyContainer.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public PageComponent createPageComponent() {
        return this.createToolView();
    }

    protected ToolView createToolView() {
        Object object;
        Assert.state((this.toolViewClass != null ? 1 : 0) != 0, (String)"toolViewClass != null");
        try {
            object = this.toolViewClass.newInstance();
        }
        catch (Throwable e) {
            throw new IllegalStateException("viewClass.newInstance()", e);
        }
        Assert.state((boolean)(object instanceof ToolView), (String)"object instanceof ToolView");
        ToolView toolView = (ToolView)object;
        toolView.setDescriptor(this);
        return toolView;
    }

    @Override
    public Command createShowViewCommand(final ApplicationPage applicationPage) {
        char mnemonic;
        String commandId = this.getId() + ".showCmd";
        ExecCommand command = applicationPage.getCommandManager().createExecCommand(commandId, new CommandAdapter(){

            @Override
            public void updateState(CommandEvent event) {
                ToolView pageComponent = applicationPage.getToolView(DefaultToolViewDescriptor.this.getId());
                ExecCommand ecmd = (ExecCommand)event.getCommand();
                JComponent control = pageComponent.getContext().getPane().getControl();
                ecmd.setEnabled(control.isEnabled());
            }

            @Override
            public void actionPerformed(CommandEvent event) {
                applicationPage.showToolView(DefaultToolViewDescriptor.this.getId());
            }
        });
        command.setParent("showToolViews");
        command.setSmallIcon(this.getSmallIcon());
        command.setLargeIcon(this.getLargeIcon());
        command.setShortDescription(this.getDescription());
        command.setLongDescription(this.getDescription());
        command.setText(this.getTabTitle());
        KeyStroke accelerator = this.getAccelerator();
        if (accelerator != null) {
            command.setAccelerator(accelerator);
        }
        if ((mnemonic = this.getMnemonic()) != '\uffffffff') {
            command.setMnemonic(mnemonic);
        }
        return command;
    }

    public void configure(ConfigurationElement config) throws CoreException {
    }

    private void setValue(String key, Object value) {
        this.propertyContainer.setValue(key, value);
    }
}

