/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.application.support;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.event.DockableFrameAdapter;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.jidesoft.docking.event.DockableFrameListener;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.esa.beam.framework.ui.application.PageComponent;
import org.esa.beam.framework.ui.application.ToolViewDescriptor;
import org.esa.beam.framework.ui.application.support.AbstractPageComponentPane;
import org.esa.beam.util.Debug;

public class DefaultToolViewPane
extends AbstractPageComponentPane {
    private DockableFrame dockableFrame;
    private boolean pageComponentControlCreated;

    public DefaultToolViewPane(PageComponent pageComponent) {
        super(pageComponent);
    }

    @Override
    protected JComponent createControl() {
        this.dockableFrame = new DockableFrame();
        this.dockableFrame.setKey(this.getPageComponent().getId());
        this.configureControl(true);
        this.dockableFrame.addDockableFrameListener((DockableFrameListener)new DockableFrameHandler());
        this.nameComponent((JComponent)this.dockableFrame, "Pane");
        return this.dockableFrame;
    }

    @Override
    protected void pageComponentChanged(PropertyChangeEvent evt) {
        this.configureControl(false);
    }

    private void configureControl(boolean init) {
        ToolViewDescriptor toolViewDescriptor = (ToolViewDescriptor)this.getPageComponent().getDescriptor();
        this.dockableFrame.setTitle(toolViewDescriptor.getTitle());
        this.dockableFrame.setTabTitle(toolViewDescriptor.getTabTitle());
        this.dockableFrame.setFrameIcon(toolViewDescriptor.getSmallIcon());
        this.dockableFrame.setToolTipText(toolViewDescriptor.getDescription());
        if (init) {
            if (toolViewDescriptor.getFloatingBounds() != null) {
                this.dockableFrame.setUndockedBounds(toolViewDescriptor.getFloatingBounds());
            }
            if (toolViewDescriptor.getDockedWidth() > 0) {
                this.dockableFrame.getContext().setDockedWidth(toolViewDescriptor.getDockedWidth());
            }
            if (toolViewDescriptor.getDockedHeight() > 0) {
                this.dockableFrame.getContext().setDockedHeight(toolViewDescriptor.getDockedHeight());
            }
            if (toolViewDescriptor.getInitIndex() >= 0) {
                this.dockableFrame.getContext().setInitIndex(toolViewDescriptor.getInitIndex());
            }
            if (toolViewDescriptor.getInitSide() != null) {
                this.dockableFrame.getContext().setInitSide(this.toJideSide(toolViewDescriptor.getInitSide()));
            }
            if (toolViewDescriptor.getInitState() != null) {
                this.dockableFrame.getContext().setInitMode(this.toJideMode(toolViewDescriptor.getInitState()));
            }
        }
    }

    private int toJideMode(ToolViewDescriptor.State state) {
        if (state == ToolViewDescriptor.State.DOCKED) {
            return 4;
        }
        if (state == ToolViewDescriptor.State.FLOATING) {
            return 1;
        }
        if (state == ToolViewDescriptor.State.ICONIFIED) {
            return 2;
        }
        if (state == ToolViewDescriptor.State.ICONIFIED_SHOWING) {
            return 3;
        }
        if (state == ToolViewDescriptor.State.HIDDEN) {
            return 0;
        }
        throw new IllegalStateException("unhandled " + ToolViewDescriptor.State.class);
    }

    private int toJideSide(ToolViewDescriptor.DockSide dockSide) {
        if (dockSide == ToolViewDescriptor.DockSide.ALL) {
            return 15;
        }
        if (dockSide == ToolViewDescriptor.DockSide.CENTER) {
            return 16;
        }
        if (dockSide == ToolViewDescriptor.DockSide.WEST) {
            return 8;
        }
        if (dockSide == ToolViewDescriptor.DockSide.EAST) {
            return 4;
        }
        if (dockSide == ToolViewDescriptor.DockSide.NORTH) {
            return 1;
        }
        if (dockSide == ToolViewDescriptor.DockSide.SOUTH) {
            return 2;
        }
        throw new IllegalStateException("unhandled " + ToolViewDescriptor.DockSide.class);
    }

    private void ensurePageComponentControlCreated() {
        if (!this.pageComponentControlCreated) {
            JComponent pageComponentControl;
            Debug.trace((String)("Creating control for page component " + this.getPageComponent().getId()));
            try {
                pageComponentControl = this.getPageComponent().getControl();
            }
            catch (Throwable e) {
                e.printStackTrace();
                String message = "An internal error occurred.\n Not able to create user interface control for \npage component '" + this.getPageComponent().getDescriptor().getTitle() + "'.";
                JOptionPane.showMessageDialog(this.getPageComponent().getContext().getPage().getWindow(), message, "Internal Error", 0);
                pageComponentControl = new JLabel(message);
            }
            if (pageComponentControl.getName() == null) {
                this.nameComponent(pageComponentControl, "Control");
            }
            this.dockableFrame.getContentPane().add((Component)pageComponentControl, "Center");
            this.pageComponentControlCreated = true;
            this.getPageComponent().componentOpened();
        }
    }

    private class DockableFrameHandler
    extends DockableFrameAdapter {
        public void dockableFrameAdded(DockableFrameEvent dockableFrameEvent) {
            Debug.trace((String)("dockableFrameEvent = " + dockableFrameEvent));
        }

        public void dockableFrameRemoved(DockableFrameEvent dockableFrameEvent) {
            Debug.trace((String)("dockableFrameEvent = " + dockableFrameEvent));
        }

        public void dockableFrameShown(DockableFrameEvent dockableFrameEvent) {
            Debug.trace((String)("dockableFrameEvent = " + dockableFrameEvent));
            DefaultToolViewPane.this.ensurePageComponentControlCreated();
            DefaultToolViewPane.this.getPageComponent().componentShown();
        }

        public void dockableFrameHidden(DockableFrameEvent dockableFrameEvent) {
            Debug.trace((String)("dockableFrameEvent = " + dockableFrameEvent));
            if (DefaultToolViewPane.this.pageComponentControlCreated) {
                DefaultToolViewPane.this.getPageComponent().componentHidden();
            }
        }

        public void dockableFrameActivated(DockableFrameEvent dockableFrameEvent) {
            Debug.trace((String)("dockableFrameEvent = " + dockableFrameEvent));
            DefaultToolViewPane.this.ensurePageComponentControlCreated();
        }

        public void dockableFrameDeactivated(DockableFrameEvent dockableFrameEvent) {
            Debug.trace((String)("dockableFrameEvent = " + dockableFrameEvent));
        }

        public void dockableFrameDocked(DockableFrameEvent dockableFrameEvent) {
            Debug.trace((String)("dockableFrameEvent = " + dockableFrameEvent));
        }

        public void dockableFrameFloating(DockableFrameEvent dockableFrameEvent) {
            Debug.trace((String)("dockableFrameEvent = " + dockableFrameEvent));
            DefaultToolViewPane.this.ensurePageComponentControlCreated();
        }

        public void dockableFrameAutohidden(DockableFrameEvent dockableFrameEvent) {
            Debug.trace((String)("dockableFrameEvent = " + dockableFrameEvent));
        }

        public void dockableFrameAutohideShowing(DockableFrameEvent dockableFrameEvent) {
            Debug.trace((String)("dockableFrameEvent = " + dockableFrameEvent));
            DefaultToolViewPane.this.ensurePageComponentControlCreated();
        }

        public void dockableFrameTabShown(DockableFrameEvent dockableFrameEvent) {
            Debug.trace((String)("dockableFrameEvent = " + dockableFrameEvent));
        }

        public void dockableFrameTabHidden(DockableFrameEvent dockableFrameEvent) {
            Debug.trace((String)("dockableFrameEvent = " + dockableFrameEvent));
        }

        public void dockableFrameMaximized(DockableFrameEvent dockableFrameEvent) {
            Debug.trace((String)("dockableFrameEvent = " + dockableFrameEvent));
            DefaultToolViewPane.this.ensurePageComponentControlCreated();
        }

        public void dockableFrameRestored(DockableFrameEvent dockableFrameEvent) {
            Debug.trace((String)("dockableFrameEvent = " + dockableFrameEvent));
            DefaultToolViewPane.this.ensurePageComponentControlCreated();
        }
    }
}

