/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.command;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.runtime.ConfigurableExtension;
import com.bc.ceres.core.runtime.ConfigurationElement;
import java.util.EventListener;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.command.CommandEvent;
import org.esa.beam.framework.ui.command.CommandListener;
import org.esa.beam.framework.ui.command.CommandStateListener;
import org.esa.beam.framework.ui.command.CommandUIFactory;
import org.esa.beam.framework.ui.command.DefaultCommandUIFactory;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.StringUtils;

public abstract class Command
implements ConfigurableExtension {
    private String commandID;
    private final Action action = this.createAction();
    private EventListenerList eventListenerList;
    private static CommandUIFactory commandUIFactory = new DefaultCommandUIFactory();
    public static final String ACTION_KEY_LARGE_ICON = "_largeIcon";
    public static final String ACTION_KEY_SEPARATOR_BEFORE = "_separatorBefore";
    public static final String ACTION_KEY_SEPARATOR_AFTER = "_separatorAfter";
    public static final String ACTION_KEY_PLACE_FIRST = "_placeFirst";
    public static final String ACTION_KEY_PLACE_LAST = "_placeLast";
    public static final String ACTION_KEY_PLACE_BEFORE = "_placeBefore";
    public static final String ACTION_KEY_PLACE_AFTER = "_placeAfter";
    public static final String ACTION_KEY_PLACE_CONTEXT_TOP = "_placeAtContextTop";
    public static final String ACTION_KEY_PARENT = "_parent";
    public static final String ACTION_KEY_LOCATION = "_location";
    public static final String ACTION_KEY_CONTEXT = "_context";
    public static final String ACTION_KEY_POPUP_TEXT = "popupText";
    public static final String ACTION_KEY_SORT_CHILDREN = "_sortChildren";
    public static final String HELP_ID_KEY = "_helpId";

    protected Command() {
        this.setCommandID(this.getClass().getName());
    }

    protected Command(String commandID) {
        this();
        Guardian.assertNotNull((String)commandID, (Object)"commandID");
        this.setCommandID(commandID);
    }

    public String getCommandID() {
        return this.commandID;
    }

    public void setCommandID(String commandId) {
        this.commandID = commandId;
        this.action.putValue("ActionCommandKey", commandId);
    }

    public Action getAction() {
        return this.action;
    }

    public boolean isEnabled() {
        return this.getAction().isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getAction().setEnabled(enabled);
    }

    public String getParent() {
        return (String)this.getProperty(ACTION_KEY_PARENT);
    }

    public void setParent(String value) {
        this.setProperty(ACTION_KEY_PARENT, value);
    }

    public String[] getLocations() {
        return (String[])this.getProperty(ACTION_KEY_LOCATION);
    }

    public void setLocations(String[] locations) {
        this.setProperty(ACTION_KEY_LOCATION, locations);
    }

    public boolean containsLocation(String location) {
        return this.containsProperty(ACTION_KEY_LOCATION, location);
    }

    public String[] getContexts() {
        return (String[])this.getProperty(ACTION_KEY_CONTEXT);
    }

    public void setContexts(String[] contexts) {
        this.setProperty(ACTION_KEY_CONTEXT, contexts);
    }

    public boolean containsContext(String context) {
        return this.containsProperty(ACTION_KEY_CONTEXT, context);
    }

    public String getText() {
        return (String)this.getProperty("Name");
    }

    public void setText(String value) {
        this.setProperty("Name", value);
    }

    public String getPopupText() {
        return (String)this.getProperty(ACTION_KEY_POPUP_TEXT);
    }

    public void setPopupText(String value) {
        this.setProperty(ACTION_KEY_POPUP_TEXT, value);
    }

    public boolean getSortChildren() {
        return this.getProperty(ACTION_KEY_SORT_CHILDREN, false);
    }

    public int getMnemonic() {
        Object property = this.getProperty("MnemonicKey");
        if (property != null) {
            return ((Number)property).intValue();
        }
        return -1;
    }

    public void setMnemonic(int mnemonic) {
        this.setProperty("MnemonicKey", mnemonic);
    }

    public KeyStroke getAccelerator() {
        return (KeyStroke)this.getProperty("AcceleratorKey");
    }

    public void setAccelerator(KeyStroke accelerator) {
        this.setProperty("AcceleratorKey", accelerator);
    }

    public String getShortDescription() {
        return (String)this.getProperty("ShortDescription");
    }

    public void setShortDescription(String text) {
        this.setProperty("ShortDescription", text);
    }

    public String getLongDescription() {
        return (String)this.getProperty("LongDescription");
    }

    public void setLongDescription(String text) {
        this.setProperty("LongDescription", text);
    }

    public String getHelpId() {
        return this.getProperty(HELP_ID_KEY, "");
    }

    public void setHelpId(String id) {
        this.setProperty(HELP_ID_KEY, id);
    }

    public Icon getSmallIcon() {
        return (Icon)this.getProperty("SmallIcon");
    }

    public void setSmallIcon(Icon icon) {
        this.setProperty("SmallIcon", icon);
    }

    public Icon getLargeIcon() {
        return (Icon)this.getProperty(ACTION_KEY_LARGE_ICON);
    }

    public void setLargeIcon(Icon icon) {
        this.setProperty(ACTION_KEY_LARGE_ICON, icon);
    }

    public boolean isSeparatorBefore() {
        return this.getProperty(ACTION_KEY_SEPARATOR_BEFORE, false);
    }

    public void setSeparatorBefore(boolean separatorBefore) {
        this.setProperty(ACTION_KEY_SEPARATOR_BEFORE, separatorBefore);
    }

    public boolean isSeparatorAfter() {
        return this.getProperty(ACTION_KEY_SEPARATOR_AFTER, false);
    }

    public void setSeparatorAfter(boolean separatorAfter) {
        this.setProperty(ACTION_KEY_SEPARATOR_AFTER, separatorAfter);
    }

    public boolean getPlaceFirst() {
        return this.getProperty(ACTION_KEY_PLACE_FIRST, false);
    }

    public void setPlaceFirst(boolean value) {
        this.setProperty(ACTION_KEY_PLACE_FIRST, value);
    }

    public boolean getPlaceLast() {
        return this.getProperty(ACTION_KEY_PLACE_LAST, false);
    }

    public void setPlaceLast(boolean value) {
        this.setProperty(ACTION_KEY_PLACE_LAST, value);
    }

    public String getPlaceAfter() {
        return (String)this.getProperty(ACTION_KEY_PLACE_AFTER);
    }

    public void setPlaceAfter(String placeAfter) {
        this.setProperty(ACTION_KEY_PLACE_AFTER, placeAfter);
    }

    public String getPlaceBefore() {
        return (String)this.getProperty(ACTION_KEY_PLACE_BEFORE);
    }

    public void setPlaceBefore(String placeBefore) {
        this.setProperty(ACTION_KEY_PLACE_BEFORE, placeBefore);
    }

    public boolean isPlaceAtContextTop() {
        return this.getProperty(ACTION_KEY_PLACE_CONTEXT_TOP, false);
    }

    public void setPlaceAtContextTop(boolean placeAtContextTop) {
        this.setProperty(ACTION_KEY_PLACE_CONTEXT_TOP, placeAtContextTop);
    }

    public void configure(ResourceBundle resourceBundle) {
        String[] resStrings;
        Boolean resBoolean;
        Icon resIcon;
        Guardian.assertNotNull((String)"resourceBundle", (Object)resourceBundle);
        String resString = this.getResourceString(resourceBundle, "text");
        if (resString != null && resString.length() > 0) {
            this.setText(resString);
        }
        if ((resString = this.getResourceString(resourceBundle, "popuptext")) != null && resString.length() > 0) {
            this.setPopupText(resString);
        }
        if ((resString = this.getResourceString(resourceBundle, "mnemonic")) != null && resString.length() > 0) {
            this.setMnemonic(resString.charAt(0));
        }
        if ((resString = this.getResourceString(resourceBundle, "accelerator")) != null && resString.length() > 0) {
            this.setAccelerator(KeyStroke.getKeyStroke(resString));
        }
        if ((resString = this.getResourceString(resourceBundle, "shortDescr")) != null) {
            this.setShortDescription(resString);
        }
        if ((resString = this.getResourceString(resourceBundle, "longDescr")) != null) {
            this.setLongDescription(resString);
        }
        if ((resIcon = this.getResourceIcon(resourceBundle, "smallIcon")) != null) {
            this.setSmallIcon(resIcon);
        }
        if ((resIcon = this.getResourceIcon(resourceBundle, "largeIcon")) != null) {
            this.setLargeIcon(resIcon);
        }
        if ((resBoolean = this.getResourceBoolean(resourceBundle, "separatorBefore")) != null) {
            this.setSeparatorBefore(resBoolean);
        }
        if ((resBoolean = this.getResourceBoolean(resourceBundle, "separatorAfter")) != null) {
            this.setSeparatorAfter(resBoolean);
        }
        if ((resString = this.getResourceString(resourceBundle, "placeBefore")) != null) {
            this.setProperty(ACTION_KEY_PLACE_BEFORE, resString);
        }
        if ((resString = this.getResourceString(resourceBundle, "placeAfter")) != null) {
            this.setProperty(ACTION_KEY_PLACE_AFTER, resString);
        }
        if ((resBoolean = this.getResourceBoolean(resourceBundle, "placeAtContextTop")) != null) {
            this.setPlaceAtContextTop(resBoolean);
        }
        if ((resString = this.getResourceString(resourceBundle, "parent")) != null) {
            this.setProperty(ACTION_KEY_PARENT, resString);
        }
        if ((resStrings = this.getResourceStrings(resourceBundle, "location")) != null) {
            this.setProperty(ACTION_KEY_LOCATION, resStrings);
        }
        if ((resStrings = this.getResourceStrings(resourceBundle, "context")) != null) {
            this.setProperty(ACTION_KEY_CONTEXT, resStrings);
        }
        resBoolean = this.getResourceBoolean(resourceBundle, "sortChildren");
        if (resString != null) {
            this.setProperty(ACTION_KEY_SORT_CHILDREN, resBoolean);
        }
        if ((resString = this.getResourceString(resourceBundle, "helpId")) != null) {
            this.setProperty(HELP_ID_KEY, resString);
        }
    }

    public void updateState() {
        this.updateState(new CommandEvent(this, null, null, null));
        this.fireUpdateState();
    }

    public abstract JMenuItem createMenuItem();

    public abstract AbstractButton createToolBarButton();

    protected abstract Action createAction();

    protected Object getProperty(String key) {
        return this.getAction().getValue(key);
    }

    protected void setProperty(String key, Object value) {
        this.getAction().putValue(key, value);
    }

    protected boolean containsProperty(String key, Object testValue) {
        if (testValue == null) {
            return false;
        }
        Object value = this.getProperty(key);
        if (value == null) {
            return false;
        }
        if (value instanceof String && testValue instanceof String) {
            return ((String)value).equalsIgnoreCase((String)testValue);
        }
        if (value instanceof String[] && testValue instanceof String) {
            return StringUtils.containsIgnoreCase((String[])((String[])value), (String)((String)testValue));
        }
        return value.equals(testValue);
    }

    protected String getProperty(String key, String defaultValue) {
        Object value = this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return (String)value;
    }

    protected String[] getProperty(String key, String[] defaultValues) {
        Object value = this.getProperty(key);
        if (value == null || !(value instanceof String[])) {
            return defaultValues;
        }
        return (String[])value;
    }

    protected boolean getProperty(String key, boolean defaultValue) {
        Object value = this.getProperty(key);
        if (value == null || !(value instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)value;
    }

    protected void setProperty(String key, boolean value) {
        this.setProperty(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    protected EventListenerList getEventListenerList() {
        return this.eventListenerList;
    }

    protected void addEventListener(Class t, EventListener l) {
        if (l != null) {
            if (this.eventListenerList == null) {
                this.eventListenerList = new EventListenerList();
            }
            this.eventListenerList.add(t, l);
        }
    }

    protected void removeEventListener(Class t, EventListener l) {
        if (l != null && this.eventListenerList != null) {
            this.eventListenerList.remove(t, l);
        }
    }

    protected void fireUpdateState() {
        if (this.getEventListenerList() == null) {
            return;
        }
        Object[] listeners = this.getEventListenerList().getListenerList();
        CommandEvent commandEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CommandListener.class && listeners[i] != CommandStateListener.class) continue;
            if (commandEvent == null) {
                commandEvent = new CommandEvent(this, null, null, null);
            }
            ((CommandStateListener)listeners[i + 1]).updateState(commandEvent);
        }
    }

    protected String createResourceKey(String commandPropertyName) {
        return String.format("command.%s.%s", this.getCommandID(), commandPropertyName);
    }

    protected String getResourceString(ResourceBundle resourceBundle, String commandPropertyName) {
        String key = this.createResourceKey(commandPropertyName);
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    protected String[] getResourceStrings(ResourceBundle resourceBundle, String commandPropertyName) {
        String value = this.getResourceString(resourceBundle, commandPropertyName);
        if (value == null) {
            return null;
        }
        return StringUtils.split((String)value, (char[])new char[]{','}, (boolean)true);
    }

    protected String[] getResourceStringArray(ResourceBundle resourceBundle, String commandPropertyName) {
        String key = this.createResourceKey(commandPropertyName);
        try {
            return resourceBundle.getStringArray(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    protected Boolean getResourceBoolean(ResourceBundle resourceBundle, String commandPropertyName) {
        String value = this.getResourceString(resourceBundle, commandPropertyName);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    protected Icon getResourceIcon(ResourceBundle resourceBundle, String commandPropertyName) {
        String value = this.getResourceString(resourceBundle, commandPropertyName);
        if (value != null) {
            try {
                return UIUtils.loadImageIcon(value);
            }
            catch (RuntimeException e) {
                String message = String.format("failed to load icon for resource entry '%s=%s'", this.createResourceKey(commandPropertyName), value);
                Debug.trace((String)message);
            }
        }
        return null;
    }

    protected boolean containsPropertyValue(String key, Object value) {
        if (value == null) {
            return false;
        }
        Object oldValue = this.getProperty(key);
        if (oldValue == null) {
            return false;
        }
        if (oldValue instanceof List) {
            List valueList = (List)oldValue;
            return valueList.contains(value);
        }
        return oldValue.equals(value);
    }

    public String toString() {
        return this.getCommandID();
    }

    public static CommandUIFactory getCommandUIFactory() {
        return commandUIFactory;
    }

    public static void setCommandUIFactory(CommandUIFactory commandUIFactory) {
        Guardian.assertNotNull((String)"commandUIFactory", (Object)commandUIFactory);
        Command.commandUIFactory = commandUIFactory;
    }

    public void updateComponentTreeUI() {
    }

    public void updateState(CommandEvent event) {
    }

    public void configure(ConfigurationElement config) throws CoreException {
        String[] resStrings;
        Boolean resBoolean;
        Icon resIcon;
        String resString = this.getValue(config, "id", null);
        if (resString != null) {
            this.setCommandID(resString);
        }
        if ((resString = this.getConfigString(config, "text")) != null && resString.length() > 0) {
            this.setText(resString);
        }
        if ((resString = this.getConfigString(config, "popuptext")) != null && resString.length() > 0) {
            this.setPopupText(resString);
        }
        if ((resString = this.getConfigString(config, "mnemonic")) != null && resString.length() > 0) {
            this.setMnemonic(resString.charAt(0));
        }
        if ((resString = this.getConfigString(config, "accelerator")) != null && resString.length() > 0) {
            this.setAccelerator(KeyStroke.getKeyStroke(resString));
        }
        if ((resString = this.getConfigString(config, "shortDescr")) != null) {
            this.setShortDescription(resString);
        }
        if ((resString = this.getConfigString(config, "longDescr")) != null) {
            this.setLongDescription(resString);
        }
        if ((resIcon = this.getConfigIcon(config, "smallIcon")) != null) {
            this.setSmallIcon(resIcon);
        }
        if ((resIcon = this.getConfigIcon(config, "largeIcon")) != null) {
            this.setLargeIcon(resIcon);
        }
        if ((resBoolean = this.getConfigBoolean(config, "separatorBefore")) != null) {
            this.setSeparatorBefore(resBoolean);
        }
        if ((resBoolean = this.getConfigBoolean(config, "separatorAfter")) != null) {
            this.setSeparatorAfter(resBoolean);
        }
        if ((resBoolean = this.getConfigBoolean(config, "placeFirst")) != null) {
            this.setProperty(ACTION_KEY_PLACE_FIRST, resBoolean);
        }
        if ((resBoolean = this.getConfigBoolean(config, "placeLast")) != null) {
            this.setProperty(ACTION_KEY_PLACE_LAST, resBoolean);
        }
        if ((resString = this.getConfigString(config, "placeBefore")) != null) {
            this.setProperty(ACTION_KEY_PLACE_BEFORE, resString);
        }
        if ((resString = this.getConfigString(config, "placeAfter")) != null) {
            this.setProperty(ACTION_KEY_PLACE_AFTER, resString);
        }
        if ((resBoolean = this.getConfigBoolean(config, "placeAtContextTop")) != null) {
            this.setPlaceAtContextTop(resBoolean);
        }
        if ((resString = this.getConfigString(config, "parent")) != null) {
            this.setProperty(ACTION_KEY_PARENT, resString);
        }
        if ((resStrings = this.getConfigStrings(config, "location")) != null) {
            this.setProperty(ACTION_KEY_LOCATION, resStrings);
        }
        if ((resStrings = this.getConfigStrings(config, "context")) != null) {
            this.setProperty(ACTION_KEY_CONTEXT, resStrings);
        }
        if ((resBoolean = this.getConfigBoolean(config, "sortChildren")) != null) {
            this.setProperty(ACTION_KEY_SORT_CHILDREN, resBoolean);
        }
        if ((resString = this.getConfigString(config, "helpId")) != null) {
            this.setProperty(HELP_ID_KEY, resString);
        }
    }

    protected String getValue(ConfigurationElement config, String elementName, String defaultValue) {
        String value = null;
        ConfigurationElement child = (ConfigurationElement)config.getChild(elementName);
        if (child != null) {
            value = child.getValue();
        }
        return value != null ? value : defaultValue;
    }

    protected String getConfigString(ConfigurationElement config, String elementName) {
        String value = null;
        ConfigurationElement child = (ConfigurationElement)config.getChild(elementName);
        if (child != null) {
            value = child.getValue();
        }
        return value;
    }

    protected String[] getConfigStrings(ConfigurationElement config, String elementName) {
        String value = this.getConfigString(config, elementName);
        if (value == null) {
            return null;
        }
        return StringUtils.split((String)value, (char[])new char[]{','}, (boolean)true);
    }

    protected Boolean getConfigBoolean(ConfigurationElement config, String elementName) {
        String value = this.getConfigString(config, elementName);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    protected Icon getConfigIcon(ConfigurationElement config, String elementName) {
        String value = this.getConfigString(config, elementName);
        if (value != null) {
            try {
                return UIUtils.loadImageIcon(value, this.getClass());
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

