/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.command;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.runtime.ConfigurationElement;
import com.bc.ceres.core.runtime.Module;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.esa.beam.framework.ui.command.Command;
import org.esa.beam.framework.ui.command.CommandStateListener;

public class CommandGroup
extends Command {
    public static final String ACTION_KEY_GROUP_ITEMS = "_groupItems";
    private static final String ELEMENT_NAME_ITEMS = "items";
    private static final String ELEMENT_NAME_ACTION_ID = "action";
    private static final String ELEMENT_NAME_ACTION_GROUP_ID = "actionGroup";
    private static final String ELEMENT_NAME_SEPARATOR = "separator";

    public CommandGroup() {
        super(CommandGroup.class.getName());
    }

    public CommandGroup(String commandGroupID, CommandStateListener listener) {
        super(commandGroupID);
        this.addCommandStateListener(listener);
    }

    @Override
    public JMenuItem createMenuItem() {
        return CommandGroup.getCommandUIFactory().createMenuItem(this);
    }

    @Override
    public AbstractButton createToolBarButton() {
        return CommandGroup.getCommandUIFactory().createToolBarButton(this);
    }

    public void addCommandStateListener(CommandStateListener l) {
        this.addEventListener(CommandStateListener.class, l);
    }

    public void removeCommandStateListener(CommandStateListener l) {
        this.removeEventListener(CommandStateListener.class, l);
    }

    public String[] getGroupItems() {
        return this.getProperty(ACTION_KEY_GROUP_ITEMS, new String[0]);
    }

    public void setGroupItems(String[] groupItems) {
        this.setProperty(ACTION_KEY_GROUP_ITEMS, groupItems.clone());
    }

    @Override
    public void configure(ConfigurationElement config) throws CoreException {
        super.configure(config);
        ConfigurationElement itemsElement = (ConfigurationElement)config.getChild(ELEMENT_NAME_ITEMS);
        if (itemsElement == null) {
            return;
        }
        ConfigurationElement[] children = (ConfigurationElement[])itemsElement.getChildren();
        String[] groupItems = new String[children.length];
        block9: for (int i = 0; i < children.length; ++i) {
            String childName;
            ConfigurationElement child = children[i];
            switch (childName = child.getName()) {
                case "action": 
                case "actionGroup": {
                    groupItems[i] = child.getValue().trim();
                    continue block9;
                }
                case "separator": {
                    groupItems[i] = null;
                    continue block9;
                }
                default: {
                    Module declaringModule = config.getDeclaringExtension().getDeclaringModule();
                    throw new CoreException(String.format("Module [%s]: '%s' is an unknown 'groupItems' element", declaringModule.getName(), childName));
                }
            }
        }
        this.setProperty(ACTION_KEY_GROUP_ITEMS, groupItems);
    }

    @Override
    protected Action createAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
    }
}

