/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.command;

import com.bc.ceres.swing.figure.Interactor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.beam.framework.ui.command.Command;
import org.esa.beam.framework.ui.command.CommandGroup;
import org.esa.beam.framework.ui.command.CommandListener;
import org.esa.beam.framework.ui.command.CommandManager;
import org.esa.beam.framework.ui.command.CommandStateListener;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.esa.beam.framework.ui.command.ToolCommand;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;

public class DefaultCommandManager
implements CommandManager {
    private final Map<String, Command> commandMap = new HashMap<String, Command>();
    private final List<Command> commandList = new ArrayList<Command>();

    @Override
    public ExecCommand createExecCommand(String commandID, CommandListener listener) {
        Guardian.assertNotNullOrEmpty((String)"commandID", (String)commandID);
        ExecCommand command = new ExecCommand(commandID, listener);
        this.addCommand(command);
        return command;
    }

    @Override
    public ToolCommand createToolCommand(String commandID, CommandStateListener listener, Interactor tool) {
        Guardian.assertNotNullOrEmpty((String)"commandID", (String)commandID);
        Guardian.assertNotNull((String)"tool", (Object)tool);
        ToolCommand command = new ToolCommand(commandID, listener, tool);
        this.addCommand(command);
        return command;
    }

    @Override
    public CommandGroup createCommandGroup(String commandGroupID, CommandStateListener listener) {
        Guardian.assertNotNullOrEmpty((String)"commandGroupID", (String)commandGroupID);
        CommandGroup commandGroup = new CommandGroup(commandGroupID, listener);
        this.addCommand(commandGroup);
        return commandGroup;
    }

    @Override
    public int getNumCommands() {
        return this.commandList.size();
    }

    @Override
    public Command getCommandAt(int index) {
        return this.commandList.get(index);
    }

    @Override
    public Command getCommand(String commandID) {
        return this.commandMap.get(commandID);
    }

    @Override
    public ExecCommand getExecCommand(String commandID) {
        Command command = this.getCommand(commandID);
        if (command instanceof ExecCommand) {
            return (ExecCommand)command;
        }
        return null;
    }

    @Override
    public ToolCommand getToolCommand(String commandID) {
        Command command = this.getCommand(commandID);
        if (command instanceof ToolCommand) {
            return (ToolCommand)command;
        }
        return null;
    }

    @Override
    public CommandGroup getCommandGroup(String commandID) {
        Command command = this.getCommand(commandID);
        if (command instanceof CommandGroup) {
            return (CommandGroup)command;
        }
        return null;
    }

    @Override
    public void updateState() {
        int n = this.getNumCommands();
        for (int i = 0; i < n; ++i) {
            this.getCommandAt(i).updateState();
        }
    }

    @Override
    public void updateComponentTreeUI() {
        int n = this.getNumCommands();
        for (int i = 0; i < n; ++i) {
            this.getCommandAt(i).updateComponentTreeUI();
        }
    }

    @Override
    public void addCommand(Command command) {
        if (this.commandMap.containsKey(command.getCommandID())) {
            throw new IllegalArgumentException("a command named '" + command.getCommandID() + "' is already registered");
        }
        this.commandMap.put(command.getCommandID(), command);
        this.commandList.add(command);
        Debug.trace((String)("DefaultCommandManager: added command '" + command + "'"));
    }

    @Override
    public void removeCommand(Command command) {
        String commandKey = command.getCommandID();
        this.commandMap.remove(commandKey);
        this.commandList.remove(command);
    }
}

