/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.command;

import com.bc.ceres.core.Assert;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.esa.beam.framework.ui.command.Command;
import org.esa.beam.framework.ui.command.CommandManager;
import org.esa.beam.framework.ui.command.CommandMenuInserter;
import org.esa.beam.util.logging.BeamLogManager;

public class DefaultCommandMenuInserter
implements CommandMenuInserter {
    private static final Comparator<Command> NAME_COMPARATOR = new CommandNameComparator();
    private final CommandManager commandManager;

    public DefaultCommandMenuInserter(CommandManager commandManager) {
        this.commandManager = commandManager;
    }

    @Override
    public void insertCommandIntoMenu(Command newCommand, JMenu menu) {
        DefaultCommandMenuInserter.insertCommandIntoMenu(newCommand, menu, this.commandManager);
    }

    private static void insertCommandIntoMenu(Command newCommand, JMenu menu, CommandManager commandManager) {
        JMenuItem newMenuItem = newCommand.createMenuItem();
        if (newMenuItem == null) {
            return;
        }
        HashMap<String, Command> commandMap = new HashMap<String, Command>();
        HashMap<String, JMenuItem> menuItemMap = new HashMap<String, JMenuItem>();
        commandMap.put(newCommand.getCommandID(), newCommand);
        menuItemMap.put(newCommand.getCommandID(), newMenuItem);
        JPopupMenu popupMenu = menu.getPopupMenu();
        int componentCount = popupMenu.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Command command;
            String commandID;
            Component component = popupMenu.getComponent(i);
            if (!(component instanceof JMenuItem) || (commandID = component.getName()) == null || (command = commandManager.getCommand(commandID)) == null) continue;
            commandMap.put(commandID, command);
            menuItemMap.put(commandID, (JMenuItem)component);
        }
        BeamLogManager.getSystemLogger().fine(String.format("Inserting command '%s' into menu '%s' with %d item(s)", newCommand.getCommandID(), menu.getName(), componentCount));
        ArrayList<Command> commands = new ArrayList<Command>(commandMap.values());
        if (DefaultCommandMenuInserter.isSortedByName(menu, commandManager)) {
            DefaultCommandMenuInserter.sortCommandsByName(commands);
        } else {
            DefaultCommandMenuInserter.sortCommandsByAnchor(commands);
        }
        DefaultCommandMenuInserter.repopulatePopMenu(popupMenu, commands, menuItemMap);
    }

    private static void repopulatePopMenu(JPopupMenu popupMenu, ArrayList<Command> commands, Map<String, JMenuItem> menuItemMap) {
        popupMenu.removeAll();
        for (int i = 0; i < commands.size(); ++i) {
            Command command = commands.get(i);
            JMenuItem menuItem = menuItemMap.get(command.getCommandID());
            Assert.state((menuItem != null ? 1 : 0) != 0);
            int componentCount = popupMenu.getComponentCount();
            if (command.isSeparatorBefore() && componentCount > 0 && !(popupMenu.getComponent(componentCount - 1) instanceof JSeparator)) {
                popupMenu.addSeparator();
            }
            popupMenu.add(menuItem);
            if (!command.isSeparatorAfter() || i >= commands.size() - 1) continue;
            popupMenu.addSeparator();
        }
    }

    private static boolean isSortedByName(JMenu menu, CommandManager commandManager) {
        Command commandGroup = DefaultCommandMenuInserter.getCommandForMenu(menu, commandManager);
        return commandGroup != null && commandGroup.getSortChildren();
    }

    private static Command getCommandForMenu(JMenu menu, CommandManager manager) {
        String name = menu.getName();
        return name != null ? manager.getCommand(name) : null;
    }

    static void sortCommandsByName(List<Command> commands) {
        Collections.sort(commands, NAME_COMPARATOR);
    }

    static void sortCommandsByAnchor(List<Command> commands) {
        int iteration;
        ArrayList<Command> firstCommands = new ArrayList<Command>(commands.size());
        ArrayList<Command> lastCommands = new ArrayList<Command>(commands.size());
        ArrayList<Command> betweenCommands = new ArrayList<Command>(commands);
        for (Command command : commands) {
            if (command.getPlaceFirst()) {
                firstCommands.add(command);
                betweenCommands.remove(command);
                continue;
            }
            if (!command.getPlaceLast() && (command.getPlaceBefore() != null || command.getPlaceAfter() != null)) continue;
            lastCommands.add(command);
            betweenCommands.remove(command);
        }
        Assert.state((firstCommands.size() + lastCommands.size() + betweenCommands.size() == commands.size() ? 1 : 0) != 0);
        Collections.sort(firstCommands, NAME_COMPARATOR);
        Collections.sort(betweenCommands, NAME_COMPARATOR);
        Collections.sort(lastCommands, NAME_COMPARATOR);
        HashMap<String, Command> commandMap = new HashMap<String, Command>(betweenCommands.size() * 2 + 1);
        for (Command command : commands) {
            commandMap.put(command.getCommandID(), command);
        }
        LinkedList<Command> linkedList = new LinkedList<Command>();
        linkedList.addAll(firstCommands);
        linkedList.addAll(betweenCommands);
        linkedList.addAll(lastCommands);
        boolean change = true;
        for (iteration = 0; change && iteration < commands.size(); ++iteration) {
            change = false;
            for (Command command : commands) {
                String placeAfter;
                String placeBefore = command.getPlaceBefore();
                if (placeBefore != null) {
                    int index = linkedList.indexOf(command);
                    Assert.state((index >= 0 ? 1 : 0) != 0);
                    Command subsequentCommand = (Command)commandMap.get(placeBefore);
                    if (subsequentCommand != null) {
                        int subsequentIndex = linkedList.indexOf(subsequentCommand);
                        Assert.state((subsequentIndex >= 0 ? 1 : 0) != 0);
                        if (subsequentIndex < index) {
                            linkedList.remove(command);
                            linkedList.add(subsequentIndex, command);
                            change = true;
                        }
                    }
                }
                if ((placeAfter = command.getPlaceAfter()) == null) continue;
                int index = linkedList.indexOf(command);
                Assert.state((index >= 0 ? 1 : 0) != 0);
                Command precedingCommand = (Command)commandMap.get(placeAfter);
                if (precedingCommand == null) continue;
                int precedingIndex = linkedList.indexOf(precedingCommand);
                Assert.state((precedingIndex >= 0 ? 1 : 0) != 0);
                if (precedingIndex <= index) continue;
                linkedList.add(precedingIndex + 1, command);
                linkedList.remove(index);
                change = true;
            }
        }
        if (iteration > 1 && iteration == commands.size()) {
            BeamLogManager.getSystemLogger().warning(String.format("Sorting updated command list took %d iterations!", iteration));
        }
        commands.clear();
        commands.addAll(linkedList);
    }

    private static class CommandNameComparator
    implements Comparator<Command> {
        private CommandNameComparator() {
        }

        @Override
        public int compare(Command command1, Command command2) {
            if (command1.getText() == null || command2.getText() == null) {
                return command1.getCommandID().compareTo(command2.getCommandID());
            }
            return command1.getText().compareTo(command2.getText());
        }
    }
}

