/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.command;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import org.esa.beam.framework.help.HelpSys;
import org.esa.beam.framework.ui.command.Command;
import org.esa.beam.framework.ui.command.CommandGroup;
import org.esa.beam.framework.ui.command.CommandManager;
import org.esa.beam.framework.ui.command.CommandUIFactory;
import org.esa.beam.framework.ui.command.ExecCommand;
import org.esa.beam.framework.ui.command.SelectableCommand;
import org.esa.beam.framework.ui.command.ToolCommand;
import org.esa.beam.framework.ui.tool.ToolButtonFactory;
import org.esa.beam.util.Guardian;

public class DefaultCommandUIFactory
implements CommandUIFactory {
    private CommandManager _commandManager;
    private boolean _showingDisabledMenuItems = true;

    @Override
    public CommandManager getCommandManager() {
        return this._commandManager;
    }

    @Override
    public void setCommandManager(CommandManager commandManager) {
        this._commandManager = commandManager;
    }

    @Override
    public boolean isShowingDisabledMenuItems() {
        return this._showingDisabledMenuItems;
    }

    @Override
    public void setShowingDisabledMenuItems(boolean showingDisabledMenuItems) {
        this._showingDisabledMenuItems = showingDisabledMenuItems;
    }

    @Override
    public JMenuItem createMenuItem(ExecCommand command) {
        JMenuItem menuItem;
        if (command.isToggle()) {
            JCheckBoxMenuItem checkBoxMenuItem = new JCheckBoxMenuItem(command.getAction());
            this.installMutualExclusiveInterest(checkBoxMenuItem, command);
            menuItem = checkBoxMenuItem;
        } else {
            menuItem = new JMenuItem(command.getAction());
        }
        menuItem.setName(command.getCommandID());
        KeyStroke keyStroke = command.getAccelerator();
        if (keyStroke != null) {
            menuItem.setAccelerator(keyStroke);
        }
        if (menuItem.getText() == null) {
            menuItem.setText(command.getCommandID());
        }
        this.enableHelp(menuItem, command);
        return menuItem;
    }

    @Override
    public JMenuItem createMenuItem(ToolCommand command) {
        return null;
    }

    @Override
    public JMenuItem createMenuItem(CommandGroup commandGroup) {
        JMenu menu = new JMenu(commandGroup.getAction());
        menu.setName(commandGroup.getCommandID());
        if (menu.getText() == null) {
            menu.setText(commandGroup.getCommandID());
        }
        this.enableHelp(menu, commandGroup);
        return menu;
    }

    @Override
    public AbstractButton createToolBarButton(ExecCommand command) {
        AbstractButton button = ToolButtonFactory.createButton(command.getAction(), command.isToggle());
        button.setName(command.getCommandID());
        button.setSelected(command.isSelected());
        this.installMutualExclusiveInterest(button, command);
        return button;
    }

    @Override
    public AbstractButton createToolBarButton(ToolCommand command) {
        AbstractButton button = ToolButtonFactory.createButton(command.getAction(), true);
        button.setName(command.getCommandID());
        button.setSelected(command.isSelected());
        this.installMutualExclusiveInterest(button, command);
        return button;
    }

    @Override
    public AbstractButton createToolBarButton(CommandGroup commandGroup) {
        AbstractButton button = ToolButtonFactory.createButton(commandGroup.getAction(), false);
        button.setName(commandGroup.getCommandID());
        return button;
    }

    @Override
    public JPopupMenu addContextDependentMenuItems(String context, JPopupMenu popup) {
        String commandID;
        Guardian.assertNotNullOrEmpty((String)"context", (String)context);
        Guardian.assertNotNull((String)"popup", (Object)popup);
        if (this._commandManager == null) {
            return popup;
        }
        ArrayList<String> existingCommands = new ArrayList<String>();
        Component[] components = popup.getComponents();
        for (int i = 0; i < components.length; ++i) {
            JMenuItem jMenuItem;
            Component component = components[i];
            if (!(component instanceof JMenuItem) || existingCommands.contains(commandID = (jMenuItem = (JMenuItem)component).getName())) continue;
            existingCommands.add(commandID);
        }
        int numCommands = this._commandManager.getNumCommands();
        for (int i = 0; i < numCommands; ++i) {
            Command command = this._commandManager.getCommandAt(i);
            commandID = command.getCommandID();
            if (!command.containsContext(context) || !command.isEnabled() && !this._showingDisabledMenuItems || existingCommands.contains(commandID)) continue;
            existingCommands.add(commandID);
            JMenuItem item = command.createMenuItem();
            String popupText = command.getPopupText();
            if (popupText != null && popupText.length() > 0) {
                item.setText(popupText);
            }
            if (item == null) continue;
            if (command.isPlaceAtContextTop()) {
                popup.insert(item, 0);
                if (!command.isSeparatorAfter()) continue;
                popup.insert(new JPopupMenu.Separator(), 1);
                continue;
            }
            popup.add(item);
        }
        return popup;
    }

    private void enableHelp(Component menu, Command command) {
        HelpSys.enableHelp(menu, command.getHelpId());
    }

    private void installMutualExclusiveInterest(AbstractButton button, SelectableCommand command) {
        MutualExclusiveInterestHandler selectionChangeListener = new MutualExclusiveInterestHandler(button, command);
        command.getAction().addPropertyChangeListener(selectionChangeListener);
        button.addActionListener(selectionChangeListener);
        button.setSelected(command.isSelected());
    }

    private static class MutualExclusiveInterestHandler
    implements ActionListener,
    PropertyChangeListener {
        private final AbstractButton _button;
        private final SelectableCommand _command;

        public MutualExclusiveInterestHandler(AbstractButton button, SelectableCommand command) {
            this._button = button;
            this._command = command;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this._command.setSelected(this._button.isSelected());
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("_selected")) {
                this._button.setSelected((Boolean)event.getNewValue());
            }
        }
    }
}

