/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.command;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.runtime.ConfigurableExtension;
import com.bc.ceres.core.runtime.ConfigurationElement;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import org.esa.beam.framework.ui.command.CommandEvent;
import org.esa.beam.framework.ui.command.CommandListener;
import org.esa.beam.framework.ui.command.SelectableCommand;

public class ExecCommand
extends SelectableCommand
implements ConfigurableExtension {
    public static final String TOGGLE_ACTION_KEY = "_toggle";

    public ExecCommand() {
    }

    public ExecCommand(String commandID) {
        super(commandID);
    }

    public ExecCommand(String commandID, CommandListener listener) {
        super(commandID);
        this.addCommandListener(listener);
    }

    public boolean isToggle() {
        return this.getProperty(TOGGLE_ACTION_KEY, false);
    }

    public void setToggle(boolean toggle) {
        this.setProperty(TOGGLE_ACTION_KEY, toggle);
    }

    public void execute() {
        this.execute(null);
    }

    public void execute(Object argument) {
        this.fireActionPerformed(null, argument);
    }

    @Override
    public JMenuItem createMenuItem() {
        return ExecCommand.getCommandUIFactory().createMenuItem(this);
    }

    @Override
    public AbstractButton createToolBarButton() {
        return ExecCommand.getCommandUIFactory().createToolBarButton(this);
    }

    @Override
    public void addCommandListener(CommandListener l) {
        this.addEventListener(CommandListener.class, l);
    }

    @Override
    public void removeCommandListener(CommandListener l) {
        this.removeEventListener(CommandListener.class, l);
    }

    @Override
    protected void fireActionPerformed(ActionEvent actionEvent, Object argument) {
        this.actionPerformed(new CommandEvent(this, actionEvent, null, argument));
        if (this.getEventListenerList() == null) {
            return;
        }
        Object[] listeners = this.getEventListenerList().getListenerList();
        CommandEvent commandEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CommandListener.class) continue;
            if (commandEvent == null) {
                commandEvent = new CommandEvent(this, actionEvent, null, argument);
            }
            ((CommandListener)listeners[i + 1]).actionPerformed(commandEvent);
        }
    }

    @Override
    public void configure(ResourceBundle resourceBundle) {
        super.configure(resourceBundle);
        Boolean resBoolean = this.getResourceBoolean(resourceBundle, "toggle");
        if (resBoolean != null) {
            this.setToggle(resBoolean);
        }
    }

    @Override
    public void configure(ConfigurationElement config) throws CoreException {
        super.configure(config);
        Boolean confBoolean = this.getConfigBoolean(config, "toggle");
        if (confBoolean != null) {
            this.setToggle(confBoolean);
        }
    }
}

