/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.command;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.runtime.ConfigurationElement;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.esa.beam.framework.ui.command.Command;
import org.esa.beam.framework.ui.command.CommandEvent;
import org.esa.beam.framework.ui.command.CommandListener;

public abstract class SelectableCommand
extends Command {
    public static final String SELECTED_ACTION_KEY = "_selected";

    public SelectableCommand() {
    }

    public SelectableCommand(String commandID) {
        super(commandID);
    }

    public SelectableCommand(String commandID, CommandListener listener) {
        super(commandID);
        this.addCommandListener(listener);
    }

    public boolean isSelected() {
        return this.getProperty(SELECTED_ACTION_KEY, false);
    }

    public void setSelected(boolean selected) {
        this.setProperty(SELECTED_ACTION_KEY, selected);
    }

    public void addCommandListener(CommandListener l) {
        this.addEventListener(CommandListener.class, l);
    }

    public void removeCommandListener(CommandListener l) {
        this.removeEventListener(CommandListener.class, l);
    }

    protected void fireActionPerformed(ActionEvent actionEvent, Object argument) {
        this.actionPerformed(new CommandEvent(this, actionEvent, null, argument));
        if (this.getEventListenerList() == null) {
            return;
        }
        Object[] listeners = this.getEventListenerList().getListenerList();
        CommandEvent commandEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CommandListener.class) continue;
            if (commandEvent == null) {
                commandEvent = new CommandEvent(this, actionEvent, null, argument);
            }
            ((CommandListener)listeners[i + 1]).actionPerformed(commandEvent);
        }
    }

    @Override
    public void configure(ResourceBundle resourceBundle) {
        super.configure(resourceBundle);
        Boolean resBoolean = this.getResourceBoolean(resourceBundle, "selected");
        if (resBoolean != null) {
            this.setSelected(resBoolean);
        }
    }

    @Override
    public void configure(ConfigurationElement config) throws CoreException {
        super.configure(config);
        Boolean resBoolean = this.getConfigBoolean(config, "selected");
        if (resBoolean != null) {
            this.setSelected(resBoolean);
        }
    }

    public void actionPerformed(CommandEvent event) {
    }

    @Override
    protected Action createAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectableCommand.this.fireActionPerformed(actionEvent, null);
            }
        };
    }
}

