/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.command;

import com.bc.ceres.swing.figure.AbstractInteractorListener;
import com.bc.ceres.swing.figure.Interactor;
import com.bc.ceres.swing.figure.InteractorListener;
import com.bc.ceres.swing.figure.interactions.NullInteractor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.esa.beam.framework.ui.command.CommandStateListener;
import org.esa.beam.framework.ui.command.SelectableCommand;
import org.esa.beam.util.Guardian;

public class ToolCommand
extends SelectableCommand {
    private Interactor interactor = NullInteractor.INSTANCE;
    private final InteractorListener toolListener = new InternalInteractorListener();

    public ToolCommand(String commandID) {
        super(commandID);
    }

    public ToolCommand(String commandID, CommandStateListener listener, Interactor interactor) {
        this(commandID);
        this.setInteractor(interactor);
        this.addCommandStateListener(listener);
    }

    public Interactor getInteractor() {
        return this.interactor;
    }

    public final void setInteractor(Interactor interactor) {
        Guardian.assertNotNull((String)"interactor", (Object)interactor);
        Interactor oldTool = this.interactor;
        if (interactor == oldTool) {
            return;
        }
        if (oldTool != null) {
            oldTool.removeListener(this.toolListener);
        }
        this.interactor = interactor;
        this.interactor.addListener(this.toolListener);
    }

    public void addCommandStateListener(CommandStateListener l) {
        this.addEventListener(CommandStateListener.class, l);
    }

    public void removeCommandStateListener(CommandStateListener l) {
        this.removeEventListener(CommandStateListener.class, l);
    }

    @Override
    public JMenuItem createMenuItem() {
        return ToolCommand.getCommandUIFactory().createMenuItem(this);
    }

    @Override
    public AbstractButton createToolBarButton() {
        return ToolCommand.getCommandUIFactory().createToolBarButton(this);
    }

    @Override
    protected Action createAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ToolCommand.this.fireActionPerformed(actionEvent, null);
            }
        };
    }

    private class InternalInteractorListener
    extends AbstractInteractorListener {
        private InternalInteractorListener() {
        }

        public void interactorActivated(Interactor interactor) {
            ToolCommand.this.setSelected(true);
        }

        public void interactorDeactivated(Interactor interactor) {
            ToolCommand.this.setSelected(false);
        }
    }
}

