/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.config;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.esa.beam.framework.param.ParamExceptionHandler;
import org.esa.beam.framework.ui.ModalDialog;
import org.esa.beam.framework.ui.config.ConfigPage;
import org.esa.beam.util.PropertyMap;

public class ConfigDialog
extends ModalDialog {
    private static final String _DEFAULT_TITLE_BASE = "Configuration";
    private String _titleBase;
    private JTree _tree;
    private DefaultMutableTreeNode _rootNode;
    private DefaultTreeModel _treeModel;
    private JPanel _pagePane;
    private CardLayout _pagePaneLM;
    private ConfigPage _currentPage;

    public ConfigDialog() {
        this(null, null);
    }

    public ConfigDialog(Window owner, String helpID) {
        super(owner, _DEFAULT_TITLE_BASE, 0x21 | (helpID != null ? 128 : 0), helpID);
        this.createUI();
    }

    public PropertyMap getConfigParamValues(PropertyMap propertyMap) {
        for (int i = 0; i < this.getNumRootPages(); ++i) {
            ConfigPage page = this.getRootPageAt(i);
            propertyMap = this.getConfigParamValues(page, propertyMap);
        }
        return propertyMap;
    }

    public void setConfigParamValues(PropertyMap propertyMap, ParamExceptionHandler errorHandler) {
        for (int i = 0; i < this.getNumRootPages(); ++i) {
            ConfigPage page = this.getRootPageAt(i);
            this.setConfigParamValues(page, propertyMap, errorHandler);
        }
    }

    public void expandAllPages() {
        TreeModel model = this._tree.getModel();
        Object root = model.getRoot();
        TreePath treePath = new TreePath(root);
        this._tree.expandPath(treePath);
        int rowCount = this._tree.getRowCount();
        for (int i = rowCount - 1; i >= 0; --i) {
            this._tree.expandRow(i);
        }
    }

    public String getTitleBase() {
        return this._titleBase;
    }

    public void setTitleBase(String titleBase) {
        this._titleBase = titleBase;
    }

    public int getNumRootPages() {
        return this._rootNode.getChildCount();
    }

    public ConfigPage getRootPageAt(int index) {
        return this.valueToPage(this._rootNode.getChildAt(index));
    }

    public void addRootPage(ConfigPage page) {
        DefaultMutableTreeNode node = this.createNode(page);
        this._rootNode.add(node);
        this._treeModel.reload();
        if (this.getNumRootPages() == 1) {
            this.setCurrentPage(page);
        }
    }

    public void removeRootPage(ConfigPage page) {
        for (int i = 0; i < this.getNumRootPages(); ++i) {
            ConfigPage pageOld = this.getRootPageAt(i);
            if (pageOld != page) continue;
            this.removeRootPageAt(i);
            return;
        }
    }

    public void removeRootPageAt(int index) {
        this._rootNode.remove(index);
        if (this.getNumRootPages() > 0) {
            this.setCurrentPage(this.getRootPageAt(0));
        } else {
            this.setCurrentPage(null);
        }
    }

    public ConfigPage getCurrentPage() {
        return this._currentPage;
    }

    public void setCurrentPage(ConfigPage currentPage) {
        if (this._currentPage == currentPage || !this.verifyUserInput()) {
            return;
        }
        this._currentPage = currentPage;
        this.updatePageTitle();
        this.updatePagePane();
    }

    @Override
    protected void onOK() {
        for (int i = 0; i < this.getNumRootPages(); ++i) {
            ConfigPage page = this.getRootPageAt(i);
            this.onOK(page);
        }
        super.onOK();
    }

    @Override
    public int show() {
        for (int i = 0; i < this.getNumRootPages(); ++i) {
            ConfigPage page = this.getRootPageAt(i);
            this.updatePageUI(page);
        }
        return super.show();
    }

    @Override
    protected boolean verifyUserInput() {
        if (this._currentPage != null) {
            return this._currentPage.verifyUserInput();
        }
        return true;
    }

    private DefaultMutableTreeNode createNode(ConfigPage page) {
        this.installPageUIComponent(page);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(page);
        ConfigPage[] subPages = page.getSubPages();
        if (subPages != null) {
            for (int i = 0; i < subPages.length; ++i) {
                node.add(this.createNode(subPages[i]));
            }
        }
        return node;
    }

    private void installPageUIComponent(ConfigPage page) {
        Component component = page.getPageUI();
        if (component == null) {
            throw new IllegalArgumentException("page without UI component added");
        }
        this._pagePane.add(component, page.getKey());
    }

    private void registerTreeCellRenderer() {
        this._tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                ConfigPage page = ConfigDialog.this.valueToPage(value);
                if (page != null) {
                    this.setText(page.getTitle());
                    this.setIcon(page.getIcon());
                    this.setToolTipText(page.getTitle());
                }
                return this;
            }
        });
    }

    private void registerTreeSelectionListener() {
        this._tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ConfigPage page = ConfigDialog.this.valueToPage(ConfigDialog.this._tree.getLastSelectedPathComponent());
                if (page != null) {
                    ConfigDialog.this.setCurrentPage(page);
                }
            }
        });
    }

    private ConfigPage valueToPage(Object value) {
        return this.nodeToPage(this.valueToNode(value));
    }

    private DefaultMutableTreeNode valueToNode(Object value) {
        if (value instanceof DefaultMutableTreeNode) {
            return (DefaultMutableTreeNode)value;
        }
        return null;
    }

    private ConfigPage nodeToPage(DefaultMutableTreeNode node) {
        if (node != null && node.getUserObject() instanceof ConfigPage) {
            return (ConfigPage)node.getUserObject();
        }
        return null;
    }

    private void createUI() {
        this._titleBase = _DEFAULT_TITLE_BASE;
        this._rootNode = new DefaultMutableTreeNode(this._titleBase);
        this._treeModel = new DefaultTreeModel(this._rootNode);
        this._tree = new JTree(this._treeModel);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.setEditable(false);
        this._tree.putClientProperty("JTree.lineStyle", "Angled");
        this._tree.getSelectionModel().setSelectionMode(1);
        this.registerTreeCellRenderer();
        this.registerTreeSelectionListener();
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        JScrollPane treeScrollPane = new JScrollPane(this._tree);
        treeScrollPane.setHorizontalScrollBarPolicy(30);
        treeScrollPane.setVerticalScrollBarPolicy(20);
        treeScrollPane.setPreferredSize(new Dimension(180, 280));
        this._pagePaneLM = new CardLayout();
        this._pagePane = new JPanel(this._pagePaneLM);
        JPanel content = new JPanel(new BorderLayout(3, 3));
        content.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        content.add((Component)treeScrollPane, "West");
        content.add(this._pagePane);
        this.setContent(content);
    }

    private void updatePageTitle() {
        String title = this.getTitleBase();
        if (this._currentPage != null) {
            title = title.concat(" - ".concat(this._currentPage.getTitle()));
        }
        this.getJDialog().setTitle(title);
    }

    private void updatePagePane() {
        if (this._currentPage != null) {
            this._pagePaneLM.show(this._pagePane, this._currentPage.getKey());
        }
    }

    private PropertyMap getConfigParamValues(ConfigPage page, PropertyMap propertyMap) {
        propertyMap = page.getConfigParamValues(propertyMap);
        ConfigPage[] subPages = page.getSubPages();
        if (subPages != null) {
            for (int i = 0; i < subPages.length; ++i) {
                ConfigPage subPage = subPages[i];
                propertyMap = this.getConfigParamValues(subPage, propertyMap);
            }
        }
        return propertyMap;
    }

    private void setConfigParamValues(ConfigPage page, PropertyMap propertyMap, ParamExceptionHandler errorHandler) {
        page.setConfigParamValues(propertyMap, errorHandler);
        ConfigPage[] subPages = page.getSubPages();
        if (subPages != null) {
            for (int i = 0; i < subPages.length; ++i) {
                ConfigPage subPage = subPages[i];
                this.setConfigParamValues(subPage, propertyMap, errorHandler);
            }
        }
    }

    private void onOK(ConfigPage page) {
        ConfigPage[] subPages = page.getSubPages();
        if (subPages != null) {
            for (int i = 0; i < subPages.length; ++i) {
                this.onOK(subPages[i]);
            }
        }
        page.onOK();
    }

    private void updatePageUI(ConfigPage page) {
        ConfigPage[] subPages = page.getSubPages();
        if (subPages != null) {
            for (int i = 0; i < subPages.length; ++i) {
                this.updatePageUI(subPages[i]);
            }
        }
        page.updatePageUI();
    }
}

