/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.crs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.framework.ui.crs.CrsForm;
import org.esa.beam.framework.ui.crs.projdef.CustomCrsPanel;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.OperationMethod;

public class CustomCrsForm
extends CrsForm {
    public CustomCrsForm(AppContext appContext) {
        super(appContext);
    }

    @Override
    protected String getLabelText() {
        return "Custom CRS";
    }

    @Override
    boolean wrapAfterButton() {
        return true;
    }

    @Override
    public CoordinateReferenceSystem getCRS(GeoPos referencePos) throws FactoryException {
        return ((CustomCrsPanel)this.getCrsUI()).getCRS(referencePos);
    }

    @Override
    protected JComponent createCrsComponent() {
        CustomCrsPanel panel = new CustomCrsPanel(this.getAppContext().getApplicationWindow());
        panel.addPropertyChangeListener("crs", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CustomCrsForm.this.fireCrsChanged();
            }
        });
        return panel;
    }

    @Override
    public void prepareShow() {
    }

    @Override
    public void prepareHide() {
    }

    public void setCustom(GeodeticDatum geodeticDatum, OperationMethod mapProjection, ParameterValueGroup parameterValues) {
        CustomCrsPanel customCrsPanel = (CustomCrsPanel)this.getCrsUI();
        customCrsPanel.setCustom(geodeticDatum, mapProjection, parameterValues);
    }
}

