/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.crs;

import com.bc.ceres.swing.TableLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.framework.ui.ModalDialog;
import org.esa.beam.framework.ui.crs.CrsForm;
import org.esa.beam.framework.ui.crs.CrsInfo;
import org.esa.beam.framework.ui.crs.CrsInfoListModel;
import org.esa.beam.framework.ui.crs.PredefinedCrsPanel;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PredefinedCrsForm
extends CrsForm {
    private CrsInfo selectedCrsInfo;
    private static final List<CrsInfo> crsList = CrsInfo.generateCRSList();

    public PredefinedCrsForm(AppContext appContext) {
        super(appContext);
    }

    @Override
    protected String getLabelText() {
        return "Predefined CRS";
    }

    @Override
    public CoordinateReferenceSystem getCRS(GeoPos referencePos) throws FactoryException {
        if (this.selectedCrsInfo != null) {
            return this.selectedCrsInfo.getCrs(referencePos);
        }
        return null;
    }

    @Override
    public void prepareShow() {
    }

    @Override
    public void prepareHide() {
    }

    @Override
    protected JComponent createCrsComponent() {
        TableLayout tableLayout = new TableLayout(2);
        JPanel panel = new JPanel((LayoutManager)tableLayout);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setColumnWeightX(0, Double.valueOf(1.0));
        tableLayout.setColumnWeightX(1, Double.valueOf(0.0));
        final JTextField crsCodeField = new JTextField();
        crsCodeField.setEditable(false);
        final JButton crsButton = new JButton("Select...");
        final PredefinedCrsPanel predefinedCrsForm = new PredefinedCrsPanel(new CrsInfoListModel(crsList));
        crsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModalDialog dialog = new ModalDialog(PredefinedCrsForm.this.getAppContext().getApplicationWindow(), "Select Coordinate Reference System", predefinedCrsForm, 33, null);
                if (dialog.show() == 1) {
                    PredefinedCrsForm.this.selectedCrsInfo = predefinedCrsForm.getSelectedCrsInfo();
                    crsCodeField.setText(PredefinedCrsForm.this.selectedCrsInfo.toString());
                    PredefinedCrsForm.this.fireCrsChanged();
                }
            }
        });
        panel.add(crsCodeField);
        panel.add(crsButton);
        panel.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                crsCodeField.setEnabled((Boolean)evt.getNewValue());
                crsButton.setEnabled((Boolean)evt.getNewValue());
            }
        });
        return panel;
    }
}

