/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.crs;

import com.bc.ceres.swing.TableLayout;
import com.jidesoft.list.FilterableListModel;
import com.jidesoft.list.QuickListFilterField;
import com.jidesoft.utils.Lm;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.esa.beam.framework.ui.crs.CrsInfo;
import org.esa.beam.framework.ui.crs.CrsInfoListModel;

class PredefinedCrsPanel
extends JPanel {
    private final CrsInfoListModel crsListModel;
    private JTextArea infoArea;
    private JList crsList;
    private QuickListFilterField filterField;
    private CrsInfo selectedCrsInfo;

    public static void main(String[] args) {
        Lm.verifyLicense((String)"Brockmann Consult", (String)"BEAM", (String)"lCzfhklpZ9ryjomwWxfdupxIcuIoCxg2");
        final JFrame frame = new JFrame("CRS Selection Panel");
        Container contentPane = frame.getContentPane();
        CrsInfoListModel listModel = new CrsInfoListModel(CrsInfo.generateCRSList());
        PredefinedCrsPanel predefinedCrsForm = new PredefinedCrsPanel(listModel);
        contentPane.add(predefinedCrsForm);
        frame.setSize(600, 400);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
    }

    PredefinedCrsPanel(CrsInfoListModel model) {
        this.crsListModel = model;
        this.createUI();
    }

    private void createUI() {
        this.filterField = new QuickListFilterField((ListModel)this.crsListModel);
        this.filterField.setHintText("Type here to filter CRS");
        this.filterField.setWildcardEnabled(true);
        FilterableListModel listModel = this.filterField.getDisplayListModel();
        this.crsList = new JList(listModel);
        this.crsList.setVisibleRowCount(15);
        this.filterField.setList(this.crsList);
        this.crsList.setSelectionMode(0);
        this.crsList.setSelectedValue(this.crsListModel.getElementAt(0), true);
        final JLabel filterLabel = new JLabel("Filter:");
        final JLabel infoLabel = new JLabel("Well-Known Text (WKT):");
        final JScrollPane crsListScrollPane = new JScrollPane(this.crsList);
        crsListScrollPane.setPreferredSize(new Dimension(200, 150));
        this.infoArea = new JTextArea(15, 30);
        this.infoArea.setEditable(false);
        this.crsList.addListSelectionListener(new CrsListSelectionListener());
        final JScrollPane infoAreaScrollPane = new JScrollPane(this.infoArea);
        TableLayout tableLayout = new TableLayout(3);
        this.setLayout((LayoutManager)tableLayout);
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setTablePadding(4, 4);
        tableLayout.setRowWeightY(0, Double.valueOf(0.0));
        tableLayout.setCellWeightX(0, 0, Double.valueOf(0.0));
        tableLayout.setRowWeightY(1, Double.valueOf(1.0));
        tableLayout.setCellColspan(1, 0, Integer.valueOf(2));
        tableLayout.setCellRowspan(1, 2, Integer.valueOf(2));
        tableLayout.setCellColspan(2, 0, Integer.valueOf(2));
        this.add(filterLabel);
        this.add((Component)this.filterField);
        this.add(infoLabel);
        this.add(crsListScrollPane);
        this.add(infoAreaScrollPane);
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                filterLabel.setEnabled((Boolean)evt.getNewValue());
                PredefinedCrsPanel.this.filterField.setEnabled(((Boolean)evt.getNewValue()).booleanValue());
                infoLabel.setEnabled((Boolean)evt.getNewValue());
                PredefinedCrsPanel.this.crsList.setEnabled((Boolean)evt.getNewValue());
                crsListScrollPane.setEnabled((Boolean)evt.getNewValue());
                PredefinedCrsPanel.this.infoArea.setEnabled((Boolean)evt.getNewValue());
                infoAreaScrollPane.setEnabled((Boolean)evt.getNewValue());
            }
        });
        this.crsList.getSelectionModel().setSelectionInterval(0, 0);
    }

    CrsInfo getSelectedCrsInfo() {
        return this.selectedCrsInfo;
    }

    private void setInfoText(String infoText) {
        this.infoArea.setText(infoText);
        this.infoArea.setCaretPosition(0);
    }

    private class CrsListSelectionListener
    implements ListSelectionListener {
        private CrsListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            block3: {
                JList list = (JList)e.getSource();
                PredefinedCrsPanel.this.selectedCrsInfo = (CrsInfo)list.getSelectedValue();
                if (PredefinedCrsPanel.this.selectedCrsInfo != null) {
                    try {
                        PredefinedCrsPanel.this.setInfoText(PredefinedCrsPanel.this.selectedCrsInfo.getDescription());
                    }
                    catch (Exception e1) {
                        String message = e1.getMessage();
                        if (message == null) break block3;
                        PredefinedCrsPanel.this.setInfoText("Error while creating CRS:\n\n" + message);
                    }
                }
            }
        }
    }
}

