/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.crs;

import javax.swing.JComponent;
import javax.swing.JTextField;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.framework.ui.crs.CrsForm;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ProductCrsForm
extends CrsForm {
    private final Product product;

    public ProductCrsForm(AppContext appContext, Product product) {
        super(appContext);
        this.product = product;
    }

    @Override
    protected String getLabelText() {
        return "Use target CRS";
    }

    @Override
    public CoordinateReferenceSystem getCRS(GeoPos referencePos) throws FactoryException {
        return this.getMapCrs();
    }

    private CoordinateReferenceSystem getMapCrs() {
        return this.product.getGeoCoding().getMapCRS();
    }

    @Override
    protected JComponent createCrsComponent() {
        JTextField field = new JTextField();
        field.setEditable(false);
        field.setText(this.getMapCrs().getName().getCode());
        return field;
    }

    @Override
    public void prepareShow() {
    }

    @Override
    public void prepareHide() {
    }
}

