/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.crs.projdef;

import org.esa.beam.framework.datamodel.GeoPos;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.GeodeticDatum;

abstract class AbstractCrsProvider {
    private final String name;
    private final boolean hasParameters;
    private final boolean isDatumChangable;
    private final GeodeticDatum defaultDatum;

    AbstractCrsProvider(String name, boolean hasParameters, boolean datumChangable, GeodeticDatum defaultDatum) {
        this.name = name;
        this.hasParameters = hasParameters;
        this.isDatumChangable = datumChangable;
        this.defaultDatum = defaultDatum;
    }

    String getName() {
        return this.name;
    }

    boolean hasParameters() {
        return this.hasParameters;
    }

    boolean isDatumChangable() {
        return this.isDatumChangable;
    }

    GeodeticDatum getDefaultDatum() {
        return this.defaultDatum;
    }

    abstract ParameterValueGroup getParameter();

    abstract CoordinateReferenceSystem getCRS(GeoPos var1, ParameterValueGroup var2, GeodeticDatum var3) throws FactoryException;
}

