/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.crs.projdef;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyAccessor;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyPane;
import com.jidesoft.swing.ComboBoxSearchable;
import com.jidesoft.swing.SearchableUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.ui.ModalDialog;
import org.esa.beam.framework.ui.crs.projdef.AbstractCrsProvider;
import org.esa.beam.framework.ui.crs.projdef.OperationMethodCrsProvider;
import org.esa.beam.framework.ui.crs.projdef.UTMAutomaticCrsProvider;
import org.esa.beam.framework.ui.crs.projdef.UTMZonesCrsProvider;
import org.esa.beam.framework.ui.crs.projdef.WGS84CrsProvider;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;

public class CustomCrsPanel
extends JPanel {
    private static final String OPERATION_WRAPPER = "operationWrapper";
    private static final String DATUM = "datum";
    private static final String PARAMETERS = "parameters";
    private final Set<GeodeticDatum> datumSet;
    private final Set<AbstractCrsProvider> crsProviderSet;
    private final Model model;
    private final PropertyContainer vc;
    private final Window parent;
    private JComboBox<AbstractCrsProvider> projectionComboBox;
    private JComboBox<GeodeticDatum> datumComboBox;
    private JButton paramButton;
    private static final String SEMI_MAJOR_PARAM_NAME = "semi_major";
    private static final String SEMI_MINOR_PARAM_NAME = "semi_minor";

    @Deprecated
    public CustomCrsPanel(Window parent) {
        this(parent, CustomCrsPanel.createDatumSet(), CustomCrsPanel.createCrsProviderSet());
    }

    public CustomCrsPanel(Window parent, Set<GeodeticDatum> datumSet, Set<AbstractCrsProvider> crsProviderSet) {
        this.parent = parent;
        this.datumSet = datumSet;
        this.crsProviderSet = crsProviderSet;
        GeodeticDatum wgs84Datum = null;
        for (GeodeticDatum geodeticDatum : datumSet) {
            if (!DefaultGeodeticDatum.isWGS84((Datum)geodeticDatum)) continue;
            wgs84Datum = geodeticDatum;
            break;
        }
        WGS84CrsProvider defaultMethod = new WGS84CrsProvider(wgs84Datum);
        crsProviderSet.add(defaultMethod);
        crsProviderSet.add(new UTMZonesCrsProvider(wgs84Datum));
        crsProviderSet.add(new UTMAutomaticCrsProvider(wgs84Datum));
        this.model = new Model();
        this.model.operationWrapper = defaultMethod;
        this.model.datum = wgs84Datum;
        this.vc = PropertyContainer.createObjectBacked((Object)this.model);
        this.vc.addPropertyChangeListener((PropertyChangeListener)new UpdateListener());
        this.createUI();
        this.updateModel(OPERATION_WRAPPER);
    }

    public CoordinateReferenceSystem getCRS(GeoPos referencePos) throws FactoryException {
        return this.model.operationWrapper.getCRS(referencePos, this.model.parameters, this.model.datum);
    }

    private void createUI() {
        TableLayout tableLayout = new TableLayout(2);
        this.setLayout((LayoutManager)tableLayout);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setColumnWeightX(0, Double.valueOf(0.0));
        tableLayout.setColumnWeightX(1, Double.valueOf(1.0));
        tableLayout.setCellColspan(2, 0, Integer.valueOf(2));
        tableLayout.setCellAnchor(2, 0, TableLayout.Anchor.EAST);
        tableLayout.setCellFill(2, 0, TableLayout.Fill.NONE);
        JLabel datumLabel = new JLabel("Geodetic datum:");
        JLabel projectionLabel = new JLabel("Projection:");
        this.projectionComboBox = new JComboBox<AbstractCrsProvider>(this.crsProviderSet.toArray(new AbstractCrsProvider[this.crsProviderSet.size()]));
        this.projectionComboBox.setEditable(false);
        CrsProviderSearchable methodSearchable = new CrsProviderSearchable(this.projectionComboBox);
        methodSearchable.installListeners();
        this.projectionComboBox.setRenderer(new CrsProviderCellRenderer());
        this.datumComboBox = new JComboBox<GeodeticDatum>(this.datumSet.toArray(new GeodeticDatum[this.datumSet.size()]));
        this.datumComboBox.setEditable(false);
        SearchableUtils.installSearchable(this.datumComboBox);
        this.datumComboBox.setRenderer(new IdentifiedObjectCellRenderer());
        IdentifiedObjectSearchable datumSearchable = new IdentifiedObjectSearchable(this.datumComboBox);
        datumSearchable.installListeners();
        this.paramButton = new JButton("Projection Parameters...");
        this.paramButton.addActionListener(new ParameterButtonListener());
        this.add(datumLabel);
        this.add(this.datumComboBox);
        this.add(projectionLabel);
        this.add(this.projectionComboBox);
        this.add(this.paramButton);
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CustomCrsPanel.this.updateEnableState((Boolean)evt.getNewValue());
            }
        });
        BindingContext context = new BindingContext((PropertySet)this.vc);
        context.bind(OPERATION_WRAPPER, this.projectionComboBox);
        context.bind(DATUM, this.datumComboBox);
    }

    private void updateEnableState(boolean componentEnabled) {
        this.projectionComboBox.setEnabled(componentEnabled);
        this.datumComboBox.setEnabled(this.model.operationWrapper.isDatumChangable() && componentEnabled);
        this.paramButton.setEnabled(this.model.operationWrapper.hasParameters() && componentEnabled);
    }

    private void updateModel(String propertyName) {
        if (OPERATION_WRAPPER.equals(propertyName)) {
            GeodeticDatum defaultDatum = this.model.operationWrapper.getDefaultDatum();
            if (defaultDatum != null) {
                this.vc.setValue(DATUM, (Object)defaultDatum);
            }
            if (this.model.operationWrapper.hasParameters()) {
                Object oldParameterGroup = this.vc.getValue(PARAMETERS);
                ParameterValueGroup newParameters = this.model.operationWrapper.getParameter();
                if (oldParameterGroup instanceof ParameterValueGroup) {
                    ParameterValueGroup oldParameters = (ParameterValueGroup)oldParameterGroup;
                    List generalParameterDescriptors = newParameters.getDescriptor().descriptors();
                    List oldValues = oldParameters.values();
                    for (GeneralParameterDescriptor newDescriptor : generalParameterDescriptors) {
                        String parameterName = newDescriptor.getName().getCode();
                        for (GeneralParameterValue oldParameterValue : oldValues) {
                            if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)oldParameterValue.getDescriptor(), (IdentifiedObject)newDescriptor)) continue;
                            Object old = ((ParameterValue)oldParameterValue).getValue();
                            newParameters.parameter(parameterName).setValue(old);
                        }
                    }
                }
                if (CustomCrsPanel.hasParameter(newParameters, SEMI_MAJOR_PARAM_NAME) && CustomCrsPanel.hasParameter(newParameters, SEMI_MINOR_PARAM_NAME)) {
                    ParameterValue semiMinorParam;
                    Ellipsoid ellipsoid = this.model.datum.getEllipsoid();
                    ParameterValue semiMajorParam = newParameters.parameter(SEMI_MAJOR_PARAM_NAME);
                    if (semiMajorParam.getValue() == null) {
                        semiMajorParam.setValue(ellipsoid.getSemiMajorAxis());
                    }
                    if ((semiMinorParam = newParameters.parameter(SEMI_MINOR_PARAM_NAME)).getValue() == null) {
                        semiMinorParam.setValue(ellipsoid.getSemiMinorAxis());
                    }
                }
                this.vc.setValue(PARAMETERS, (Object)newParameters);
            }
        }
        if (DATUM.equals(propertyName) && this.model.datum != null && this.model.parameters != null && CustomCrsPanel.hasParameter(this.model.parameters, SEMI_MAJOR_PARAM_NAME) && CustomCrsPanel.hasParameter(this.model.parameters, SEMI_MINOR_PARAM_NAME)) {
            Ellipsoid ellipsoid = this.model.datum.getEllipsoid();
            this.model.parameters.parameter(SEMI_MAJOR_PARAM_NAME).setValue(ellipsoid.getSemiMajorAxis());
            this.model.parameters.parameter(SEMI_MINOR_PARAM_NAME).setValue(ellipsoid.getSemiMinorAxis());
        }
        this.updateEnableState(true);
        this.firePropertyChange("crs", null, null);
    }

    private static boolean hasParameter(ParameterValueGroup parameterValueGroup, String name) {
        List generalParameterDescriptors = parameterValueGroup.getDescriptor().descriptors();
        for (GeneralParameterDescriptor descriptor : generalParameterDescriptors) {
            if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)descriptor, (String)name)) continue;
            return true;
        }
        return false;
    }

    public void setCustom(GeodeticDatum geodeticDatum, OperationMethod operationMethod, ParameterValueGroup parameterValues) {
        String geodeticDatumName = geodeticDatum.getName().getCode();
        for (GeodeticDatum datum : this.datumSet) {
            if (!datum.getName().getCode().equals(geodeticDatumName)) continue;
            this.vc.setValue(DATUM, (Object)datum);
            break;
        }
        for (AbstractCrsProvider abstractCrsProvider : this.crsProviderSet) {
            if (!(abstractCrsProvider instanceof OperationMethodCrsProvider)) continue;
            OperationMethodCrsProvider operationMethodCrsProvider = (OperationMethodCrsProvider)abstractCrsProvider;
            String operationMethodName = operationMethod.getName().getCode();
            if (!operationMethodCrsProvider.delegate.getName().getCode().equals(operationMethodName)) continue;
            this.vc.setValue(OPERATION_WRAPPER, (Object)abstractCrsProvider);
            break;
        }
        this.vc.setValue(PARAMETERS, (Object)parameterValues);
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame("Projection Method Form Test");
        CustomCrsPanel customCrsForm = new CustomCrsPanel(frame, CustomCrsPanel.createDatumSet(), CustomCrsPanel.createCrsProviderSet());
        frame.setContentPane(customCrsForm);
        frame.setDefaultCloseOperation(3);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    private static Set<AbstractCrsProvider> createCrsProviderSet() {
        MathTransformFactory factory = ReferencingFactoryFinder.getMathTransformFactory(null);
        Set methods = factory.getAvailableMethods(Projection.class);
        TreeSet<AbstractCrsProvider> crsProviderSet = new TreeSet<AbstractCrsProvider>(new CrsProviderComparator());
        for (OperationMethod method : methods) {
            crsProviderSet.add(new OperationMethodCrsProvider(method));
        }
        return crsProviderSet;
    }

    private static Set<GeodeticDatum> createDatumSet() {
        DatumAuthorityFactory factory = ReferencingFactoryFinder.getDatumAuthorityFactory((String)"EPSG", null);
        List<String> datumCodes = CustomCrsPanel.retrieveCodes(GeodeticDatum.class, (AuthorityFactory)factory);
        TreeSet<GeodeticDatum> datumSet = new TreeSet<GeodeticDatum>(AbstractIdentifiedObject.NAME_COMPARATOR);
        for (String datumCode : datumCodes) {
            try {
                DefaultGeodeticDatum geodeticDatum = (DefaultGeodeticDatum)factory.createGeodeticDatum(datumCode);
                if (geodeticDatum.getBursaWolfParameters().length == 0 && !DefaultGeodeticDatum.isWGS84((Datum)geodeticDatum)) continue;
                datumSet.add((GeodeticDatum)geodeticDatum);
            }
            catch (FactoryException ignored) {}
        }
        return datumSet;
    }

    private static List<String> retrieveCodes(Class<? extends GeodeticDatum> crsType, AuthorityFactory factory) {
        try {
            Set localCodes = factory.getAuthorityCodes(crsType);
            return new ArrayList<String>(localCodes);
        }
        catch (FactoryException ignore) {
            return Collections.emptyList();
        }
    }

    private static PropertyContainer createValueContainer(ParameterValueGroup valueGroup) {
        PropertyContainer vc = new PropertyContainer();
        List values = valueGroup.values();
        for (GeneralParameterValue value : values) {
            Class valueType;
            GeneralParameterDescriptor descriptor = value.getDescriptor();
            Set validValues = null;
            if (descriptor instanceof ParameterDescriptor) {
                ParameterDescriptor parameterDescriptor = (ParameterDescriptor)descriptor;
                valueType = parameterDescriptor.getValueClass();
                validValues = parameterDescriptor.getValidValues();
            } else {
                valueType = Double.TYPE;
            }
            String paramName = descriptor.getName().getCode();
            PropertyDescriptor vd = new PropertyDescriptor(paramName, valueType);
            final ParameterValue parameterValue = valueGroup.parameter(paramName);
            if (parameterValue.getUnit() != null) {
                vd.setUnit(String.valueOf(parameterValue.getUnit()));
            }
            if (validValues != null) {
                vd.setValueSet(new ValueSet(validValues.toArray()));
            }
            vd.setDefaultConverter();
            Property property = new Property(vd, new PropertyAccessor(){

                public Object getValue() {
                    return parameterValue.getValue();
                }

                public void setValue(Object value) {
                    parameterValue.setValue(value);
                }
            });
            vc.addProperty(property);
        }
        return vc;
    }

    private static class IdentifiedObjectCellRenderer
    extends DefaultListCellRenderer {
        private IdentifiedObjectCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            JLabel label = (JLabel)component;
            if (value != null) {
                IdentifiedObject identifiedObject = (IdentifiedObject)value;
                label.setText(identifiedObject.getName().getCode());
            }
            return label;
        }
    }

    private static class CrsProviderCellRenderer
    extends DefaultListCellRenderer {
        private CrsProviderCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            JLabel label = (JLabel)component;
            if (value != null) {
                AbstractCrsProvider wrapper = (AbstractCrsProvider)value;
                label.setText(wrapper.getName());
            }
            return label;
        }
    }

    private static class CrsProviderSearchable
    extends ComboBoxSearchable {
        private CrsProviderSearchable(JComboBox<AbstractCrsProvider> operationComboBox) {
            super(operationComboBox);
        }

        protected String convertElementToString(Object o) {
            if (o instanceof AbstractCrsProvider) {
                AbstractCrsProvider wrapper = (AbstractCrsProvider)o;
                return wrapper.getName();
            }
            return super.convertElementToString(o);
        }
    }

    private static class IdentifiedObjectSearchable
    extends ComboBoxSearchable {
        private IdentifiedObjectSearchable(JComboBox<GeodeticDatum> operationComboBox) {
            super(operationComboBox);
        }

        protected String convertElementToString(Object o) {
            if (o instanceof IdentifiedObject) {
                IdentifiedObject identifiedObject = (IdentifiedObject)o;
                return identifiedObject.getName().getCode();
            }
            return super.convertElementToString(o);
        }
    }

    private static class CrsProviderComparator
    implements Comparator<AbstractCrsProvider> {
        private CrsProviderComparator() {
        }

        @Override
        public int compare(AbstractCrsProvider o1, AbstractCrsProvider o2) {
            String name1 = o1.getName();
            String name2 = o2.getName();
            return name1.compareTo(name2);
        }
    }

    private class ParameterButtonListener
    implements ActionListener {
        private ParameterButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String operationName = CustomCrsPanel.this.model.operationWrapper.getName();
            ModalDialog modalDialog = new ModalDialog(CustomCrsPanel.this.parent, operationName + " - Parameters", 33, null);
            ParameterValueGroup workCopy = CustomCrsPanel.this.model.parameters.clone();
            PropertyContainer propertyContainer = CustomCrsPanel.createValueContainer(workCopy);
            modalDialog.setContent(new PropertyPane((PropertySet)propertyContainer).createPanel());
            if (modalDialog.show() == 1) {
                CustomCrsPanel.this.vc.setValue(CustomCrsPanel.PARAMETERS, (Object)workCopy);
            }
        }
    }

    private static class Model {
        private AbstractCrsProvider operationWrapper;
        private GeodeticDatum datum;
        private ParameterValueGroup parameters;

        private Model() {
        }
    }

    private class UpdateListener
    implements PropertyChangeListener {
        private UpdateListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CustomCrsPanel.this.updateModel(evt.getPropertyName());
        }
    }
}

