/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.crs.projdef;

import java.util.HashMap;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.ui.crs.projdef.AbstractCrsProvider;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.DefiningConversion;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;

class OperationMethodCrsProvider
extends AbstractCrsProvider {
    final OperationMethod delegate;

    OperationMethodCrsProvider(OperationMethod method) {
        super(method.getName().getCode().replace("_", " "), true, true, null);
        this.delegate = method;
    }

    @Override
    public ParameterValueGroup getParameter() {
        return this.delegate.getParameters().createValue();
    }

    @Override
    public CoordinateReferenceSystem getCRS(GeoPos referencePos, ParameterValueGroup parameters, GeodeticDatum datum) throws FactoryException {
        CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
        MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        MathTransform transform = mtFactory.createParameterizedTransform(parameters);
        DefaultOperationMethod operationMethod = new DefaultOperationMethod(transform);
        DefiningConversion conversion = new DefiningConversion(AbstractIdentifiedObject.getProperties((IdentifiedObject)operationMethod), (OperationMethod)operationMethod, transform);
        HashMap<String, String> baseCrsProperties = new HashMap<String, String>();
        baseCrsProperties.put("name", datum.getName().getCode());
        GeographicCRS baseCrs = crsFactory.createGeographicCRS(baseCrsProperties, datum, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
        HashMap<String, String> projProperties = new HashMap<String, String>();
        projProperties.put("name", conversion.getName().getCode() + " / " + datum.getName().getCode());
        return crsFactory.createProjectedCRS(projProperties, baseCrs, (Conversion)conversion, (CartesianCS)DefaultCartesianCS.PROJECTED);
    }
}

