/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.crs.projdef;

import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.ui.crs.projdef.AbstractUTMCrsProvider;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.operation.projection.TransverseMercator;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.OperationMethod;

class UTMAutomaticCrsProvider
extends AbstractUTMCrsProvider {
    private static final String NAME = "UTM / WGS 84 (Automatic)";

    UTMAutomaticCrsProvider(GeodeticDatum wgs84Datum) {
        super(NAME, false, false, wgs84Datum);
    }

    @Override
    public ParameterValueGroup getParameter() {
        return ParameterGroup.EMPTY;
    }

    @Override
    public CoordinateReferenceSystem getCRS(GeoPos referencePos, ParameterValueGroup parameters, GeodeticDatum datum) throws FactoryException {
        int zoneIndex = UTMAutomaticCrsProvider.getZoneIndex(referencePos.getLon());
        boolean south = (double)referencePos.getLat() < 0.0;
        ParameterValueGroup tmParameters = this.createTransverseMercatorParameters(zoneIndex, south, datum);
        String projName = UTMAutomaticCrsProvider.getProjectionName(zoneIndex, south);
        return this.createCrs(projName, (OperationMethod)new TransverseMercator.Provider(), tmParameters, datum);
    }
}

