/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.diagram;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import org.esa.beam.framework.ui.diagram.AbstractDiagramGraph;
import org.esa.beam.util.ObjectUtils;
import org.esa.beam.util.math.IndexValidator;
import org.esa.beam.util.math.Range;

public class DefaultDiagramGraph
extends AbstractDiagramGraph {
    private String xName;
    private double[] xValues;
    private String yName;
    private double[] yValues;
    private Range xRange;
    private Range yRange;

    public DefaultDiagramGraph() {
    }

    public DefaultDiagramGraph(String xName, double[] xValues, String yName, double[] yValues) {
        Assert.notNull((Object)yName, (String)"yName");
        this.setXName(xName);
        this.setYName(yName);
        this.setXYValues(xValues, yValues);
    }

    @Override
    public String getXName() {
        return this.xName;
    }

    public void setXName(String xName) {
        Assert.notNull((Object)xName, (String)"xName");
        if (!ObjectUtils.equalObjects((Object)this.xName, (Object)xName)) {
            this.xName = xName;
            this.invalidate();
        }
    }

    @Override
    public String getYName() {
        return this.yName;
    }

    public void setYName(String yName) {
        Assert.notNull((Object)yName, (String)"yName");
        if (!ObjectUtils.equalObjects((Object)this.yName, (Object)yName)) {
            this.yName = yName;
            this.invalidate();
        }
    }

    public double[] getXValues() {
        return this.xValues;
    }

    public double[] getYValues() {
        return this.yValues;
    }

    public void setXYValues(double[] xValues, double[] yValues) {
        Assert.notNull((Object)xValues, (String)"xValues");
        Assert.notNull((Object)yValues, (String)"yValues");
        Assert.argument((xValues.length > 1 ? 1 : 0) != 0, (String)"xValues.length > 1");
        Assert.argument((xValues.length == yValues.length ? 1 : 0) != 0, (String)"xValues.length == yValues.length");
        if (!ObjectUtils.equalObjects((Object)this.xValues, (Object)xValues) || !ObjectUtils.equalObjects((Object)this.yValues, (Object)yValues)) {
            this.xValues = xValues;
            this.yValues = yValues;
            this.xRange = Range.computeRangeDouble((double[])xValues, (IndexValidator)IndexValidator.TRUE, null, (ProgressMonitor)ProgressMonitor.NULL);
            this.yRange = Range.computeRangeDouble((double[])yValues, (IndexValidator)IndexValidator.TRUE, null, (ProgressMonitor)ProgressMonitor.NULL);
            this.invalidate();
        }
    }

    @Override
    public int getNumValues() {
        return this.xValues.length;
    }

    @Override
    public double getXValueAt(int index) {
        return this.xValues[index];
    }

    @Override
    public double getYValueAt(int index) {
        return this.yValues[index];
    }

    @Override
    public double getXMin() {
        return this.xRange.getMin();
    }

    @Override
    public double getXMax() {
        return this.xRange.getMax();
    }

    @Override
    public double getYMin() {
        return this.yRange.getMin();
    }

    @Override
    public double getYMax() {
        return this.yRange.getMax();
    }

    @Override
    public void dispose() {
        this.xValues = null;
        this.yValues = null;
        super.dispose();
    }
}

