/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.diagram;

import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.esa.beam.framework.ui.diagram.DefaultDiagramGraph;
import org.esa.beam.framework.ui.diagram.DiagramGraph;
import org.esa.beam.util.PropertyMap;
import org.esa.beam.util.io.BeamFileChooser;
import org.esa.beam.util.io.BeamFileFilter;
import org.esa.beam.util.io.CsvReader;

public class DiagramGraphIO {
    public static final BeamFileFilter CSV_FILE_FILTER = new BeamFileFilter("CSV", ".csv", "CSV (plain text)");
    public static final BeamFileFilter SPECTRA_CSV_FILE_FILTER = new BeamFileFilter("Spectra-CSV", ".csv", "Spectra CSV");
    public static final String DIAGRAM_GRAPH_IO_LAST_DIR_KEY = "diagramGraphIO.lastDir";

    public static DiagramGraph[] readGraphs(Reader reader) throws IOException {
        CsvReader csvReader = new CsvReader(reader, new char[]{'\t'});
        ArrayList<DiagramGraph> graphGroup = new ArrayList<DiagramGraph>(5);
        ArrayList<double[]> dataRecords = new ArrayList<double[]>(20);
        String[] headerRecord = csvReader.readRecord();
        while (true) {
            if (headerRecord.length < 2) {
                throw new IOException("Invalid format.");
            }
            String[] record = csvReader.readRecord();
            if (record == null) break;
            double[] dataRecord = DiagramGraphIO.toDoubles(record);
            if (dataRecord != null) {
                if (dataRecord.length != headerRecord.length) {
                    throw new IOException("Invalid format.");
                }
                dataRecords.add(dataRecord);
                continue;
            }
            DiagramGraphIO.readGraphGroup(headerRecord, dataRecords, graphGroup);
            headerRecord = record;
        }
        DiagramGraphIO.readGraphGroup(headerRecord, dataRecords, graphGroup);
        return graphGroup.toArray(new DiagramGraph[0]);
    }

    public static void writeGraphs(DiagramGraph[] graphs, Writer writer) throws IOException {
        List<List<DiagramGraph>> graphGroups = DiagramGraphIO.computeGraphGroups(graphs);
        for (List<DiagramGraph> graphGroup : graphGroups) {
            DiagramGraphIO.writeGraphGroup(graphGroup, writer);
        }
    }

    private static void readGraphGroup(String[] headerRecord, List<double[]> dataRecords, List<DiagramGraph> graphs) {
        if (dataRecords.size() > 0) {
            double[] xValues = new double[dataRecords.size()];
            for (int j = 0; j < dataRecords.size(); ++j) {
                xValues[j] = dataRecords.get(j)[0];
            }
            double[] dataRecord0 = dataRecords.get(0);
            for (int i = 1; i < dataRecord0.length; ++i) {
                double[] yValues = new double[dataRecords.size()];
                for (int j = 0; j < dataRecords.size(); ++j) {
                    yValues[j] = dataRecords.get(j)[i];
                }
                graphs.add(new DefaultDiagramGraph(headerRecord[0], xValues, headerRecord[i], yValues));
            }
        }
        dataRecords.clear();
    }

    public static double[] toDoubles(String[] textRecord) throws IOException {
        double[] doubleRecord = new double[textRecord.length];
        for (int i = 0; i < textRecord.length; ++i) {
            try {
                doubleRecord[i] = Double.valueOf(textRecord[i]);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return doubleRecord;
    }

    private static List<List<DiagramGraph>> computeGraphGroups(DiagramGraph[] graphs) {
        ArrayList<List<DiagramGraph>> graphGroups = new ArrayList<List<DiagramGraph>>(3);
        for (DiagramGraph graph : graphs) {
            boolean found = false;
            for (List list : graphGroups) {
                if (!DiagramGraphIO.equalXValues(graph, (DiagramGraph)list.get(0))) continue;
                list.add(graph);
                found = true;
                break;
            }
            if (found) continue;
            ArrayList<DiagramGraph> graphGroup = new ArrayList<DiagramGraph>(3);
            graphGroup.add(graph);
            graphGroups.add(graphGroup);
        }
        return graphGroups;
    }

    private static void writeGraphGroup(List<DiagramGraph> graphGroup, Writer writer) throws IOException {
        DiagramGraph graph0 = graphGroup.get(0);
        writer.write(graph0.getXName());
        for (DiagramGraph graph : graphGroup) {
            writer.write(9);
            writer.write(graph.getYName());
        }
        writer.write(10);
        int numValues = graph0.getNumValues();
        for (int i = 0; i < numValues; ++i) {
            writer.write(String.valueOf(graph0.getXValueAt(i)));
            for (DiagramGraph graph : graphGroup) {
                writer.write(9);
                writer.write(String.valueOf(graph.getYValueAt(i)));
            }
            writer.write(10);
        }
    }

    public static boolean equalXValues(DiagramGraph g1, DiagramGraph g2) {
        if (g1.getNumValues() != g2.getNumValues()) {
            return false;
        }
        for (int i = 0; i < g1.getNumValues(); ++i) {
            if (!(Math.abs(g1.getXValueAt(i) - g2.getXValueAt(i)) > 1.0E-10)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiagramGraph[] readGraphs(Component parentComponent, String title, BeamFileFilter[] fileFilters, PropertyMap preferences) {
        File selectedFile = DiagramGraphIO.selectGraphFile(parentComponent, title, fileFilters, preferences, true);
        if (selectedFile != null) {
            DiagramGraph[] diagramGraphArray;
            FileReader fileReader = new FileReader(selectedFile);
            try {
                diagramGraphArray = DiagramGraphIO.readGraphs(fileReader);
            }
            catch (Throwable throwable) {
                try {
                    fileReader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(parentComponent, "I/O error: " + e.getMessage());
                }
            }
            fileReader.close();
            return diagramGraphArray;
        }
        return new DiagramGraph[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeGraphs(Component parentComponent, String title, BeamFileFilter[] fileFilters, PropertyMap preferences, DiagramGraph[] graphs) {
        if (graphs.length == 0) {
            JOptionPane.showMessageDialog(parentComponent, "Nothing to save.");
            return;
        }
        File selectedFile = DiagramGraphIO.selectGraphFile(parentComponent, title, fileFilters, preferences, false);
        if (selectedFile != null) {
            try (FileWriter fileWriter = new FileWriter(selectedFile);){
                DiagramGraphIO.writeGraphs(graphs, fileWriter);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(parentComponent, "I/O error: " + e.getMessage());
            }
        }
    }

    private static File selectGraphFile(Component parentComponent, String title, BeamFileFilter[] fileFilters, PropertyMap preferences, boolean open) {
        File selectedFile;
        block8: {
            int i;
            String lastDirPath = preferences.getPropertyString(DIAGRAM_GRAPH_IO_LAST_DIR_KEY, ".");
            BeamFileChooser fileChooser = new BeamFileChooser(new File(lastDirPath));
            fileChooser.setAcceptAllFileFilterUsed(true);
            fileChooser.setDialogTitle(title);
            for (BeamFileFilter fileFilter : fileFilters) {
                fileChooser.addChoosableFileFilter((FileFilter)fileFilter);
            }
            fileChooser.setFileFilter((FileFilter)fileFilters[0]);
            if (open) {
                fileChooser.setDialogType(0);
            } else {
                fileChooser.setDialogType(1);
            }
            while ((i = fileChooser.showDialog(parentComponent, null)) == 0) {
                selectedFile = fileChooser.getSelectedFile();
                if (!open && selectedFile.exists()) {
                    i = JOptionPane.showConfirmDialog(parentComponent, "The file\n" + selectedFile + "\nalready exists.\nOverwrite?", "File exists", 1);
                    if (i == 2) {
                        selectedFile = null;
                    } else if (i != 0) continue;
                }
                break block8;
            }
            selectedFile = null;
        }
        if (selectedFile != null) {
            preferences.setPropertyString(DIAGRAM_GRAPH_IO_LAST_DIR_KEY, selectedFile.getParent());
        }
        return selectedFile;
    }
}

