/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import org.esa.beam.framework.dataio.ProductIOPlugInManager;
import org.esa.beam.framework.ui.GridBagUtils;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.tool.ToolButtonFactory;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.io.BeamFileChooser;
import org.esa.beam.util.io.BeamFileFilter;

public class FileArrayEditor {
    private static final Dimension _listPreferredSize = new Dimension(500, 200);
    private JPanel _basePanel;
    private JFileChooser _fileDialog;
    private FileArrayEditorListener _listener;
    private final JList _listComponent;
    private final List<File> _fileList;
    private final EditorParent _parent;
    private final String _label;

    public FileArrayEditor(EditorParent parent, String label) {
        Guardian.assertNotNullOrEmpty((String)"label", (String)label);
        this._parent = parent;
        this._label = label;
        this._fileList = new ArrayList<File>();
        this._listComponent = new JList();
        this.setName(this._listComponent, this._label);
    }

    protected final EditorParent getParent() {
        return this._parent;
    }

    public JComponent getUI() {
        if (this._basePanel == null) {
            this.createUI();
        }
        return this._basePanel;
    }

    public void setFiles(List<File> files) {
        Guardian.assertNotNull((String)"files", files);
        this._fileList.clear();
        this._fileList.addAll(files);
        this._listComponent.setListData(this._fileList.toArray());
        this.notifyListener();
    }

    public List<File> getFiles() {
        return this._fileList;
    }

    public void setListener(FileArrayEditorListener listener) {
        this._listener = listener;
    }

    private void createUI() {
        JLabel label = new JLabel(this._label + ":");
        this.setName(label, this._label);
        JComponent scrollPane = this.createFileArrayComponent();
        JButton addButton = this.createAddFileButton();
        JButton removeButton = this.createRemoveFileButton();
        JPanel buttonPanel = new JPanel();
        this.setName(buttonPanel, this._label);
        buttonPanel.add(addButton);
        buttonPanel.add(removeButton);
        this._basePanel = GridBagUtils.createDefaultEmptyBorderPanel();
        this.setName(this._basePanel, this._label);
        GridBagConstraints gbc = GridBagUtils.createConstraints(null);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        ++gbc.gridy;
        this._basePanel.add((Component)label, gbc);
        gbc.anchor = 13;
        this._basePanel.add((Component)buttonPanel, gbc);
        ++gbc.gridy;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this._basePanel.add((Component)scrollPane, gbc);
    }

    public JButton createRemoveFileButton() {
        JButton removeButton = (JButton)ToolButtonFactory.createButton(UIUtils.loadImageIcon("icons/Minus16.gif"), false);
        this.setName(removeButton, "removeButton");
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileArrayEditor.this.onRemoveButton();
            }
        });
        return removeButton;
    }

    public JButton createAddFileButton() {
        JButton addButton = (JButton)ToolButtonFactory.createButton(UIUtils.loadImageIcon("icons/Plus16.gif"), false);
        this.setName(addButton, "addButton");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileArrayEditor.this.onAddButton();
            }
        });
        return addButton;
    }

    public JComponent createFileArrayComponent() {
        JScrollPane scrollPane = new JScrollPane(this._listComponent);
        this.setName(scrollPane, this._label);
        scrollPane.setPreferredSize(_listPreferredSize);
        return scrollPane;
    }

    private void setName(Component comp, String name) {
        comp.setName(name);
    }

    private void onAddButton() {
        this._fileDialog = this.getFileDialogSafe();
        File userInputDir = this._parent.getUserInputDir();
        this._fileDialog.setCurrentDirectory(userInputDir);
        int retVal = this._fileDialog.showOpenDialog(this._basePanel);
        if (retVal == 0) {
            File[] selected = this._fileDialog.getSelectedFiles();
            this._fileList.addAll(Arrays.asList(selected));
            this._listComponent.setListData(this._fileList.toArray());
            this.notifyListener();
            this._parent.setUserInputDir(this._fileDialog.getCurrentDirectory());
        }
    }

    private void onRemoveButton() {
        Object[] toRemove;
        for (Object o : toRemove = this._listComponent.getSelectedValues()) {
            this._fileList.remove(o);
        }
        this._listComponent.setListData(this._fileList.toArray());
        this.notifyListener();
    }

    private JFileChooser getFileDialogSafe() {
        if (this._fileDialog == null) {
            this._fileDialog = this.createFileChooserDialog();
        }
        return this._fileDialog;
    }

    protected JFileChooser createFileChooserDialog() {
        BeamFileChooser chooser = new BeamFileChooser();
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setMultiSelectionEnabled(true);
        Iterator iterator = ProductIOPlugInManager.getInstance().getAllReaderPlugIns();
        List sortedFileFilters = BeamFileFilter.getSortedFileFilters((Iterator)iterator);
        for (BeamFileFilter productFileFilter : sortedFileFilters) {
            chooser.addChoosableFileFilter((FileFilter)productFileFilter);
        }
        chooser.setFileFilter(chooser.getAcceptAllFileFilter());
        return chooser;
    }

    private void notifyListener() {
        if (this._listener != null) {
            this._listener.updatedList(this._fileList.toArray(new File[this._fileList.size()]));
        }
    }

    public static interface FileArrayEditorListener {
        public void updatedList(File[] var1);
    }

    public static interface EditorParent {
        public File getUserInputDir();

        public void setUserInputDir(File var1);
    }
}

