/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.layer;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyAccessor;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.accessors.DefaultPropertyAccessor;
import com.bc.ceres.swing.binding.Binding;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyPane;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.esa.beam.framework.ui.layer.AbstractLayerEditor;

public abstract class AbstractLayerConfigurationEditor
extends AbstractLayerEditor {
    private BindingContext bindingContext;

    protected final BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @Override
    public JComponent createControl() {
        this.bindingContext = new BindingContext();
        PropertySet propertySet = this.bindingContext.getPropertySet();
        propertySet.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeHandler());
        this.addEditablePropertyDescriptors();
        PropertyPane propertyPane = new PropertyPane(this.bindingContext);
        return propertyPane.createPanel();
    }

    @Override
    public void handleLayerContentChanged() {
        Property[] editorProperties;
        for (Property editorProperty : editorProperties = this.bindingContext.getPropertySet().getProperties()) {
            String propertyName = editorProperty.getDescriptor().getName();
            Property layerProperty = this.getCurrentLayer().getConfiguration().getProperty(propertyName);
            if (layerProperty == null) continue;
            Binding binding = this.bindingContext.getBinding(propertyName);
            Object layerValue = layerProperty.getValue();
            Object editorValue = binding.getPropertyValue();
            if (editorValue == layerValue || editorValue != null && editorValue.equals(layerValue)) continue;
            binding.setPropertyValue(layerValue);
        }
    }

    @Override
    public void handleEditorAttached() {
    }

    @Override
    public void handleEditorDetached() {
    }

    protected abstract void addEditablePropertyDescriptors();

    protected final void addPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        String propertyName = propertyDescriptor.getName();
        Object value = this.getCurrentLayer().getConfiguration().getValue(propertyName);
        if (value == null) {
            value = propertyDescriptor.getDefaultValue();
        }
        Property editorProperty = new Property(propertyDescriptor, (PropertyAccessor)new DefaultPropertyAccessor(value));
        this.bindingContext.getPropertySet().addProperty(editorProperty);
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (AbstractLayerConfigurationEditor.this.getCurrentLayer() != null) {
                try {
                    Property layerProperty = AbstractLayerConfigurationEditor.this.getCurrentLayer().getConfiguration().getProperty(propertyName);
                    if (layerProperty != null) {
                        layerProperty.setValue(evt.getNewValue());
                    }
                }
                catch (ValidationException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
        }
    }
}

