/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import com.bc.ceres.binding.ValidationException;
import com.jidesoft.swing.FolderChooser;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.framework.ui.product.FileSelectionPatternDialog;
import org.esa.beam.framework.ui.product.InputListModel;
import org.esa.beam.util.PropertyMap;
import org.esa.beam.util.SystemUtils;

class AddDirectoryAction
extends AbstractAction {
    private final String lastDirProperty;
    private boolean recursive;
    private AppContext appContext;
    private InputListModel listModel;

    AddDirectoryAction(AppContext appContext, InputListModel listModel, boolean recursive, String lastDirProperty) {
        this(recursive, lastDirProperty);
        this.appContext = appContext;
        this.listModel = listModel;
    }

    private AddDirectoryAction(boolean recursive, String lastDirProperty) {
        this("Add directory" + (recursive ? " recursively" : "(s)") + "...", lastDirProperty);
        this.recursive = recursive;
    }

    private AddDirectoryAction(String title, String lastDirProperty) {
        super(title);
        this.lastDirProperty = lastDirProperty;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object[] selectedDirs;
        FolderChooser folderChooser = new FolderChooser();
        PropertyMap preferences = this.appContext.getPreferences();
        String lastDir = preferences.getPropertyString(this.lastDirProperty, SystemUtils.getUserHomeDir().getPath());
        if (lastDir != null) {
            folderChooser.setCurrentDirectory(new File(lastDir));
        }
        folderChooser.setMultiSelectionEnabled(!this.recursive);
        Window parent = this.appContext.getApplicationWindow();
        int result = folderChooser.showOpenDialog((Component)parent);
        if (result != 0) {
            return;
        }
        String defaultPattern = this.recursive ? "*.dim" : "*";
        FileSelectionPatternDialog dialog = new FileSelectionPatternDialog(defaultPattern, parent);
        if (dialog.show() != 1) {
            return;
        }
        String pattern = dialog.getPattern();
        if (this.recursive) {
            File selectedDir = folderChooser.getSelectedFolder();
            lastDir = selectedDir.getAbsolutePath();
            selectedDir = new File(selectedDir, "**");
            selectedDir = new File(selectedDir, pattern);
            selectedDirs = new File[]{selectedDir};
        } else {
            File[] selectedPaths = folderChooser.getSelectedFiles();
            if (selectedPaths.length > 0) {
                lastDir = selectedPaths[0].getAbsolutePath();
            }
            selectedDirs = new File[selectedPaths.length];
            for (int i = 0; i < selectedPaths.length; ++i) {
                File selectedFile = selectedPaths[i];
                selectedDirs[i] = new File(selectedFile, pattern);
            }
        }
        preferences.setPropertyString(this.lastDirProperty, lastDir);
        try {
            this.listModel.addElements(selectedDirs);
        }
        catch (ValidationException ve) {
            this.appContext.handleError("Invalid input path", ve);
        }
    }
}

