/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import com.bc.ceres.binding.ValidationException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.esa.beam.framework.dataio.ProductIOPlugInManager;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.framework.ui.product.InputListModel;
import org.esa.beam.util.PropertyMap;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.io.BeamFileFilter;

class AddFileAction
extends AbstractAction {
    public static final String ALL_FILES_FORMAT = "ALL_FILES";
    private final AppContext appContext;
    private final InputListModel listModel;
    private final String lastOpenInputDir;
    private final String lastOpenedFormat;

    AddFileAction(AppContext appContext, InputListModel listModel, String lastOpenInputDir, String lastOpenedFormat) {
        super("Add product file(s)...");
        this.appContext = appContext;
        this.listModel = listModel;
        this.lastOpenInputDir = lastOpenInputDir;
        this.lastOpenedFormat = lastOpenedFormat;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PropertyMap preferences = this.appContext.getPreferences();
        String lastDir = preferences.getPropertyString(this.lastOpenInputDir, SystemUtils.getUserHomeDir().getPath());
        String lastFormat = preferences.getPropertyString(this.lastOpenedFormat, ALL_FILES_FORMAT);
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(new File(lastDir));
        fileChooser.setDialogTitle("Select product(s)");
        fileChooser.setMultiSelectionEnabled(true);
        FileFilter actualFileFilter = fileChooser.getAcceptAllFileFilter();
        Iterator allReaderPlugIns = ProductIOPlugInManager.getInstance().getAllReaderPlugIns();
        List sortedFileFilters = BeamFileFilter.getSortedFileFilters((Iterator)allReaderPlugIns);
        for (BeamFileFilter productFileFilter : sortedFileFilters) {
            fileChooser.addChoosableFileFilter((FileFilter)productFileFilter);
            if (ALL_FILES_FORMAT.equals(lastFormat) || !productFileFilter.getFormatName().equals(lastFormat)) continue;
            actualFileFilter = productFileFilter;
        }
        fileChooser.setFileFilter(actualFileFilter);
        int result = fileChooser.showDialog(this.appContext.getApplicationWindow(), "Select product(s)");
        if (result != 0) {
            return;
        }
        preferences.setPropertyString(this.lastOpenInputDir, fileChooser.getCurrentDirectory().getAbsolutePath());
        Object[] selectedProducts = fileChooser.getSelectedFiles();
        try {
            this.listModel.addElements(selectedProducts);
        }
        catch (ValidationException ve) {
            this.appContext.handleError("Invalid input path", ve);
        }
        this.setLastOpenedFormat(preferences, fileChooser.getFileFilter());
    }

    private void setLastOpenedFormat(PropertyMap preferences, FileFilter fileFilter) {
        if (fileFilter instanceof BeamFileFilter) {
            String currentFormat = ((BeamFileFilter)fileFilter).getFormatName();
            if (currentFormat != null) {
                preferences.setPropertyString(this.lastOpenedFormat, currentFormat);
            }
        } else {
            preferences.setPropertyString(this.lastOpenedFormat, ALL_FILES_FORMAT);
        }
    }
}

