/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import com.bc.ceres.swing.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.ui.ModalDialog;
import org.esa.beam.framework.ui.product.BandChoosingStrategy;
import org.esa.beam.framework.ui.product.DefaultBandChoosingStrategy;
import org.esa.beam.framework.ui.product.GroupedBandChoosingStrategy;
import org.esa.beam.framework.ui.product.LoadSaveRasterDataNodesConfigurationsComponent;
import org.esa.beam.framework.ui.product.LoadSaveRasterDataNodesConfigurationsProvider;

public class BandChooser
extends ModalDialog
implements LoadSaveRasterDataNodesConfigurationsComponent {
    private final boolean selectAtLeastOneBand;
    private BandChoosingStrategy strategy;
    private boolean addLoadSaveConfigurationButtons;

    public BandChooser(Window parent, String title, String helpID, Band[] allBands, Band[] selectedBands, Product.AutoGrouping autoGrouping, boolean addLoadSaveConfigurationButtons) {
        super(parent, title, 33, helpID);
        this.addLoadSaveConfigurationButtons = addLoadSaveConfigurationButtons;
        boolean multipleProducts = this.bandsAndGridsFromMoreThanOneProduct(allBands, null);
        this.strategy = new GroupedBandChoosingStrategy(allBands, selectedBands, null, null, autoGrouping, multipleProducts);
        this.selectAtLeastOneBand = false;
        this.initUI();
    }

    public BandChooser(Window parent, String title, String helpID, Band[] allBands, Band[] selectedBands, boolean addLoadSaveConfigurationButtons) {
        this(parent, title, helpID, true, allBands, selectedBands, null, null, addLoadSaveConfigurationButtons);
    }

    public BandChooser(Window parent, String title, String helpID, boolean selectAtLeastOneBand, Band[] allBands, Band[] selectedBands, TiePointGrid[] allTiePointGrids, TiePointGrid[] selectedTiePointGrids, boolean addLoadSaveConfigurationButtons) {
        super(parent, title, 33, helpID);
        this.addLoadSaveConfigurationButtons = addLoadSaveConfigurationButtons;
        boolean multipleProducts = this.bandsAndGridsFromMoreThanOneProduct(allBands, allTiePointGrids);
        this.strategy = new DefaultBandChoosingStrategy(allBands, selectedBands, allTiePointGrids, selectedTiePointGrids, multipleProducts);
        this.selectAtLeastOneBand = selectAtLeastOneBand;
        this.initUI();
    }

    private boolean bandsAndGridsFromMoreThanOneProduct(Band[] allBands, TiePointGrid[] allTiePointGrids) {
        HashSet<Product> productSet = new HashSet<Product>();
        if (allBands != null) {
            for (Band band : allBands) {
                productSet.add(band.getProduct());
            }
        }
        if (allTiePointGrids != null) {
            for (Band band : allTiePointGrids) {
                productSet.add(band.getProduct());
            }
        }
        return productSet.size() > 1;
    }

    @Override
    public int show() {
        this.strategy.updateCheckBoxStates();
        return super.show();
    }

    private void initUI() {
        JPanel checkersPane = this.strategy.createCheckersPane();
        JCheckBox selectAllCheckBox = new JCheckBox("Select all");
        selectAllCheckBox.setMnemonic('a');
        selectAllCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BandChooser.this.strategy.selectAll();
            }
        });
        JCheckBox selectNoneCheckBox = new JCheckBox("Select none");
        selectNoneCheckBox.setMnemonic('n');
        selectNoneCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BandChooser.this.strategy.selectNone();
            }
        });
        this.strategy.setCheckBoxes(selectAllCheckBox, selectNoneCheckBox);
        JPanel checkPane = new JPanel(new BorderLayout());
        checkPane.add((Component)selectAllCheckBox, "West");
        checkPane.add((Component)selectNoneCheckBox, "Center");
        TableLayout layout = new TableLayout(1);
        layout.setTablePadding(4, 4);
        JPanel buttonPanel = new JPanel((LayoutManager)layout);
        if (this.addLoadSaveConfigurationButtons) {
            LoadSaveRasterDataNodesConfigurationsProvider provider = new LoadSaveRasterDataNodesConfigurationsProvider(this);
            AbstractButton loadButton = provider.getLoadButton();
            AbstractButton saveButton = provider.getSaveButton();
            buttonPanel.add(loadButton);
            buttonPanel.add(saveButton);
            buttonPanel.add(layout.createVerticalSpacer());
        }
        JPanel content = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(checkersPane);
        Dimension preferredSize = checkersPane.getPreferredSize();
        scrollPane.setPreferredSize(new Dimension(Math.min(preferredSize.width + 20, 400), Math.min(preferredSize.height + 10, 300)));
        content.add((Component)scrollPane, "Center");
        content.add((Component)buttonPanel, "East");
        content.add((Component)checkPane, "South");
        content.setMinimumSize(new Dimension(0, 100));
        this.setContent(content);
    }

    @Override
    protected boolean verifyUserInput() {
        if (!this.strategy.atLeastOneBandSelected() && this.selectAtLeastOneBand) {
            this.showInformationDialog("No bands selected.\nPlease select at least one band.");
            return false;
        }
        return true;
    }

    public Band[] getSelectedBands() {
        return this.strategy.getSelectedBands();
    }

    public TiePointGrid[] getSelectedTiePointGrids() {
        return this.strategy.getSelectedTiePointGrids();
    }

    @Override
    public void setReadRasterDataNodeNames(String[] readRasterDataNodeNames) {
        this.strategy.selectNone();
        this.strategy.selectRasterDataNodes(readRasterDataNodeNames);
    }

    @Override
    public String[] getRasterDataNodeNamesToWrite() {
        int i;
        Band[] selectedBands = this.strategy.getSelectedBands();
        TiePointGrid[] selectedTiePointGrids = this.strategy.getSelectedTiePointGrids();
        String[] nodeNames = new String[selectedBands.length + selectedTiePointGrids.length];
        for (i = 0; i < selectedBands.length; ++i) {
            nodeNames[i] = selectedBands[i].getName();
        }
        for (i = 0; i < selectedTiePointGrids.length; ++i) {
            nodeNames[selectedBands.length + i] = selectedTiePointGrids[i].getName();
        }
        return nodeNames;
    }
}

