/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import java.util.Arrays;
import java.util.Comparator;
import org.esa.beam.framework.datamodel.Band;

class BandSorter {
    BandSorter() {
    }

    static Comparator<Band> createComparator() {
        return new Comparator<Band>(){

            @Override
            public int compare(Band band1, Band band2) {
                String band1Name = BandSorter.removeDigits(band1);
                String band2Name = BandSorter.removeDigits(band2);
                float wavelength1 = band1.getSpectralWavelength();
                float wavelength2 = band2.getSpectralWavelength();
                if (band1Name.equals(band2Name)) {
                    if (wavelength1 > 0.0f && wavelength2 > 0.0f && wavelength1 != wavelength2) {
                        return (int)(wavelength1 - wavelength2);
                    }
                    return band1.getName().compareTo(band2.getName());
                }
                if ((double)wavelength1 > 0.0 && (double)wavelength2 > 0.0) {
                    return (int)(wavelength1 - wavelength2);
                }
                return band1.getName().compareTo(band2.getName());
            }
        };
    }

    static void sort(Band[] allBands) {
        Arrays.sort(allBands, BandSorter.createComparator());
    }

    private static String removeDigits(Band band) {
        return band.getName().replaceAll("\\d", "");
    }
}

