/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import com.jidesoft.swing.CheckBoxTree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.ui.GridBagUtils;
import org.esa.beam.framework.ui.product.BandChoosingStrategy;
import org.esa.beam.framework.ui.product.BandSorter;

public class GroupedBandChoosingStrategy
implements BandChoosingStrategy {
    private static final Font SMALL_PLAIN_FONT = new Font("SansSerif", 0, 10);
    private static final Font SMALL_ITALIC_FONT = SMALL_PLAIN_FONT.deriveFont(2);
    private JCheckBox selectAllCheckBox;
    private JCheckBox selectNoneCheckBox;
    private boolean multipleProducts;
    private Product.AutoGrouping autoGrouping;
    private CheckBoxTree checkBoxTree;
    private final Map<Band, String> allBandsMap;
    private final Map<Band, String> selectedBandsMap;
    private final Map<TiePointGrid, String> allGridsMap;
    private final Map<TiePointGrid, String> selectedGridsMap;

    public GroupedBandChoosingStrategy(Band[] allBands, Band[] selectedBands, TiePointGrid[] allTiePointGrids, TiePointGrid[] selectedTiePointGrids, Product.AutoGrouping autoGrouping, boolean multipleProducts) {
        this.allBandsMap = this.createBandMap(allBands);
        this.selectedBandsMap = this.createBandMap(selectedBands);
        this.allGridsMap = this.createTiepointGridMap(allTiePointGrids);
        this.selectedGridsMap = this.createTiepointGridMap(selectedTiePointGrids);
        this.autoGrouping = autoGrouping;
        this.multipleProducts = multipleProducts;
    }

    private Map<Band, String> createBandMap(Band[] bands) {
        TreeMap<Band, String> bandMap = new TreeMap<Band, String>(BandSorter.createComparator());
        if (bands != null) {
            for (Band band : bands) {
                bandMap.put(band, this.getDisplayDescription((RasterDataNode)band));
            }
        }
        return bandMap;
    }

    private Map<TiePointGrid, String> createTiepointGridMap(TiePointGrid[] grids) {
        TreeMap<TiePointGrid, String> gridMap = new TreeMap<TiePointGrid, String>(new Comparator<TiePointGrid>(){

            @Override
            public int compare(TiePointGrid grid1, TiePointGrid grid2) {
                return grid1.getName().compareTo(grid2.getName());
            }
        });
        if (grids != null) {
            for (TiePointGrid grid : grids) {
                gridMap.put(grid, this.getDisplayDescription((RasterDataNode)grid));
            }
        }
        return gridMap;
    }

    private String getDisplayDescription(RasterDataNode rasterDataNode) {
        String fullName = this.multipleProducts ? rasterDataNode.getDisplayName() : rasterDataNode.getName();
        StringBuilder description = new StringBuilder();
        description.setLength(0);
        description.append(fullName);
        description.append(rasterDataNode.getDescription() == null ? "" : " (" + rasterDataNode.getDescription());
        if (rasterDataNode instanceof Band && (double)((Band)rasterDataNode).getSpectralWavelength() > 0.0) {
            description.append(" (");
            description.append(((Band)rasterDataNode).getSpectralWavelength());
            description.append(" nm)");
        }
        description.append(")");
        return description.toString();
    }

    @Override
    public Band[] getSelectedBands() {
        ArrayList<Band> selectedBandList = new ArrayList<Band>();
        TreePath[] selectionPaths = this.checkBoxTree.getCheckBoxTreeSelectionModel().getSelectionPaths();
        TreePath rootPath = new TreePath(this.checkBoxTree.getModel().getRoot());
        for (TreePath selectionPath : selectionPaths) {
            if (selectionPath.equals(rootPath)) {
                return this.allBandsMap.keySet().toArray(new Band[this.allBandsMap.size()]);
            }
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            if (selectedNode.isLeaf()) {
                RasterDataNode key = this.getKey(selectedNode.getUserObject().toString(), this.allBandsMap);
                if (key == null) continue;
                selectedBandList.add((Band)key);
                continue;
            }
            for (int i = 0; i < selectedNode.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)selectedNode.getChildAt(i);
                RasterDataNode key = this.getKey(child.getUserObject().toString(), this.allBandsMap);
                if (key == null) continue;
                selectedBandList.add((Band)key);
            }
        }
        return selectedBandList.toArray(new Band[selectedBandList.size()]);
    }

    private RasterDataNode getKey(String value, Map<? extends RasterDataNode, String> map) {
        for (Map.Entry<? extends RasterDataNode, String> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public TiePointGrid[] getSelectedTiePointGrids() {
        ArrayList<TiePointGrid> selectedGridList = new ArrayList<TiePointGrid>();
        TreePath[] selectionPaths = this.checkBoxTree.getCheckBoxTreeSelectionModel().getSelectionPaths();
        TreePath rootPath = new TreePath(this.checkBoxTree.getModel().getRoot());
        for (TreePath selectionPath : selectionPaths) {
            if (selectionPath.equals(rootPath)) {
                return this.allGridsMap.keySet().toArray(new TiePointGrid[this.allGridsMap.size()]);
            }
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            if (selectedNode.isLeaf()) {
                RasterDataNode key = this.getKey(selectedNode.getUserObject().toString(), this.allGridsMap);
                if (key == null) continue;
                selectedGridList.add((TiePointGrid)key);
                continue;
            }
            for (int i = 0; i < selectedNode.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)selectedNode.getChildAt(i);
                RasterDataNode key = this.getKey(child.getUserObject().toString(), this.allGridsMap);
                if (key != null) {
                    selectedGridList.add((TiePointGrid)key);
                }
                selectedGridList.add((TiePointGrid)key);
            }
        }
        return selectedGridList.toArray(new TiePointGrid[selectedGridList.size()]);
    }

    @Override
    public JPanel createCheckersPane() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        Map<String, Integer> groupNodeMap = this.initGrouping(root);
        ArrayList<TreePath> selectedPaths = new ArrayList<TreePath>();
        this.addBandCheckBoxes(root, selectedPaths, groupNodeMap);
        this.addTiePointGridCheckBoxes(root, selectedPaths, groupNodeMap);
        this.removeEmptyGroups(root, groupNodeMap);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.checkBoxTree = new CheckBoxTree((TreeModel)treeModel);
        this.checkBoxTree.getCheckBoxTreeSelectionModel().setSelectionPaths(selectedPaths.toArray(new TreePath[selectedPaths.size()]));
        this.checkBoxTree.setRootVisible(false);
        this.checkBoxTree.setShowsRootHandles(true);
        this.checkBoxTree.getCheckBoxTreeSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                GroupedBandChoosingStrategy.this.updateCheckBoxStates();
            }
        });
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.checkBoxTree.getActualCellRenderer();
        renderer.setFont(SMALL_ITALIC_FONT);
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        Color color = new Color(240, 240, 240);
        this.checkBoxTree.setBackground(color);
        renderer.setBackgroundSelectionColor(color);
        renderer.setBackgroundNonSelectionColor(color);
        renderer.setBorderSelectionColor(color);
        renderer.setTextSelectionColor(Color.BLACK);
        GridBagConstraints gbc2 = GridBagUtils.createConstraints("insets.left=4,anchor=WEST,fill=BOTH");
        JPanel checkersPane = GridBagUtils.createPanel();
        GridBagUtils.addToPanel(checkersPane, (Component)this.checkBoxTree, gbc2, "weightx=1.0,weighty=1.0");
        return checkersPane;
    }

    private Map<String, Integer> initGrouping(DefaultMutableTreeNode root) {
        HashMap<String, Integer> groupNodeMap = new HashMap<String, Integer>();
        if (this.autoGrouping != null) {
            for (String[] groupNames : this.autoGrouping) {
                String groupName = groupNames[0];
                if (this.hasChild(root, groupName)) continue;
                DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(groupName);
                groupNodeMap.put(groupNode.getUserObject().toString(), root.getChildCount());
                root.add(groupNode);
            }
        }
        return groupNodeMap;
    }

    private void removeEmptyGroups(DefaultMutableTreeNode root, Map<String, Integer> groupNodeMap) {
        DefaultMutableTreeNode rootChild = (DefaultMutableTreeNode)root.getFirstChild();
        while (rootChild != null) {
            DefaultMutableTreeNode nextChild = rootChild.getNextSibling();
            if (rootChild.getChildCount() == 0 && groupNodeMap.containsKey(rootChild.getUserObject().toString())) {
                root.remove(rootChild);
            }
            rootChild = nextChild;
        }
    }

    private void addBandCheckBoxes(DefaultMutableTreeNode root, List<TreePath> selectedPaths, Map<String, Integer> groupNodeMap) {
        Set<Map.Entry<Band, String>> allBands = this.allBandsMap.entrySet();
        for (Map.Entry<Band, String> bandEntry : allBands) {
            Band band = bandEntry.getKey();
            if (this.autoGrouping != null) {
                int bandIndex = this.autoGrouping.indexOf(band.getName());
                if (bandIndex >= 0) {
                    String groupName = ((String[])this.autoGrouping.get(bandIndex))[0];
                    Integer index = groupNodeMap.get(groupName);
                    DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)root.getChildAt(index);
                    DefaultMutableTreeNode groupChild = new DefaultMutableTreeNode(bandEntry.getValue());
                    if (this.selectedBandsMap.containsValue(bandEntry.getValue())) {
                        selectedPaths.add(new TreePath(new Object[]{root, groupNode, groupChild}));
                    }
                    groupNode.add(groupChild);
                    continue;
                }
                this.addToRoot(root, selectedPaths, bandEntry, band);
                continue;
            }
            this.addToRoot(root, selectedPaths, bandEntry, band);
        }
    }

    private void addTiePointGridCheckBoxes(DefaultMutableTreeNode root, List<TreePath> selectedPaths, Map<String, Integer> groupNodeMap) {
        Set<Map.Entry<TiePointGrid, String>> allGrids = this.allGridsMap.entrySet();
        for (Map.Entry<TiePointGrid, String> gridEntry : allGrids) {
            TiePointGrid grid = gridEntry.getKey();
            if (this.autoGrouping != null) {
                int gridIndex = this.autoGrouping.indexOf(grid.getName());
                if (gridIndex >= 0) {
                    String groupName = ((String[])this.autoGrouping.get(gridIndex))[0];
                    Integer index = groupNodeMap.get(groupName);
                    DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)root.getChildAt(index);
                    DefaultMutableTreeNode groupChild = new DefaultMutableTreeNode(gridEntry.getValue());
                    if (this.selectedGridsMap.containsKey(grid)) {
                        selectedPaths.add(new TreePath(new Object[]{root, groupNode, groupChild}));
                    }
                    groupNode.add(groupChild);
                    continue;
                }
                this.addToRoot(root, selectedPaths, gridEntry, grid);
                continue;
            }
            this.addToRoot(root, selectedPaths, gridEntry, grid);
        }
    }

    private void addToRoot(DefaultMutableTreeNode root, List<TreePath> selectedPaths, Map.Entry<Band, String> bandEntry, Band band) {
        DefaultMutableTreeNode rootChild = new DefaultMutableTreeNode(bandEntry.getValue());
        if (this.selectedBandsMap.containsKey(band)) {
            selectedPaths.add(new TreePath(new Object[]{root, rootChild}));
        }
        root.add(rootChild);
    }

    private void addToRoot(DefaultMutableTreeNode root, List<TreePath> selectedPaths, Map.Entry<TiePointGrid, String> gridEntry, TiePointGrid grid) {
        DefaultMutableTreeNode rootChild = new DefaultMutableTreeNode(gridEntry.getValue());
        if (this.selectedGridsMap.containsKey(grid)) {
            selectedPaths.add(new TreePath(new Object[]{root, rootChild}));
        }
        root.add(rootChild);
    }

    @Override
    public void updateCheckBoxStates() {
        TreePath[] selectionPaths = this.checkBoxTree.getCheckBoxTreeSelectionModel().getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            this.selectAllCheckBox.setSelected(false);
            this.selectAllCheckBox.setEnabled(true);
            this.selectAllCheckBox.updateUI();
            this.selectNoneCheckBox.setSelected(true);
            this.selectNoneCheckBox.setEnabled(false);
            this.selectNoneCheckBox.updateUI();
        } else {
            TreePath rootPath = new TreePath(this.checkBoxTree.getModel().getRoot());
            boolean allSelected = false;
            for (TreePath selectionPath : selectionPaths) {
                if (selectionPath.equals(rootPath)) {
                    allSelected = true;
                }
                this.selectAllCheckBox.setSelected(allSelected);
                this.selectAllCheckBox.setEnabled(!allSelected);
                this.selectAllCheckBox.updateUI();
                this.selectNoneCheckBox.setSelected(false);
                this.selectNoneCheckBox.setEnabled(true);
                this.selectNoneCheckBox.updateUI();
            }
        }
    }

    private boolean hasChild(DefaultMutableTreeNode node, String groupName) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (!((DefaultMutableTreeNode)node.getChildAt(i)).getUserObject().equals(groupName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setCheckBoxes(JCheckBox selectAllCheckBox, JCheckBox selectNoneCheckBox) {
        this.selectAllCheckBox = selectAllCheckBox;
        this.selectNoneCheckBox = selectNoneCheckBox;
        this.updateCheckBoxStates();
    }

    @Override
    public void selectAll() {
        this.checkBoxTree.getCheckBoxTreeSelectionModel().setSelectionPath(new TreePath(this.checkBoxTree.getModel().getRoot()));
    }

    @Override
    public void selectNone() {
        this.checkBoxTree.getCheckBoxTreeSelectionModel().clearSelection();
    }

    @Override
    public boolean atLeastOneBandSelected() {
        return this.checkBoxTree.getCheckBoxTreeSelectionModel().getSelectionPaths() != null;
    }

    @Override
    public void selectRasterDataNodes(String[] nodeNames) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.checkBoxTree.getModel().getRoot();
        this.selectRasterDataNodes(rootNode, nodeNames);
    }

    private void selectRasterDataNodes(DefaultMutableTreeNode node, String[] nodeNames) {
        int childCount = node.getChildCount();
        if (childCount != 0) {
            for (int i = 0; i < childCount; ++i) {
                this.selectRasterDataNodes((DefaultMutableTreeNode)node.getChildAt(i), nodeNames);
            }
        } else {
            for (String nodeName : nodeNames) {
                if (!nodeName.equals(((String)node.getUserObject()).split(" ")[0].trim())) continue;
                ArrayList<DefaultMutableTreeNode> pathList = new ArrayList<DefaultMutableTreeNode>();
                for (TreeNode currentNode = node; currentNode != null; currentNode = currentNode.getParent()) {
                    pathList.add(0, (DefaultMutableTreeNode)currentNode);
                }
                TreePath path = new TreePath(pathList.toArray(new TreeNode[pathList.size()]));
                this.checkBoxTree.getCheckBoxTreeSelectionModel().addSelectionPath(path);
            }
        }
    }
}

