/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.ValidationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractListModel;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.util.logging.BeamLogManager;

class InputListModel
extends AbstractListModel<Object> {
    private final List<Object> list = new ArrayList<Object>();
    private List<Product> sourceProducts = new ArrayList<Product>();
    private Property sourceProductPaths;
    private boolean internalPropertyChange;

    InputListModel() {
    }

    @Override
    public Object getElementAt(int index) {
        return this.list.get(index);
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    Product[] getSourceProducts() {
        return this.sourceProducts.toArray(new Product[this.sourceProducts.size()]);
    }

    void setElements(String[] elements) throws ValidationException {
        if (!this.list.isEmpty()) {
            int endIndex = this.list.size() - 1;
            this.list.clear();
            this.fireIntervalRemoved(this, 0, endIndex);
        }
        Object[] files = new File[elements.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(elements[i]);
        }
        this.addElements(files);
    }

    void addElements(Object ... elements) throws ValidationException {
        int startIndex = this.list.size();
        for (Object element : elements) {
            if (!(element instanceof File) && !(element instanceof Product)) {
                throw new IllegalStateException("Only java.io.File or org.esa.beam.framework.datamodel.Product allowed.");
            }
            if (!this.mayAdd(element)) continue;
            this.list.add(element);
        }
        this.updateProperty();
        this.fireIntervalAdded(this, startIndex, this.list.size() - 1);
    }

    void clear() {
        if (!this.list.isEmpty()) {
            int endIndex = this.list.size() - 1;
            this.list.clear();
            try {
                this.updateProperty();
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
            this.fireIntervalRemoved(this, 0, endIndex);
        }
    }

    void removeElementsAt(int[] selectedIndices) {
        ArrayList<Object> toRemove = new ArrayList<Object>();
        int startIndex = Integer.MAX_VALUE;
        int endIndex = Integer.MIN_VALUE;
        for (int selectedIndex : selectedIndices) {
            startIndex = Math.min(startIndex, selectedIndex);
            endIndex = Math.max(endIndex, selectedIndex);
            toRemove.add(this.list.get(selectedIndex));
        }
        if (this.list.removeAll(toRemove)) {
            try {
                this.updateProperty();
            }
            catch (ValidationException ignored) {
                // empty catch block
            }
            this.fireIntervalRemoved(this, startIndex, endIndex);
        }
    }

    private void updateProperty() throws ValidationException {
        ArrayList<String> files = new ArrayList<String>();
        ArrayList<Product> products = new ArrayList<Product>();
        for (Object element : this.list) {
            if (element instanceof File) {
                files.add(((File)element).getPath());
                continue;
            }
            if (!(element instanceof Product)) continue;
            products.add((Product)element);
        }
        this.internalPropertyChange = true;
        this.sourceProductPaths.setValue((Object)files.toArray(new String[files.size()]));
        this.internalPropertyChange = false;
        this.sourceProducts = products;
    }

    private boolean mayAdd(Object element) {
        if (this.list.contains(element)) {
            return false;
        }
        if (element instanceof Product) {
            return true;
        }
        File file = (File)element;
        return file.isDirectory() || !this.alreadyContained(file);
    }

    private boolean alreadyContained(File file) {
        for (Product sourceProduct : this.sourceProducts) {
            File fileLocation = sourceProduct.getFileLocation();
            if (fileLocation == null || !fileLocation.getAbsolutePath().equals(file.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    public void setProperty(Property property) {
        this.sourceProductPaths = property;
        if (this.sourceProductPaths != null && this.sourceProductPaths.getContainer() != null) {
            this.sourceProductPaths.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!InputListModel.this.internalPropertyChange) {
                        Object newValue = evt.getNewValue();
                        try {
                            if (newValue == null) {
                                InputListModel.this.clear();
                            } else {
                                InputListModel.this.setElements((String[])newValue);
                            }
                        }
                        catch (ValidationException e) {
                            BeamLogManager.getSystemLogger().log(Level.SEVERE, "Problems at setElements.", e);
                        }
                    }
                }
            });
        }
    }

    public Property getProperty() {
        return this.sourceProductPaths;
    }
}

