/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.esa.beam.framework.ui.UIUtils;
import org.esa.beam.framework.ui.product.LoadSaveRasterDataNodesConfigurationsComponent;
import org.esa.beam.framework.ui.tool.ToolButtonFactory;
import org.esa.beam.util.SystemUtils;

public class LoadSaveRasterDataNodesConfigurationsProvider {
    private final LoadSaveRasterDataNodesConfigurationsComponent component;
    private AbstractButton loadButton;
    private AbstractButton saveButton;

    public LoadSaveRasterDataNodesConfigurationsProvider(LoadSaveRasterDataNodesConfigurationsComponent component) {
        this.component = component;
    }

    public AbstractButton getLoadButton() {
        if (this.loadButton == null) {
            this.loadButton = LoadSaveRasterDataNodesConfigurationsProvider.createButton("/com/bc/ceres/swing/actions/icons_22x22/document-open.png");
            this.loadButton.setToolTipText("Load configuration");
            this.loadButton.addActionListener(new LoadConfigurationActionListener());
        }
        return this.loadButton;
    }

    public AbstractButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = LoadSaveRasterDataNodesConfigurationsProvider.createButton("/com/bc/ceres/swing/actions/icons_22x22/document-save.png");
            this.saveButton.setToolTipText("Save configuration");
            this.saveButton.addActionListener(new SaveConfigurationActionListener());
        }
        return this.saveButton;
    }

    private static AbstractButton createButton(String iconPath) {
        return ToolButtonFactory.createButton(UIUtils.loadImageIcon(iconPath), false);
    }

    private static File getSystemAuxDataDir() {
        File file = new File(SystemUtils.getApplicationDataDir(), "beam-ui" + File.separator + "auxdata" + File.separator + "band-sets");
        if (!file.exists()) {
            file.mkdir();
        }
        return file;
    }

    private class SaveConfigurationActionListener
    implements ActionListener {
        private SaveConfigurationActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File currentDirectory = LoadSaveRasterDataNodesConfigurationsProvider.getSystemAuxDataDir();
            JFileChooser fileChooser = new JFileChooser(currentDirectory);
            File suggestedFile = new File(currentDirectory + File.separator + "config.txt");
            int fileCounter = 1;
            while (suggestedFile.exists()) {
                suggestedFile = new File("config" + fileCounter + ".txt");
            }
            fileChooser.setSelectedFile(suggestedFile);
            if (fileChooser.showSaveDialog(LoadSaveRasterDataNodesConfigurationsProvider.this.component.getParent()) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    String[] bandNames;
                    BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                    for (String bandName : bandNames = LoadSaveRasterDataNodesConfigurationsProvider.this.component.getRasterDataNodeNamesToWrite()) {
                        writer.write(bandName + "\n");
                    }
                    writer.close();
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(LoadSaveRasterDataNodesConfigurationsProvider.this.component.getParent(), "Could not save configuration");
                }
            }
        }
    }

    private class LoadConfigurationActionListener
    implements ActionListener {
        private LoadConfigurationActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File currentDirectory = LoadSaveRasterDataNodesConfigurationsProvider.getSystemAuxDataDir();
            JFileChooser fileChooser = new JFileChooser(currentDirectory);
            if (fileChooser.showOpenDialog(LoadSaveRasterDataNodesConfigurationsProvider.this.component.getParent()) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    String readBandName;
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    ArrayList<String> bandNameList = new ArrayList<String>();
                    while ((readBandName = reader.readLine()) != null) {
                        bandNameList.add(readBandName);
                    }
                    reader.close();
                    String[] bandNames = bandNameList.toArray(new String[bandNameList.size()]);
                    LoadSaveRasterDataNodesConfigurationsProvider.this.component.setReadRasterDataNodeNames(bandNames);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(LoadSaveRasterDataNodesConfigurationsProvider.this.component.getParent(), "Could not load configuration");
                }
            }
        }
    }
}

