/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.ui.product;

import com.bc.jexp.Namespace;
import com.bc.jexp.Parser;
import com.bc.jexp.WritableNamespace;
import com.bc.jexp.impl.ParserImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.dataop.barithm.BandArithmetic;
import org.esa.beam.framework.ui.ExpressionPane;
import org.esa.beam.util.PropertyMap;

public class ProductExpressionPane
extends ExpressionPane {
    private Product[] products;
    private Product currentProduct;
    private Product targetProduct;
    private JComboBox productBox;
    private JList nodeList;
    private JCheckBox inclBandsCheck;
    private JCheckBox inclMasksCheck;
    private JCheckBox inclGridsCheck;
    private JCheckBox inclFlagsCheck;

    protected ProductExpressionPane(boolean booleanExpr, Product[] products, Product currentProduct, PropertyMap preferences) {
        super(booleanExpr, null, preferences);
        if (products == null || products.length == 0) {
            throw new IllegalArgumentException("no products given");
        }
        this.products = products;
        this.targetProduct = this.currentProduct = currentProduct != null ? currentProduct : this.products[0];
        this.init();
    }

    public static ProductExpressionPane createBooleanExpressionPane(Product[] products, Product currentProduct, PropertyMap preferences) {
        return new ProductExpressionPane(true, products, currentProduct, preferences);
    }

    public static ProductExpressionPane createGeneralExpressionPane(Product[] products, Product currentProduct, PropertyMap preferences) {
        return new ProductExpressionPane(false, products, currentProduct, preferences);
    }

    public Product getCurrentProduct() {
        return this.currentProduct;
    }

    protected void init() {
        int defaultIndex = Arrays.asList(this.products).indexOf(this.currentProduct);
        WritableNamespace namespace = BandArithmetic.createDefaultNamespace((Product[])this.products, (int)(defaultIndex == -1 ? 0 : defaultIndex));
        this.setParser((Parser)new ParserImpl((Namespace)namespace, false));
        ActionListener resetNodeListAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == ProductExpressionPane.this.productBox) {
                    ProductExpressionPane.this.setCurrentProduct();
                }
                ProductExpressionPane.this.resetNodeList();
            }
        };
        this.inclBandsCheck = new JCheckBox("Show bands");
        this.inclBandsCheck.addActionListener(resetNodeListAL);
        if (!this.isBooleanExpressionPreferred()) {
            this.inclBandsCheck.setSelected(true);
        }
        this.inclMasksCheck = new JCheckBox("Show masks");
        this.inclMasksCheck.addActionListener(resetNodeListAL);
        if (!this.isBooleanExpressionPreferred()) {
            this.inclMasksCheck.setSelected(true);
        }
        this.inclGridsCheck = new JCheckBox("Show tie-point grids");
        this.inclGridsCheck.addActionListener(resetNodeListAL);
        this.inclFlagsCheck = new JCheckBox("Show single flags");
        this.inclFlagsCheck.addActionListener(resetNodeListAL);
        if (this.isBooleanExpressionPreferred()) {
            this.inclFlagsCheck.setSelected(true);
        }
        this.nodeList = this.createPatternList();
        JScrollPane scrollableNodeList = new JScrollPane(this.nodeList);
        Box inclNodeBox = Box.createVerticalBox();
        inclNodeBox.add(this.inclBandsCheck);
        inclNodeBox.add(this.inclMasksCheck);
        inclNodeBox.add(this.inclGridsCheck);
        inclNodeBox.add(this.inclFlagsCheck);
        JPanel nodeListPane = new JPanel(new BorderLayout());
        nodeListPane.add((Component)new JLabel("Data sources: "), "North");
        nodeListPane.add((Component)scrollableNodeList, "Center");
        nodeListPane.add((Component)inclNodeBox, "South");
        JPanel accessoryPane = this.createDefaultAccessoryPane(nodeListPane);
        this.setLeftAccessory(accessoryPane);
        if (this.products.length > 1) {
            ArrayList<String> nameList = new ArrayList<String>(this.products.length);
            for (Product product : this.products) {
                String productName = product.getDisplayName();
                nameList.add(productName);
            }
            String currentProductName = this.currentProduct.getDisplayName();
            String[] productNames = new String[nameList.size()];
            nameList.toArray(productNames);
            this.productBox = new JComboBox<String>(productNames);
            this.productBox.setEditable(false);
            this.productBox.setEnabled(this.products.length > 1);
            this.productBox.addActionListener(resetNodeListAL);
            this.productBox.setSelectedItem(currentProductName);
            JPanel productPane = new JPanel(new BorderLayout());
            productPane.add((Component)new JLabel("Product: "), "West");
            productPane.add((Component)this.productBox, "Center");
            this.setTopAccessory(productPane);
        }
        this.resetNodeList();
    }

    @Override
    public void dispose() {
        this.products = null;
        this.currentProduct = null;
        this.productBox = null;
        this.nodeList = null;
        this.inclBandsCheck = null;
        this.inclGridsCheck = null;
        this.inclFlagsCheck = null;
        super.dispose();
    }

    private void resetNodeList() {
        this.setCurrentProduct();
        ArrayList<String> listEntries = new ArrayList<String>(64);
        if (this.currentProduct != null) {
            String[] flagNames = this.currentProduct.getAllFlagNames();
            boolean hasBands = this.currentProduct.getNumBands() > 0;
            boolean hasMasks = this.currentProduct.getMaskGroup().getNodeCount() > 0;
            boolean hasGrids = this.currentProduct.getNumTiePointGrids() > 0;
            boolean hasFlags = flagNames.length > 0;
            boolean inclBands = this.inclBandsCheck.isSelected();
            boolean inclMasks = this.inclMasksCheck.isSelected();
            boolean inclGrids = this.inclGridsCheck.isSelected();
            boolean inclFlags = this.inclFlagsCheck.isSelected();
            this.inclBandsCheck.setEnabled(hasBands);
            this.inclGridsCheck.setEnabled(hasGrids);
            this.inclFlagsCheck.setEnabled(hasFlags);
            if (!hasBands && inclBands) {
                this.inclBandsCheck.setSelected(false);
                inclBands = false;
            }
            if (!hasMasks && inclMasks) {
                this.inclMasksCheck.setSelected(false);
                inclMasks = false;
            }
            if (!hasGrids && inclGrids) {
                this.inclGridsCheck.setSelected(false);
                inclGrids = false;
            }
            if (!hasFlags && inclFlags) {
                this.inclFlagsCheck.setSelected(false);
                inclFlags = false;
            }
            this.nodeList.setEnabled(inclBands || inclMasks || inclGrids || inclFlags);
            String namePrefix = this.getNodeNamePrefix();
            if (inclBands) {
                ProductExpressionPane.addBandNameRefs(this.currentProduct, namePrefix, listEntries);
            }
            if (inclMasks) {
                ProductExpressionPane.addMaskNameRefs(this.currentProduct, namePrefix, listEntries);
            }
            if (inclGrids) {
                ProductExpressionPane.addGridNameRefs(this.currentProduct, namePrefix, listEntries);
            }
            if (inclFlags) {
                ProductExpressionPane.addFlagNameRefs(namePrefix, flagNames, listEntries);
            }
        } else {
            this.nodeList.setEnabled(false);
            this.inclBandsCheck.setEnabled(false);
            this.inclMasksCheck.setEnabled(false);
            this.inclGridsCheck.setEnabled(false);
            this.inclFlagsCheck.setEnabled(false);
        }
        this.nodeList.setListData(listEntries.toArray());
    }

    private void setCurrentProduct() {
        if (this.productBox != null) {
            int index = this.productBox.getSelectedIndex();
            this.currentProduct = index != -1 ? this.products[index] : null;
        }
    }

    private String getNodeNamePrefix() {
        String namePrefix = this.products.length > 1 || this.currentProduct != this.targetProduct ? BandArithmetic.getProductNodeNamePrefix((Product)this.currentProduct) : "";
        return namePrefix;
    }

    private static void addBandNameRefs(Product product, String namePrefix, List<String> list) {
        for (int j = 0; j < product.getNumBands(); ++j) {
            Band band = product.getBandAt(j);
            list.add(namePrefix + band.getName());
        }
    }

    private static void addMaskNameRefs(Product product, String namePrefix, List<String> list) {
        for (int j = 0; j < product.getMaskGroup().getNodeCount(); ++j) {
            Mask mask = (Mask)product.getMaskGroup().get(j);
            list.add(namePrefix + mask.getName());
        }
    }

    private static void addGridNameRefs(Product product, String namePrefix, List<String> list) {
        for (int j = 0; j < product.getNumTiePointGrids(); ++j) {
            TiePointGrid grid = product.getTiePointGridAt(j);
            list.add(namePrefix + grid.getName());
        }
    }

    private static void addFlagNameRefs(String namePrefix, String[] flagNames, List<String> list) {
        for (String flagName : flagNames) {
            list.add(namePrefix + flagName);
        }
    }
}

